/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.GroupWidgetDefinitionType;
import com.datadog.api.v1.client.model.Widget;
import com.datadog.api.v1.client.model.WidgetLayoutType;
import com.datadog.api.v1.client.model.WidgetTextAlign;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The groups widget allows you to keep similar graphs together on your timeboard. Each group has a custom header, can hold one to many graphs, and is collapsible.")
@JsonPropertyOrder(value={"background_color", "banner_img", "layout_type", "show_title", "title", "title_align", "type", "widgets"})
public class GroupWidgetDefinition {
    public static final String JSON_PROPERTY_BACKGROUND_COLOR = "background_color";
    private String backgroundColor;
    public static final String JSON_PROPERTY_BANNER_IMG = "banner_img";
    private String bannerImg;
    public static final String JSON_PROPERTY_LAYOUT_TYPE = "layout_type";
    private WidgetLayoutType layoutType;
    public static final String JSON_PROPERTY_SHOW_TITLE = "show_title";
    private Boolean showTitle = true;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_TITLE_ALIGN = "title_align";
    private WidgetTextAlign titleAlign;
    public static final String JSON_PROPERTY_TYPE = "type";
    private GroupWidgetDefinitionType type = GroupWidgetDefinitionType.GROUP;
    public static final String JSON_PROPERTY_WIDGETS = "widgets";
    private List<Widget> widgets = new ArrayList<Widget>();

    public GroupWidgetDefinition() {
    }

    @JsonCreator
    public GroupWidgetDefinition(@JsonProperty(required=true, value="layout_type") WidgetLayoutType layoutType, @JsonProperty(required=true, value="type") GroupWidgetDefinitionType type, @JsonProperty(required=true, value="widgets") List<Widget> widgets) {
        this.layoutType = layoutType;
        this.type = type;
        this.widgets = widgets;
    }

    public GroupWidgetDefinition backgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Background color of the group title.")
    @JsonProperty(value="background_color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public GroupWidgetDefinition bannerImg(String bannerImg) {
        this.bannerImg = bannerImg;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL of image to display as a banner for the group.")
    @JsonProperty(value="banner_img")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBannerImg() {
        return this.bannerImg;
    }

    public void setBannerImg(String bannerImg) {
        this.bannerImg = bannerImg;
    }

    public GroupWidgetDefinition layoutType(WidgetLayoutType layoutType) {
        this.layoutType = layoutType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="layout_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public WidgetLayoutType getLayoutType() {
        return this.layoutType;
    }

    public void setLayoutType(WidgetLayoutType layoutType) {
        this.layoutType = layoutType;
    }

    public GroupWidgetDefinition showTitle(Boolean showTitle) {
        this.showTitle = showTitle;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether to show the title or not.")
    @JsonProperty(value="show_title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowTitle() {
        return this.showTitle;
    }

    public void setShowTitle(Boolean showTitle) {
        this.showTitle = showTitle;
    }

    public GroupWidgetDefinition title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Title of the widget.")
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public GroupWidgetDefinition titleAlign(WidgetTextAlign titleAlign) {
        this.titleAlign = titleAlign;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="title_align")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTextAlign getTitleAlign() {
        return this.titleAlign;
    }

    public void setTitleAlign(WidgetTextAlign titleAlign) {
        this.titleAlign = titleAlign;
    }

    public GroupWidgetDefinition type(GroupWidgetDefinitionType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public GroupWidgetDefinitionType getType() {
        return this.type;
    }

    public void setType(GroupWidgetDefinitionType type) {
        this.type = type;
    }

    public GroupWidgetDefinition widgets(List<Widget> widgets) {
        this.widgets = widgets;
        return this;
    }

    public GroupWidgetDefinition addWidgetsItem(Widget widgetsItem) {
        this.widgets.add(widgetsItem);
        return this;
    }

    @ApiModelProperty(example="[{\"definition\":{\"requests\":{\"fill\":{\"q\":\"system.cpu.user\"}},\"type\":\"hostmap\"}}]", required=true, value="List of widget groups.")
    @JsonProperty(value="widgets")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Widget> getWidgets() {
        return this.widgets;
    }

    public void setWidgets(List<Widget> widgets) {
        this.widgets = widgets;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupWidgetDefinition groupWidgetDefinition = (GroupWidgetDefinition)o;
        return Objects.equals(this.backgroundColor, groupWidgetDefinition.backgroundColor) && Objects.equals(this.bannerImg, groupWidgetDefinition.bannerImg) && Objects.equals((Object)this.layoutType, (Object)groupWidgetDefinition.layoutType) && Objects.equals(this.showTitle, groupWidgetDefinition.showTitle) && Objects.equals(this.title, groupWidgetDefinition.title) && Objects.equals((Object)this.titleAlign, (Object)groupWidgetDefinition.titleAlign) && Objects.equals((Object)this.type, (Object)groupWidgetDefinition.type) && Objects.equals(this.widgets, groupWidgetDefinition.widgets);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.backgroundColor, this.bannerImg, this.layoutType, this.showTitle, this.title, this.titleAlign, this.type, this.widgets});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupWidgetDefinition {\n");
        sb.append("    backgroundColor: ").append(this.toIndentedString(this.backgroundColor)).append("\n");
        sb.append("    bannerImg: ").append(this.toIndentedString(this.bannerImg)).append("\n");
        sb.append("    layoutType: ").append(this.toIndentedString((Object)this.layoutType)).append("\n");
        sb.append("    showTitle: ").append(this.toIndentedString(this.showTitle)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    titleAlign: ").append(this.toIndentedString((Object)this.titleAlign)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    widgets: ").append(this.toIndentedString(this.widgets)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

