/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.LogsCategoryProcessorCategory;
import com.datadog.api.v1.client.model.LogsCategoryProcessorType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Use the Category Processor to add a new attribute (without spaces or special characters in the new attribute name) to a log matching a provided search query. Use categories to create groups for an analytical view. For example, URL groups, machine groups, environments, and response time buckets.  **Notes**:  - The syntax of the query is the one of Logs Explorer search bar.   The query can be done on any log attribute or tag, whether it is a facet or not.   Wildcards can also be used inside your query. - Once the log has matched one of the Processor queries, it stops.   Make sure they are properly ordered in case a log could match several queries. - The names of the categories must be unique. - Once defined in the Category Processor, you can map categories to log status using the Log Status Remapper.")
@JsonPropertyOrder(value={"categories", "is_enabled", "name", "target", "type"})
public class LogsCategoryProcessor {
    public static final String JSON_PROPERTY_CATEGORIES = "categories";
    private List<LogsCategoryProcessorCategory> categories = new ArrayList<LogsCategoryProcessorCategory>();
    public static final String JSON_PROPERTY_IS_ENABLED = "is_enabled";
    private Boolean isEnabled = false;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_TARGET = "target";
    private String target;
    public static final String JSON_PROPERTY_TYPE = "type";
    private LogsCategoryProcessorType type = LogsCategoryProcessorType.CATEGORY_PROCESSOR;

    public LogsCategoryProcessor() {
    }

    @JsonCreator
    public LogsCategoryProcessor(@JsonProperty(required=true, value="categories") List<LogsCategoryProcessorCategory> categories, @JsonProperty(required=true, value="target") String target, @JsonProperty(required=true, value="type") LogsCategoryProcessorType type) {
        this.categories = categories;
        this.target = target;
        this.type = type;
    }

    public LogsCategoryProcessor categories(List<LogsCategoryProcessorCategory> categories) {
        this.categories = categories;
        return this;
    }

    public LogsCategoryProcessor addCategoriesItem(LogsCategoryProcessorCategory categoriesItem) {
        this.categories.add(categoriesItem);
        return this;
    }

    @ApiModelProperty(example="[]", required=true, value="Array of filters to match or not a log and their corresponding `name`to assign a custom value to the log.")
    @JsonProperty(value="categories")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<LogsCategoryProcessorCategory> getCategories() {
        return this.categories;
    }

    public void setCategories(List<LogsCategoryProcessorCategory> categories) {
        this.categories = categories;
    }

    public LogsCategoryProcessor isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether or not the processor is enabled.")
    @JsonProperty(value="is_enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public LogsCategoryProcessor name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the processor.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LogsCategoryProcessor target(String target) {
        this.target = target;
        return this;
    }

    @ApiModelProperty(example="", required=true, value="Name of the target attribute which value is defined by the matching category.")
    @JsonProperty(value="target")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public LogsCategoryProcessor type(LogsCategoryProcessorType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogsCategoryProcessorType getType() {
        return this.type;
    }

    public void setType(LogsCategoryProcessorType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsCategoryProcessor logsCategoryProcessor = (LogsCategoryProcessor)o;
        return Objects.equals(this.categories, logsCategoryProcessor.categories) && Objects.equals(this.isEnabled, logsCategoryProcessor.isEnabled) && Objects.equals(this.name, logsCategoryProcessor.name) && Objects.equals(this.target, logsCategoryProcessor.target) && Objects.equals((Object)this.type, (Object)logsCategoryProcessor.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.categories, this.isEnabled, this.name, this.target, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsCategoryProcessor {\n");
        sb.append("    categories: ").append(this.toIndentedString(this.categories)).append("\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

