/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.NotebookCellCreateRequest;
import com.datadog.api.v1.client.model.NotebookGlobalTime;
import com.datadog.api.v1.client.model.NotebookStatus;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The data attributes of a notebook.")
@JsonPropertyOrder(value={"cells", "name", "status", "time"})
public class NotebookCreateDataAttributes {
    public static final String JSON_PROPERTY_CELLS = "cells";
    private List<NotebookCellCreateRequest> cells = new ArrayList<NotebookCellCreateRequest>();
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_STATUS = "status";
    private NotebookStatus status = NotebookStatus.PUBLISHED;
    public static final String JSON_PROPERTY_TIME = "time";
    private NotebookGlobalTime time;

    public NotebookCreateDataAttributes() {
    }

    @JsonCreator
    public NotebookCreateDataAttributes(@JsonProperty(required=true, value="cells") List<NotebookCellCreateRequest> cells, @JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="time") NotebookGlobalTime time) {
        this.cells = cells;
        this.name = name;
        this.time = time;
    }

    public NotebookCreateDataAttributes cells(List<NotebookCellCreateRequest> cells) {
        this.cells = cells;
        return this;
    }

    public NotebookCreateDataAttributes addCellsItem(NotebookCellCreateRequest cellsItem) {
        this.cells.add(cellsItem);
        return this;
    }

    @ApiModelProperty(example="[{\"attributes\":{\"definition\":{\"text\":\"## Some test markdown\\n\\n```js\\nvar x, y;\\nx = 5;\\ny = 6;\\n```\",\"type\":\"markdown\"}},\"type\":\"notebook_cells\"},{\"attributes\":{\"definition\":{\"requests\":[{\"display_type\":\"line\",\"q\":\"avg:system.load.1{*}\",\"style\":{\"line_type\":\"solid\",\"line_width\":\"normal\",\"palette\":\"dog_classic\"}}],\"show_legend\":true,\"type\":\"timeseries\",\"yaxis\":{\"scale\":\"linear\"}},\"graph_size\":\"m\",\"split_by\":{\"keys\":[],\"tags\":[]},\"time\":null},\"type\":\"notebook_cells\"}]", required=true, value="List of cells to display in the notebook.")
    @JsonProperty(value="cells")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<NotebookCellCreateRequest> getCells() {
        return this.cells;
    }

    public void setCells(List<NotebookCellCreateRequest> cells) {
        this.cells = cells;
    }

    public NotebookCreateDataAttributes name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="Example Notebook", required=true, value="The name of the notebook.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NotebookCreateDataAttributes status(NotebookStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public NotebookStatus getStatus() {
        return this.status;
    }

    public void setStatus(NotebookStatus status) {
        this.status = status;
    }

    public NotebookCreateDataAttributes time(NotebookGlobalTime time) {
        this.time = time;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="time")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public NotebookGlobalTime getTime() {
        return this.time;
    }

    public void setTime(NotebookGlobalTime time) {
        this.time = time;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotebookCreateDataAttributes notebookCreateDataAttributes = (NotebookCreateDataAttributes)o;
        return Objects.equals(this.cells, notebookCreateDataAttributes.cells) && Objects.equals(this.name, notebookCreateDataAttributes.name) && Objects.equals((Object)this.status, (Object)notebookCreateDataAttributes.status) && Objects.equals(this.time, notebookCreateDataAttributes.time);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cells, this.name, this.status, this.time});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NotebookCreateDataAttributes {\n");
        sb.append("    cells: ").append(this.toIndentedString(this.cells)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

