/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.NotebookAuthor;
import com.datadog.api.v1.client.model.NotebookCellResponse;
import com.datadog.api.v1.client.model.NotebookGlobalTime;
import com.datadog.api.v1.client.model.NotebookStatus;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The attributes of a notebook in get all response.")
@JsonPropertyOrder(value={"author", "cells", "created", "modified", "name", "status", "time"})
public class NotebooksResponseDataAttributes {
    public static final String JSON_PROPERTY_AUTHOR = "author";
    private NotebookAuthor author;
    public static final String JSON_PROPERTY_CELLS = "cells";
    private List<NotebookCellResponse> cells = null;
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_MODIFIED = "modified";
    private OffsetDateTime modified;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_STATUS = "status";
    private NotebookStatus status = NotebookStatus.PUBLISHED;
    public static final String JSON_PROPERTY_TIME = "time";
    private NotebookGlobalTime time;

    public NotebooksResponseDataAttributes() {
    }

    @JsonCreator
    public NotebooksResponseDataAttributes(@JsonProperty(required=true, value="name") String name) {
        this.name = name;
    }

    public NotebooksResponseDataAttributes author(NotebookAuthor author) {
        this.author = author;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="author")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public NotebookAuthor getAuthor() {
        return this.author;
    }

    public void setAuthor(NotebookAuthor author) {
        this.author = author;
    }

    public NotebooksResponseDataAttributes cells(List<NotebookCellResponse> cells) {
        this.cells = cells;
        return this;
    }

    public NotebooksResponseDataAttributes addCellsItem(NotebookCellResponse cellsItem) {
        if (this.cells == null) {
            this.cells = new ArrayList<NotebookCellResponse>();
        }
        this.cells.add(cellsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of cells to display in the notebook.")
    @JsonProperty(value="cells")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<NotebookCellResponse> getCells() {
        return this.cells;
    }

    public void setCells(List<NotebookCellResponse> cells) {
        this.cells = cells;
    }

    @Nullable
    @ApiModelProperty(example="2021-02-24T23:14:15.173964Z", value="UTC time stamp for when the notebook was created.")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    @Nullable
    @ApiModelProperty(example="2021-02-24T23:15:23.274966Z", value="UTC time stamp for when the notebook was last modified.")
    @JsonProperty(value="modified")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getModified() {
        return this.modified;
    }

    public NotebooksResponseDataAttributes name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="Example Notebook", required=true, value="The name of the notebook.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NotebooksResponseDataAttributes status(NotebookStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public NotebookStatus getStatus() {
        return this.status;
    }

    public void setStatus(NotebookStatus status) {
        this.status = status;
    }

    public NotebooksResponseDataAttributes time(NotebookGlobalTime time) {
        this.time = time;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="time")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public NotebookGlobalTime getTime() {
        return this.time;
    }

    public void setTime(NotebookGlobalTime time) {
        this.time = time;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotebooksResponseDataAttributes notebooksResponseDataAttributes = (NotebooksResponseDataAttributes)o;
        return Objects.equals(this.author, notebooksResponseDataAttributes.author) && Objects.equals(this.cells, notebooksResponseDataAttributes.cells) && Objects.equals(this.created, notebooksResponseDataAttributes.created) && Objects.equals(this.modified, notebooksResponseDataAttributes.modified) && Objects.equals(this.name, notebooksResponseDataAttributes.name) && Objects.equals((Object)this.status, (Object)notebooksResponseDataAttributes.status) && Objects.equals(this.time, notebooksResponseDataAttributes.time);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.author, this.cells, this.created, this.modified, this.name, this.status, this.time});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NotebooksResponseDataAttributes {\n");
        sb.append("    author: ").append(this.toIndentedString(this.author)).append("\n");
        sb.append("    cells: ").append(this.toIndentedString(this.cells)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    modified: ").append(this.toIndentedString(this.modified)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

