/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.ScatterPlotWidgetDefinitionRequests;
import com.datadog.api.v1.client.model.ScatterPlotWidgetDefinitionType;
import com.datadog.api.v1.client.model.WidgetAxis;
import com.datadog.api.v1.client.model.WidgetCustomLink;
import com.datadog.api.v1.client.model.WidgetTextAlign;
import com.datadog.api.v1.client.model.WidgetTime;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The scatter plot visualization allows you to graph a chosen scope over two different metrics with their respective aggregation.")
@JsonPropertyOrder(value={"color_by_groups", "custom_links", "requests", "time", "title", "title_align", "title_size", "type", "xaxis", "yaxis"})
public class ScatterPlotWidgetDefinition {
    public static final String JSON_PROPERTY_COLOR_BY_GROUPS = "color_by_groups";
    private List<String> colorByGroups = null;
    public static final String JSON_PROPERTY_CUSTOM_LINKS = "custom_links";
    private List<WidgetCustomLink> customLinks = null;
    public static final String JSON_PROPERTY_REQUESTS = "requests";
    private ScatterPlotWidgetDefinitionRequests requests;
    public static final String JSON_PROPERTY_TIME = "time";
    private WidgetTime time;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_TITLE_ALIGN = "title_align";
    private WidgetTextAlign titleAlign;
    public static final String JSON_PROPERTY_TITLE_SIZE = "title_size";
    private String titleSize;
    public static final String JSON_PROPERTY_TYPE = "type";
    private ScatterPlotWidgetDefinitionType type = ScatterPlotWidgetDefinitionType.SCATTERPLOT;
    public static final String JSON_PROPERTY_XAXIS = "xaxis";
    private WidgetAxis xaxis;
    public static final String JSON_PROPERTY_YAXIS = "yaxis";
    private WidgetAxis yaxis;

    public ScatterPlotWidgetDefinition() {
    }

    @JsonCreator
    public ScatterPlotWidgetDefinition(@JsonProperty(required=true, value="requests") ScatterPlotWidgetDefinitionRequests requests, @JsonProperty(required=true, value="type") ScatterPlotWidgetDefinitionType type) {
        this.requests = requests;
        this.type = type;
    }

    public ScatterPlotWidgetDefinition colorByGroups(List<String> colorByGroups) {
        this.colorByGroups = colorByGroups;
        return this;
    }

    public ScatterPlotWidgetDefinition addColorByGroupsItem(String colorByGroupsItem) {
        if (this.colorByGroups == null) {
            this.colorByGroups = new ArrayList<String>();
        }
        this.colorByGroups.add(colorByGroupsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of groups used for colors.")
    @JsonProperty(value="color_by_groups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getColorByGroups() {
        return this.colorByGroups;
    }

    public void setColorByGroups(List<String> colorByGroups) {
        this.colorByGroups = colorByGroups;
    }

    public ScatterPlotWidgetDefinition customLinks(List<WidgetCustomLink> customLinks) {
        this.customLinks = customLinks;
        return this;
    }

    public ScatterPlotWidgetDefinition addCustomLinksItem(WidgetCustomLink customLinksItem) {
        if (this.customLinks == null) {
            this.customLinks = new ArrayList<WidgetCustomLink>();
        }
        this.customLinks.add(customLinksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of custom links.")
    @JsonProperty(value="custom_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WidgetCustomLink> getCustomLinks() {
        return this.customLinks;
    }

    public void setCustomLinks(List<WidgetCustomLink> customLinks) {
        this.customLinks = customLinks;
    }

    public ScatterPlotWidgetDefinition requests(ScatterPlotWidgetDefinitionRequests requests) {
        this.requests = requests;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="requests")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ScatterPlotWidgetDefinitionRequests getRequests() {
        return this.requests;
    }

    public void setRequests(ScatterPlotWidgetDefinitionRequests requests) {
        this.requests = requests;
    }

    public ScatterPlotWidgetDefinition time(WidgetTime time) {
        this.time = time;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="time")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTime getTime() {
        return this.time;
    }

    public void setTime(WidgetTime time) {
        this.time = time;
    }

    public ScatterPlotWidgetDefinition title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Title of your widget.")
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ScatterPlotWidgetDefinition titleAlign(WidgetTextAlign titleAlign) {
        this.titleAlign = titleAlign;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="title_align")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTextAlign getTitleAlign() {
        return this.titleAlign;
    }

    public void setTitleAlign(WidgetTextAlign titleAlign) {
        this.titleAlign = titleAlign;
    }

    public ScatterPlotWidgetDefinition titleSize(String titleSize) {
        this.titleSize = titleSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Size of the title.")
    @JsonProperty(value="title_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitleSize() {
        return this.titleSize;
    }

    public void setTitleSize(String titleSize) {
        this.titleSize = titleSize;
    }

    public ScatterPlotWidgetDefinition type(ScatterPlotWidgetDefinitionType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ScatterPlotWidgetDefinitionType getType() {
        return this.type;
    }

    public void setType(ScatterPlotWidgetDefinitionType type) {
        this.type = type;
    }

    public ScatterPlotWidgetDefinition xaxis(WidgetAxis xaxis) {
        this.xaxis = xaxis;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="xaxis")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetAxis getXaxis() {
        return this.xaxis;
    }

    public void setXaxis(WidgetAxis xaxis) {
        this.xaxis = xaxis;
    }

    public ScatterPlotWidgetDefinition yaxis(WidgetAxis yaxis) {
        this.yaxis = yaxis;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="yaxis")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetAxis getYaxis() {
        return this.yaxis;
    }

    public void setYaxis(WidgetAxis yaxis) {
        this.yaxis = yaxis;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScatterPlotWidgetDefinition scatterPlotWidgetDefinition = (ScatterPlotWidgetDefinition)o;
        return Objects.equals(this.colorByGroups, scatterPlotWidgetDefinition.colorByGroups) && Objects.equals(this.customLinks, scatterPlotWidgetDefinition.customLinks) && Objects.equals(this.requests, scatterPlotWidgetDefinition.requests) && Objects.equals(this.time, scatterPlotWidgetDefinition.time) && Objects.equals(this.title, scatterPlotWidgetDefinition.title) && Objects.equals((Object)this.titleAlign, (Object)scatterPlotWidgetDefinition.titleAlign) && Objects.equals(this.titleSize, scatterPlotWidgetDefinition.titleSize) && Objects.equals((Object)this.type, (Object)scatterPlotWidgetDefinition.type) && Objects.equals(this.xaxis, scatterPlotWidgetDefinition.xaxis) && Objects.equals(this.yaxis, scatterPlotWidgetDefinition.yaxis);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.colorByGroups, this.customLinks, this.requests, this.time, this.title, this.titleAlign, this.titleSize, this.type, this.xaxis, this.yaxis});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScatterPlotWidgetDefinition {\n");
        sb.append("    colorByGroups: ").append(this.toIndentedString(this.colorByGroups)).append("\n");
        sb.append("    customLinks: ").append(this.toIndentedString(this.customLinks)).append("\n");
        sb.append("    requests: ").append(this.toIndentedString(this.requests)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    titleAlign: ").append(this.toIndentedString((Object)this.titleAlign)).append("\n");
        sb.append("    titleSize: ").append(this.toIndentedString(this.titleSize)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    xaxis: ").append(this.toIndentedString(this.xaxis)).append("\n");
        sb.append("    yaxis: ").append(this.toIndentedString(this.yaxis)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

