/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Cloud Security Posture Management usage for a given organization for a given hour.")
@JsonPropertyOrder(value={"container_count", "host_count", "hour"})
public class UsageCloudSecurityPostureManagementHour {
    public static final String JSON_PROPERTY_CONTAINER_COUNT = "container_count";
    private Long containerCount;
    public static final String JSON_PROPERTY_HOST_COUNT = "host_count";
    private Long hostCount;
    public static final String JSON_PROPERTY_HOUR = "hour";
    private OffsetDateTime hour;

    public UsageCloudSecurityPostureManagementHour containerCount(Long containerCount) {
        this.containerCount = containerCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of Cloud Security Posture Management containers during a given hour.")
    @JsonProperty(value="container_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getContainerCount() {
        return this.containerCount;
    }

    public void setContainerCount(Long containerCount) {
        this.containerCount = containerCount;
    }

    public UsageCloudSecurityPostureManagementHour hostCount(Long hostCount) {
        this.hostCount = hostCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of Cloud Security Posture Management hosts during a given hour.")
    @JsonProperty(value="host_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getHostCount() {
        return this.hostCount;
    }

    public void setHostCount(Long hostCount) {
        this.hostCount = hostCount;
    }

    public UsageCloudSecurityPostureManagementHour hour(OffsetDateTime hour) {
        this.hour = hour;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The hour for the usage.")
    @JsonProperty(value="hour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getHour() {
        return this.hour;
    }

    public void setHour(OffsetDateTime hour) {
        this.hour = hour;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageCloudSecurityPostureManagementHour usageCloudSecurityPostureManagementHour = (UsageCloudSecurityPostureManagementHour)o;
        return Objects.equals(this.containerCount, usageCloudSecurityPostureManagementHour.containerCount) && Objects.equals(this.hostCount, usageCloudSecurityPostureManagementHour.hostCount) && Objects.equals(this.hour, usageCloudSecurityPostureManagementHour.hour);
    }

    public int hashCode() {
        return Objects.hash(this.containerCount, this.hostCount, this.hour);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageCloudSecurityPostureManagementHour {\n");
        sb.append("    containerCount: ").append(this.toIndentedString(this.containerCount)).append("\n");
        sb.append("    hostCount: ").append(this.toIndentedString(this.hostCount)).append("\n");
        sb.append("    hour: ").append(this.toIndentedString(this.hour)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

