/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.UsageAttributionPagination;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The object containing document metadata.")
@JsonPropertyOrder(value={"day", "month", "pagination"})
public class UsageTopAvgMetricsMetadata {
    public static final String JSON_PROPERTY_DAY = "day";
    private OffsetDateTime day;
    public static final String JSON_PROPERTY_MONTH = "month";
    private OffsetDateTime month;
    public static final String JSON_PROPERTY_PAGINATION = "pagination";
    private UsageAttributionPagination pagination;

    public UsageTopAvgMetricsMetadata day(OffsetDateTime day) {
        this.day = day;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The day value from the user request that contains the returned usage data. (If day was used the request)")
    @JsonProperty(value="day")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getDay() {
        return this.day;
    }

    public void setDay(OffsetDateTime day) {
        this.day = day;
    }

    public UsageTopAvgMetricsMetadata month(OffsetDateTime month) {
        this.month = month;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The month value from the user request that contains the returned usage data. (If month was used the request)")
    @JsonProperty(value="month")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getMonth() {
        return this.month;
    }

    public void setMonth(OffsetDateTime month) {
        this.month = month;
    }

    public UsageTopAvgMetricsMetadata pagination(UsageAttributionPagination pagination) {
        this.pagination = pagination;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="pagination")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UsageAttributionPagination getPagination() {
        return this.pagination;
    }

    public void setPagination(UsageAttributionPagination pagination) {
        this.pagination = pagination;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageTopAvgMetricsMetadata usageTopAvgMetricsMetadata = (UsageTopAvgMetricsMetadata)o;
        return Objects.equals(this.day, usageTopAvgMetricsMetadata.day) && Objects.equals(this.month, usageTopAvgMetricsMetadata.month) && Objects.equals(this.pagination, usageTopAvgMetricsMetadata.pagination);
    }

    public int hashCode() {
        return Objects.hash(this.day, this.month, this.pagination);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageTopAvgMetricsMetadata {\n");
        sb.append("    day: ").append(this.toIndentedString(this.day)).append("\n");
        sb.append("    month: ").append(this.toIndentedString(this.month)).append("\n");
        sb.append("    pagination: ").append(this.toIndentedString(this.pagination)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

