/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client;

import com.datadog.api.v2.client.ApiClient;
import java.util.HashMap;

public class Configuration {
    private static ApiClient defaultApiClient;

    public static ApiClient getDefaultApiClient() {
        String appKeyAuth;
        if (defaultApiClient != null) {
            return defaultApiClient;
        }
        defaultApiClient = new ApiClient();
        String site = System.getenv("DD_SITE");
        if (site != null) {
            HashMap<String, String> serverVariables = new HashMap<String, String>();
            serverVariables.put("site", site);
            defaultApiClient.setServerVariables(serverVariables);
        }
        HashMap<String, String> secrets = new HashMap<String, String>();
        String apiKeyAuth = System.getenv("DD_API_KEY");
        if (apiKeyAuth != null) {
            secrets.put("apiKeyAuth", apiKeyAuth);
        }
        if ((appKeyAuth = System.getenv("DD_APP_KEY")) != null) {
            secrets.put("appKeyAuth", appKeyAuth);
        }
        defaultApiClient.configureApiKeys(secrets);
        return defaultApiClient;
    }

    public static void setDefaultApiClient(ApiClient apiClient) {
        defaultApiClient = apiClient;
    }
}

