/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.CostByOrgResponse;
import com.datadog.api.client.v2.model.HourlyUsageResponse;
import com.datadog.api.client.v2.model.UsageApplicationSecurityMonitoringResponse;
import com.datadog.api.client.v2.model.UsageLambdaTracedInvocationsResponse;
import com.datadog.api.client.v2.model.UsageObservabilityPipelinesResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class UsageMeteringApi {
    private ApiClient apiClient;

    public UsageMeteringApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public UsageMeteringApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CostByOrgResponse getCostByOrg(OffsetDateTime startMonth) throws ApiException {
        return this.getCostByOrgWithHttpInfo(startMonth, new GetCostByOrgOptionalParameters()).getData();
    }

    public CompletableFuture<CostByOrgResponse> getCostByOrgAsync(OffsetDateTime startMonth) {
        return this.getCostByOrgWithHttpInfoAsync(startMonth, new GetCostByOrgOptionalParameters()).thenApply(response -> (CostByOrgResponse)response.getData());
    }

    public CostByOrgResponse getCostByOrg(OffsetDateTime startMonth, GetCostByOrgOptionalParameters parameters) throws ApiException {
        return this.getCostByOrgWithHttpInfo(startMonth, parameters).getData();
    }

    public CompletableFuture<CostByOrgResponse> getCostByOrgAsync(OffsetDateTime startMonth, GetCostByOrgOptionalParameters parameters) {
        return this.getCostByOrgWithHttpInfoAsync(startMonth, parameters).thenApply(response -> (CostByOrgResponse)response.getData());
    }

    public ApiResponse<CostByOrgResponse> getCostByOrgWithHttpInfo(OffsetDateTime startMonth, GetCostByOrgOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startMonth == null) {
            throw new ApiException(400, "Missing the required parameter 'startMonth' when calling getCostByOrg");
        }
        OffsetDateTime endMonth = parameters.endMonth;
        String localVarPath = "/api/v2/usage/cost_by_org";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_month", startMonth));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_month", endMonth));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.UsageMeteringApi.getCostByOrg", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json;datetime-format=rfc3339"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CostByOrgResponse>(){});
    }

    public CompletableFuture<ApiResponse<CostByOrgResponse>> getCostByOrgWithHttpInfoAsync(OffsetDateTime startMonth, GetCostByOrgOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (startMonth == null) {
            CompletableFuture<ApiResponse<CostByOrgResponse>> result = new CompletableFuture<ApiResponse<CostByOrgResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'startMonth' when calling getCostByOrg"));
            return result;
        }
        OffsetDateTime endMonth = parameters.endMonth;
        String localVarPath = "/api/v2/usage/cost_by_org";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_month", startMonth));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_month", endMonth));
        try {
            builder = this.apiClient.createBuilder("UsageMeteringApi.getCostByOrg", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json;datetime-format=rfc3339"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CostByOrgResponse>> result = new CompletableFuture<ApiResponse<CostByOrgResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CostByOrgResponse>(){});
    }

    public CostByOrgResponse getEstimatedCostByOrg(String view) throws ApiException {
        return this.getEstimatedCostByOrgWithHttpInfo(view, new GetEstimatedCostByOrgOptionalParameters()).getData();
    }

    public CompletableFuture<CostByOrgResponse> getEstimatedCostByOrgAsync(String view) {
        return this.getEstimatedCostByOrgWithHttpInfoAsync(view, new GetEstimatedCostByOrgOptionalParameters()).thenApply(response -> (CostByOrgResponse)response.getData());
    }

    public CostByOrgResponse getEstimatedCostByOrg(String view, GetEstimatedCostByOrgOptionalParameters parameters) throws ApiException {
        return this.getEstimatedCostByOrgWithHttpInfo(view, parameters).getData();
    }

    public CompletableFuture<CostByOrgResponse> getEstimatedCostByOrgAsync(String view, GetEstimatedCostByOrgOptionalParameters parameters) {
        return this.getEstimatedCostByOrgWithHttpInfoAsync(view, parameters).thenApply(response -> (CostByOrgResponse)response.getData());
    }

    public ApiResponse<CostByOrgResponse> getEstimatedCostByOrgWithHttpInfo(String view, GetEstimatedCostByOrgOptionalParameters parameters) throws ApiException {
        String operationId = "getEstimatedCostByOrg";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (view == null) {
            throw new ApiException(400, "Missing the required parameter 'view' when calling getEstimatedCostByOrg");
        }
        OffsetDateTime startMonth = parameters.startMonth;
        OffsetDateTime endMonth = parameters.endMonth;
        OffsetDateTime startDate = parameters.startDate;
        OffsetDateTime endDate = parameters.endDate;
        String localVarPath = "/api/v2/usage/estimated_cost";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "view", view));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_month", startMonth));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_month", endMonth));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_date", startDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_date", endDate));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.UsageMeteringApi.getEstimatedCostByOrg", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json;datetime-format=rfc3339"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CostByOrgResponse>(){});
    }

    public CompletableFuture<ApiResponse<CostByOrgResponse>> getEstimatedCostByOrgWithHttpInfoAsync(String view, GetEstimatedCostByOrgOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "getEstimatedCostByOrg";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<CostByOrgResponse>> result = new CompletableFuture<ApiResponse<CostByOrgResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (view == null) {
            CompletableFuture<ApiResponse<CostByOrgResponse>> result = new CompletableFuture<ApiResponse<CostByOrgResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'view' when calling getEstimatedCostByOrg"));
            return result;
        }
        OffsetDateTime startMonth = parameters.startMonth;
        OffsetDateTime endMonth = parameters.endMonth;
        OffsetDateTime startDate = parameters.startDate;
        OffsetDateTime endDate = parameters.endDate;
        String localVarPath = "/api/v2/usage/estimated_cost";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "view", view));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_month", startMonth));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_month", endMonth));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_date", startDate));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_date", endDate));
        try {
            builder = this.apiClient.createBuilder("UsageMeteringApi.getEstimatedCostByOrg", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json;datetime-format=rfc3339"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CostByOrgResponse>> result = new CompletableFuture<ApiResponse<CostByOrgResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CostByOrgResponse>(){});
    }

    public HourlyUsageResponse getHourlyUsage(OffsetDateTime filterTimestampStart, String filterProductFamilies) throws ApiException {
        return this.getHourlyUsageWithHttpInfo(filterTimestampStart, filterProductFamilies, new GetHourlyUsageOptionalParameters()).getData();
    }

    public CompletableFuture<HourlyUsageResponse> getHourlyUsageAsync(OffsetDateTime filterTimestampStart, String filterProductFamilies) {
        return this.getHourlyUsageWithHttpInfoAsync(filterTimestampStart, filterProductFamilies, new GetHourlyUsageOptionalParameters()).thenApply(response -> (HourlyUsageResponse)response.getData());
    }

    public HourlyUsageResponse getHourlyUsage(OffsetDateTime filterTimestampStart, String filterProductFamilies, GetHourlyUsageOptionalParameters parameters) throws ApiException {
        return this.getHourlyUsageWithHttpInfo(filterTimestampStart, filterProductFamilies, parameters).getData();
    }

    public CompletableFuture<HourlyUsageResponse> getHourlyUsageAsync(OffsetDateTime filterTimestampStart, String filterProductFamilies, GetHourlyUsageOptionalParameters parameters) {
        return this.getHourlyUsageWithHttpInfoAsync(filterTimestampStart, filterProductFamilies, parameters).thenApply(response -> (HourlyUsageResponse)response.getData());
    }

    public ApiResponse<HourlyUsageResponse> getHourlyUsageWithHttpInfo(OffsetDateTime filterTimestampStart, String filterProductFamilies, GetHourlyUsageOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (filterTimestampStart == null) {
            throw new ApiException(400, "Missing the required parameter 'filterTimestampStart' when calling getHourlyUsage");
        }
        if (filterProductFamilies == null) {
            throw new ApiException(400, "Missing the required parameter 'filterProductFamilies' when calling getHourlyUsage");
        }
        OffsetDateTime filterTimestampEnd = parameters.filterTimestampEnd;
        Boolean filterIncludeDescendants = parameters.filterIncludeDescendants;
        String filterVersions = parameters.filterVersions;
        Integer pageLimit = parameters.pageLimit;
        String pageNextRecordId = parameters.pageNextRecordId;
        String localVarPath = "/api/v2/usage/hourly_usage";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[timestamp][start]", filterTimestampStart));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[product_families]", filterProductFamilies));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[timestamp][end]", filterTimestampEnd));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[include_descendants]", filterIncludeDescendants));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[versions]", filterVersions));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[next_record_id]", pageNextRecordId));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.UsageMeteringApi.getHourlyUsage", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json;datetime-format=rfc3339"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<HourlyUsageResponse>(){});
    }

    public CompletableFuture<ApiResponse<HourlyUsageResponse>> getHourlyUsageWithHttpInfoAsync(OffsetDateTime filterTimestampStart, String filterProductFamilies, GetHourlyUsageOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (filterTimestampStart == null) {
            CompletableFuture<ApiResponse<HourlyUsageResponse>> result = new CompletableFuture<ApiResponse<HourlyUsageResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'filterTimestampStart' when calling getHourlyUsage"));
            return result;
        }
        if (filterProductFamilies == null) {
            CompletableFuture<ApiResponse<HourlyUsageResponse>> result = new CompletableFuture<ApiResponse<HourlyUsageResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'filterProductFamilies' when calling getHourlyUsage"));
            return result;
        }
        OffsetDateTime filterTimestampEnd = parameters.filterTimestampEnd;
        Boolean filterIncludeDescendants = parameters.filterIncludeDescendants;
        String filterVersions = parameters.filterVersions;
        Integer pageLimit = parameters.pageLimit;
        String pageNextRecordId = parameters.pageNextRecordId;
        String localVarPath = "/api/v2/usage/hourly_usage";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[timestamp][start]", filterTimestampStart));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[product_families]", filterProductFamilies));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[timestamp][end]", filterTimestampEnd));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[include_descendants]", filterIncludeDescendants));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[versions]", filterVersions));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[next_record_id]", pageNextRecordId));
        try {
            builder = this.apiClient.createBuilder("UsageMeteringApi.getHourlyUsage", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json;datetime-format=rfc3339"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<HourlyUsageResponse>> result = new CompletableFuture<ApiResponse<HourlyUsageResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<HourlyUsageResponse>(){});
    }

    public UsageApplicationSecurityMonitoringResponse getUsageApplicationSecurityMonitoring(OffsetDateTime startHr) throws ApiException {
        return this.getUsageApplicationSecurityMonitoringWithHttpInfo(startHr, new GetUsageApplicationSecurityMonitoringOptionalParameters()).getData();
    }

    public CompletableFuture<UsageApplicationSecurityMonitoringResponse> getUsageApplicationSecurityMonitoringAsync(OffsetDateTime startHr) {
        return this.getUsageApplicationSecurityMonitoringWithHttpInfoAsync(startHr, new GetUsageApplicationSecurityMonitoringOptionalParameters()).thenApply(response -> (UsageApplicationSecurityMonitoringResponse)response.getData());
    }

    public UsageApplicationSecurityMonitoringResponse getUsageApplicationSecurityMonitoring(OffsetDateTime startHr, GetUsageApplicationSecurityMonitoringOptionalParameters parameters) throws ApiException {
        return this.getUsageApplicationSecurityMonitoringWithHttpInfo(startHr, parameters).getData();
    }

    public CompletableFuture<UsageApplicationSecurityMonitoringResponse> getUsageApplicationSecurityMonitoringAsync(OffsetDateTime startHr, GetUsageApplicationSecurityMonitoringOptionalParameters parameters) {
        return this.getUsageApplicationSecurityMonitoringWithHttpInfoAsync(startHr, parameters).thenApply(response -> (UsageApplicationSecurityMonitoringResponse)response.getData());
    }

    public ApiResponse<UsageApplicationSecurityMonitoringResponse> getUsageApplicationSecurityMonitoringWithHttpInfo(OffsetDateTime startHr, GetUsageApplicationSecurityMonitoringOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageApplicationSecurityMonitoring");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v2/usage/application_security";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.UsageMeteringApi.getUsageApplicationSecurityMonitoring", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json;datetime-format=rfc3339"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UsageApplicationSecurityMonitoringResponse>(){});
    }

    public CompletableFuture<ApiResponse<UsageApplicationSecurityMonitoringResponse>> getUsageApplicationSecurityMonitoringWithHttpInfoAsync(OffsetDateTime startHr, GetUsageApplicationSecurityMonitoringOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (startHr == null) {
            CompletableFuture<ApiResponse<UsageApplicationSecurityMonitoringResponse>> result = new CompletableFuture<ApiResponse<UsageApplicationSecurityMonitoringResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageApplicationSecurityMonitoring"));
            return result;
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v2/usage/application_security";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        try {
            builder = this.apiClient.createBuilder("UsageMeteringApi.getUsageApplicationSecurityMonitoring", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json;datetime-format=rfc3339"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<UsageApplicationSecurityMonitoringResponse>> result = new CompletableFuture<ApiResponse<UsageApplicationSecurityMonitoringResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UsageApplicationSecurityMonitoringResponse>(){});
    }

    public UsageLambdaTracedInvocationsResponse getUsageLambdaTracedInvocations(OffsetDateTime startHr) throws ApiException {
        return this.getUsageLambdaTracedInvocationsWithHttpInfo(startHr, new GetUsageLambdaTracedInvocationsOptionalParameters()).getData();
    }

    public CompletableFuture<UsageLambdaTracedInvocationsResponse> getUsageLambdaTracedInvocationsAsync(OffsetDateTime startHr) {
        return this.getUsageLambdaTracedInvocationsWithHttpInfoAsync(startHr, new GetUsageLambdaTracedInvocationsOptionalParameters()).thenApply(response -> (UsageLambdaTracedInvocationsResponse)response.getData());
    }

    public UsageLambdaTracedInvocationsResponse getUsageLambdaTracedInvocations(OffsetDateTime startHr, GetUsageLambdaTracedInvocationsOptionalParameters parameters) throws ApiException {
        return this.getUsageLambdaTracedInvocationsWithHttpInfo(startHr, parameters).getData();
    }

    public CompletableFuture<UsageLambdaTracedInvocationsResponse> getUsageLambdaTracedInvocationsAsync(OffsetDateTime startHr, GetUsageLambdaTracedInvocationsOptionalParameters parameters) {
        return this.getUsageLambdaTracedInvocationsWithHttpInfoAsync(startHr, parameters).thenApply(response -> (UsageLambdaTracedInvocationsResponse)response.getData());
    }

    public ApiResponse<UsageLambdaTracedInvocationsResponse> getUsageLambdaTracedInvocationsWithHttpInfo(OffsetDateTime startHr, GetUsageLambdaTracedInvocationsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageLambdaTracedInvocations");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v2/usage/lambda_traced_invocations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.UsageMeteringApi.getUsageLambdaTracedInvocations", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json;datetime-format=rfc3339"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UsageLambdaTracedInvocationsResponse>(){});
    }

    public CompletableFuture<ApiResponse<UsageLambdaTracedInvocationsResponse>> getUsageLambdaTracedInvocationsWithHttpInfoAsync(OffsetDateTime startHr, GetUsageLambdaTracedInvocationsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (startHr == null) {
            CompletableFuture<ApiResponse<UsageLambdaTracedInvocationsResponse>> result = new CompletableFuture<ApiResponse<UsageLambdaTracedInvocationsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageLambdaTracedInvocations"));
            return result;
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v2/usage/lambda_traced_invocations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        try {
            builder = this.apiClient.createBuilder("UsageMeteringApi.getUsageLambdaTracedInvocations", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json;datetime-format=rfc3339"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<UsageLambdaTracedInvocationsResponse>> result = new CompletableFuture<ApiResponse<UsageLambdaTracedInvocationsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UsageLambdaTracedInvocationsResponse>(){});
    }

    public UsageObservabilityPipelinesResponse getUsageObservabilityPipelines(OffsetDateTime startHr) throws ApiException {
        return this.getUsageObservabilityPipelinesWithHttpInfo(startHr, new GetUsageObservabilityPipelinesOptionalParameters()).getData();
    }

    public CompletableFuture<UsageObservabilityPipelinesResponse> getUsageObservabilityPipelinesAsync(OffsetDateTime startHr) {
        return this.getUsageObservabilityPipelinesWithHttpInfoAsync(startHr, new GetUsageObservabilityPipelinesOptionalParameters()).thenApply(response -> (UsageObservabilityPipelinesResponse)response.getData());
    }

    public UsageObservabilityPipelinesResponse getUsageObservabilityPipelines(OffsetDateTime startHr, GetUsageObservabilityPipelinesOptionalParameters parameters) throws ApiException {
        return this.getUsageObservabilityPipelinesWithHttpInfo(startHr, parameters).getData();
    }

    public CompletableFuture<UsageObservabilityPipelinesResponse> getUsageObservabilityPipelinesAsync(OffsetDateTime startHr, GetUsageObservabilityPipelinesOptionalParameters parameters) {
        return this.getUsageObservabilityPipelinesWithHttpInfoAsync(startHr, parameters).thenApply(response -> (UsageObservabilityPipelinesResponse)response.getData());
    }

    public ApiResponse<UsageObservabilityPipelinesResponse> getUsageObservabilityPipelinesWithHttpInfo(OffsetDateTime startHr, GetUsageObservabilityPipelinesOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageObservabilityPipelines");
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v2/usage/observability_pipelines";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.UsageMeteringApi.getUsageObservabilityPipelines", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json;datetime-format=rfc3339"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UsageObservabilityPipelinesResponse>(){});
    }

    public CompletableFuture<ApiResponse<UsageObservabilityPipelinesResponse>> getUsageObservabilityPipelinesWithHttpInfoAsync(OffsetDateTime startHr, GetUsageObservabilityPipelinesOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (startHr == null) {
            CompletableFuture<ApiResponse<UsageObservabilityPipelinesResponse>> result = new CompletableFuture<ApiResponse<UsageObservabilityPipelinesResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageObservabilityPipelines"));
            return result;
        }
        OffsetDateTime endHr = parameters.endHr;
        String localVarPath = "/api/v2/usage/observability_pipelines";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        try {
            builder = this.apiClient.createBuilder("UsageMeteringApi.getUsageObservabilityPipelines", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json;datetime-format=rfc3339"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<UsageObservabilityPipelinesResponse>> result = new CompletableFuture<ApiResponse<UsageObservabilityPipelinesResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UsageObservabilityPipelinesResponse>(){});
    }

    public static class GetUsageObservabilityPipelinesOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageObservabilityPipelinesOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageLambdaTracedInvocationsOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageLambdaTracedInvocationsOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetUsageApplicationSecurityMonitoringOptionalParameters {
        private OffsetDateTime endHr;

        public GetUsageApplicationSecurityMonitoringOptionalParameters endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }
    }

    public static class GetHourlyUsageOptionalParameters {
        private OffsetDateTime filterTimestampEnd;
        private Boolean filterIncludeDescendants;
        private String filterVersions;
        private Integer pageLimit;
        private String pageNextRecordId;

        public GetHourlyUsageOptionalParameters filterTimestampEnd(OffsetDateTime filterTimestampEnd) {
            this.filterTimestampEnd = filterTimestampEnd;
            return this;
        }

        public GetHourlyUsageOptionalParameters filterIncludeDescendants(Boolean filterIncludeDescendants) {
            this.filterIncludeDescendants = filterIncludeDescendants;
            return this;
        }

        public GetHourlyUsageOptionalParameters filterVersions(String filterVersions) {
            this.filterVersions = filterVersions;
            return this;
        }

        public GetHourlyUsageOptionalParameters pageLimit(Integer pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        }

        public GetHourlyUsageOptionalParameters pageNextRecordId(String pageNextRecordId) {
            this.pageNextRecordId = pageNextRecordId;
            return this;
        }
    }

    public static class GetEstimatedCostByOrgOptionalParameters {
        private OffsetDateTime startMonth;
        private OffsetDateTime endMonth;
        private OffsetDateTime startDate;
        private OffsetDateTime endDate;

        public GetEstimatedCostByOrgOptionalParameters startMonth(OffsetDateTime startMonth) {
            this.startMonth = startMonth;
            return this;
        }

        public GetEstimatedCostByOrgOptionalParameters endMonth(OffsetDateTime endMonth) {
            this.endMonth = endMonth;
            return this;
        }

        public GetEstimatedCostByOrgOptionalParameters startDate(OffsetDateTime startDate) {
            this.startDate = startDate;
            return this;
        }

        public GetEstimatedCostByOrgOptionalParameters endDate(OffsetDateTime endDate) {
            this.endDate = endDate;
            return this;
        }
    }

    public static class GetCostByOrgOptionalParameters {
        private OffsetDateTime endMonth;

        public GetCostByOrgOptionalParameters endMonth(OffsetDateTime endMonth) {
            this.endMonth = endMonth;
            return this;
        }
    }
}

