/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.EventQueryDefinition;
import com.datadog.api.client.v1.model.FormulaAndFunctionQueryDefinition;
import com.datadog.api.client.v1.model.FormulaAndFunctionResponseFormat;
import com.datadog.api.client.v1.model.LogQueryDefinition;
import com.datadog.api.client.v1.model.ProcessQueryDefinition;
import com.datadog.api.client.v1.model.WidgetFormula;
import com.datadog.api.client.v1.model.WidgetStyle;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"apm_query", "event_query", "formulas", "log_query", "network_query", "process_query", "profile_metrics_query", "q", "queries", "response_format", "rum_query", "security_query", "style"})
public class HeatMapWidgetRequest {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_APM_QUERY = "apm_query";
    private LogQueryDefinition apmQuery;
    public static final String JSON_PROPERTY_EVENT_QUERY = "event_query";
    private EventQueryDefinition eventQuery;
    public static final String JSON_PROPERTY_FORMULAS = "formulas";
    private List<WidgetFormula> formulas = null;
    public static final String JSON_PROPERTY_LOG_QUERY = "log_query";
    private LogQueryDefinition logQuery;
    public static final String JSON_PROPERTY_NETWORK_QUERY = "network_query";
    private LogQueryDefinition networkQuery;
    public static final String JSON_PROPERTY_PROCESS_QUERY = "process_query";
    private ProcessQueryDefinition processQuery;
    public static final String JSON_PROPERTY_PROFILE_METRICS_QUERY = "profile_metrics_query";
    private LogQueryDefinition profileMetricsQuery;
    public static final String JSON_PROPERTY_Q = "q";
    private String q;
    public static final String JSON_PROPERTY_QUERIES = "queries";
    private List<FormulaAndFunctionQueryDefinition> queries = null;
    public static final String JSON_PROPERTY_RESPONSE_FORMAT = "response_format";
    private FormulaAndFunctionResponseFormat responseFormat;
    public static final String JSON_PROPERTY_RUM_QUERY = "rum_query";
    private LogQueryDefinition rumQuery;
    public static final String JSON_PROPERTY_SECURITY_QUERY = "security_query";
    private LogQueryDefinition securityQuery;
    public static final String JSON_PROPERTY_STYLE = "style";
    private WidgetStyle style;
    private Map<String, Object> additionalProperties;

    public HeatMapWidgetRequest apmQuery(LogQueryDefinition apmQuery) {
        this.apmQuery = apmQuery;
        this.unparsed |= apmQuery.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="apm_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getApmQuery() {
        return this.apmQuery;
    }

    public void setApmQuery(LogQueryDefinition apmQuery) {
        this.apmQuery = apmQuery;
    }

    public HeatMapWidgetRequest eventQuery(EventQueryDefinition eventQuery) {
        this.eventQuery = eventQuery;
        this.unparsed |= eventQuery.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="event_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EventQueryDefinition getEventQuery() {
        return this.eventQuery;
    }

    public void setEventQuery(EventQueryDefinition eventQuery) {
        this.eventQuery = eventQuery;
    }

    public HeatMapWidgetRequest formulas(List<WidgetFormula> formulas) {
        this.formulas = formulas;
        for (WidgetFormula item : formulas) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public HeatMapWidgetRequest addFormulasItem(WidgetFormula formulasItem) {
        if (this.formulas == null) {
            this.formulas = new ArrayList<WidgetFormula>();
        }
        this.formulas.add(formulasItem);
        this.unparsed |= formulasItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="formulas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WidgetFormula> getFormulas() {
        return this.formulas;
    }

    public void setFormulas(List<WidgetFormula> formulas) {
        this.formulas = formulas;
    }

    public HeatMapWidgetRequest logQuery(LogQueryDefinition logQuery) {
        this.logQuery = logQuery;
        this.unparsed |= logQuery.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="log_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getLogQuery() {
        return this.logQuery;
    }

    public void setLogQuery(LogQueryDefinition logQuery) {
        this.logQuery = logQuery;
    }

    public HeatMapWidgetRequest networkQuery(LogQueryDefinition networkQuery) {
        this.networkQuery = networkQuery;
        this.unparsed |= networkQuery.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="network_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getNetworkQuery() {
        return this.networkQuery;
    }

    public void setNetworkQuery(LogQueryDefinition networkQuery) {
        this.networkQuery = networkQuery;
    }

    public HeatMapWidgetRequest processQuery(ProcessQueryDefinition processQuery) {
        this.processQuery = processQuery;
        this.unparsed |= processQuery.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="process_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProcessQueryDefinition getProcessQuery() {
        return this.processQuery;
    }

    public void setProcessQuery(ProcessQueryDefinition processQuery) {
        this.processQuery = processQuery;
    }

    public HeatMapWidgetRequest profileMetricsQuery(LogQueryDefinition profileMetricsQuery) {
        this.profileMetricsQuery = profileMetricsQuery;
        this.unparsed |= profileMetricsQuery.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="profile_metrics_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getProfileMetricsQuery() {
        return this.profileMetricsQuery;
    }

    public void setProfileMetricsQuery(LogQueryDefinition profileMetricsQuery) {
        this.profileMetricsQuery = profileMetricsQuery;
    }

    public HeatMapWidgetRequest q(String q) {
        this.q = q;
        return this;
    }

    @Nullable
    @JsonProperty(value="q")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQ() {
        return this.q;
    }

    public void setQ(String q) {
        this.q = q;
    }

    public HeatMapWidgetRequest queries(List<FormulaAndFunctionQueryDefinition> queries) {
        this.queries = queries;
        for (FormulaAndFunctionQueryDefinition item : queries) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public HeatMapWidgetRequest addQueriesItem(FormulaAndFunctionQueryDefinition queriesItem) {
        if (this.queries == null) {
            this.queries = new ArrayList<FormulaAndFunctionQueryDefinition>();
        }
        this.queries.add(queriesItem);
        this.unparsed |= queriesItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="queries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FormulaAndFunctionQueryDefinition> getQueries() {
        return this.queries;
    }

    public void setQueries(List<FormulaAndFunctionQueryDefinition> queries) {
        this.queries = queries;
    }

    public HeatMapWidgetRequest responseFormat(FormulaAndFunctionResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
        this.unparsed |= !responseFormat.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="response_format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FormulaAndFunctionResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(FormulaAndFunctionResponseFormat responseFormat) {
        if (!responseFormat.isValid()) {
            this.unparsed = true;
        }
        this.responseFormat = responseFormat;
    }

    public HeatMapWidgetRequest rumQuery(LogQueryDefinition rumQuery) {
        this.rumQuery = rumQuery;
        this.unparsed |= rumQuery.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="rum_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getRumQuery() {
        return this.rumQuery;
    }

    public void setRumQuery(LogQueryDefinition rumQuery) {
        this.rumQuery = rumQuery;
    }

    public HeatMapWidgetRequest securityQuery(LogQueryDefinition securityQuery) {
        this.securityQuery = securityQuery;
        this.unparsed |= securityQuery.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="security_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getSecurityQuery() {
        return this.securityQuery;
    }

    public void setSecurityQuery(LogQueryDefinition securityQuery) {
        this.securityQuery = securityQuery;
    }

    public HeatMapWidgetRequest style(WidgetStyle style) {
        this.style = style;
        this.unparsed |= style.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="style")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetStyle getStyle() {
        return this.style;
    }

    public void setStyle(WidgetStyle style) {
        this.style = style;
    }

    @JsonAnySetter
    public HeatMapWidgetRequest putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HeatMapWidgetRequest heatMapWidgetRequest = (HeatMapWidgetRequest)o;
        return Objects.equals(this.apmQuery, heatMapWidgetRequest.apmQuery) && Objects.equals(this.eventQuery, heatMapWidgetRequest.eventQuery) && Objects.equals(this.formulas, heatMapWidgetRequest.formulas) && Objects.equals(this.logQuery, heatMapWidgetRequest.logQuery) && Objects.equals(this.networkQuery, heatMapWidgetRequest.networkQuery) && Objects.equals(this.processQuery, heatMapWidgetRequest.processQuery) && Objects.equals(this.profileMetricsQuery, heatMapWidgetRequest.profileMetricsQuery) && Objects.equals(this.q, heatMapWidgetRequest.q) && Objects.equals(this.queries, heatMapWidgetRequest.queries) && Objects.equals(this.responseFormat, heatMapWidgetRequest.responseFormat) && Objects.equals(this.rumQuery, heatMapWidgetRequest.rumQuery) && Objects.equals(this.securityQuery, heatMapWidgetRequest.securityQuery) && Objects.equals(this.style, heatMapWidgetRequest.style) && Objects.equals(this.additionalProperties, heatMapWidgetRequest.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.apmQuery, this.eventQuery, this.formulas, this.logQuery, this.networkQuery, this.processQuery, this.profileMetricsQuery, this.q, this.queries, this.responseFormat, this.rumQuery, this.securityQuery, this.style, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HeatMapWidgetRequest {\n");
        sb.append("    apmQuery: ").append(this.toIndentedString(this.apmQuery)).append("\n");
        sb.append("    eventQuery: ").append(this.toIndentedString(this.eventQuery)).append("\n");
        sb.append("    formulas: ").append(this.toIndentedString(this.formulas)).append("\n");
        sb.append("    logQuery: ").append(this.toIndentedString(this.logQuery)).append("\n");
        sb.append("    networkQuery: ").append(this.toIndentedString(this.networkQuery)).append("\n");
        sb.append("    processQuery: ").append(this.toIndentedString(this.processQuery)).append("\n");
        sb.append("    profileMetricsQuery: ").append(this.toIndentedString(this.profileMetricsQuery)).append("\n");
        sb.append("    q: ").append(this.toIndentedString(this.q)).append("\n");
        sb.append("    queries: ").append(this.toIndentedString(this.queries)).append("\n");
        sb.append("    responseFormat: ").append(this.toIndentedString(this.responseFormat)).append("\n");
        sb.append("    rumQuery: ").append(this.toIndentedString(this.rumQuery)).append("\n");
        sb.append("    securityQuery: ").append(this.toIndentedString(this.securityQuery)).append("\n");
        sb.append("    style: ").append(this.toIndentedString(this.style)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

