/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.IncidentRelatedObject;
import com.datadog.api.client.v2.model.IncidentServiceCreateRequest;
import com.datadog.api.client.v2.model.IncidentServiceResponse;
import com.datadog.api.client.v2.model.IncidentServiceUpdateRequest;
import com.datadog.api.client.v2.model.IncidentServicesResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class IncidentServicesApi {
    private ApiClient apiClient;

    public IncidentServicesApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public IncidentServicesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public IncidentServiceResponse createIncidentService(IncidentServiceCreateRequest body) throws ApiException {
        return this.createIncidentServiceWithHttpInfo(body).getData();
    }

    public CompletableFuture<IncidentServiceResponse> createIncidentServiceAsync(IncidentServiceCreateRequest body) {
        return this.createIncidentServiceWithHttpInfoAsync(body).thenApply(response -> (IncidentServiceResponse)response.getData());
    }

    public ApiResponse<IncidentServiceResponse> createIncidentServiceWithHttpInfo(IncidentServiceCreateRequest body) throws ApiException {
        String operationId = "createIncidentService";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        IncidentServiceCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createIncidentService");
        }
        String localVarPath = "/api/v2/services";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentServicesApi.createIncidentService", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentServiceResponse>(){});
    }

    public CompletableFuture<ApiResponse<IncidentServiceResponse>> createIncidentServiceWithHttpInfoAsync(IncidentServiceCreateRequest body) {
        Invocation.Builder builder;
        String operationId = "createIncidentService";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<IncidentServiceResponse>> result = new CompletableFuture<ApiResponse<IncidentServiceResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        IncidentServiceCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<IncidentServiceResponse>> result = new CompletableFuture<ApiResponse<IncidentServiceResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createIncidentService"));
            return result;
        }
        String localVarPath = "/api/v2/services";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.IncidentServicesApi.createIncidentService", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentServiceResponse>> result = new CompletableFuture<ApiResponse<IncidentServiceResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentServiceResponse>(){});
    }

    public void deleteIncidentService(String serviceId) throws ApiException {
        this.deleteIncidentServiceWithHttpInfo(serviceId);
    }

    public CompletableFuture<Void> deleteIncidentServiceAsync(String serviceId) {
        return this.deleteIncidentServiceWithHttpInfoAsync(serviceId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteIncidentServiceWithHttpInfo(String serviceId) throws ApiException {
        String operationId = "deleteIncidentService";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (serviceId == null) {
            throw new ApiException(400, "Missing the required parameter 'serviceId' when calling deleteIncidentService");
        }
        String localVarPath = "/api/v2/services/{service_id}".replaceAll("\\{service_id\\}", this.apiClient.escapeString(serviceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentServicesApi.deleteIncidentService", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteIncidentServiceWithHttpInfoAsync(String serviceId) {
        Invocation.Builder builder;
        String operationId = "deleteIncidentService";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (serviceId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'serviceId' when calling deleteIncidentService"));
            return result;
        }
        String localVarPath = "/api/v2/services/{service_id}".replaceAll("\\{service_id\\}", this.apiClient.escapeString(serviceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.IncidentServicesApi.deleteIncidentService", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public IncidentServiceResponse getIncidentService(String serviceId) throws ApiException {
        return this.getIncidentServiceWithHttpInfo(serviceId, new GetIncidentServiceOptionalParameters()).getData();
    }

    public CompletableFuture<IncidentServiceResponse> getIncidentServiceAsync(String serviceId) {
        return this.getIncidentServiceWithHttpInfoAsync(serviceId, new GetIncidentServiceOptionalParameters()).thenApply(response -> (IncidentServiceResponse)response.getData());
    }

    public IncidentServiceResponse getIncidentService(String serviceId, GetIncidentServiceOptionalParameters parameters) throws ApiException {
        return this.getIncidentServiceWithHttpInfo(serviceId, parameters).getData();
    }

    public CompletableFuture<IncidentServiceResponse> getIncidentServiceAsync(String serviceId, GetIncidentServiceOptionalParameters parameters) {
        return this.getIncidentServiceWithHttpInfoAsync(serviceId, parameters).thenApply(response -> (IncidentServiceResponse)response.getData());
    }

    public ApiResponse<IncidentServiceResponse> getIncidentServiceWithHttpInfo(String serviceId, GetIncidentServiceOptionalParameters parameters) throws ApiException {
        String operationId = "getIncidentService";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (serviceId == null) {
            throw new ApiException(400, "Missing the required parameter 'serviceId' when calling getIncidentService");
        }
        IncidentRelatedObject include = parameters.include;
        String localVarPath = "/api/v2/services/{service_id}".replaceAll("\\{service_id\\}", this.apiClient.escapeString(serviceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentServicesApi.getIncidentService", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentServiceResponse>(){});
    }

    public CompletableFuture<ApiResponse<IncidentServiceResponse>> getIncidentServiceWithHttpInfoAsync(String serviceId, GetIncidentServiceOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "getIncidentService";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<IncidentServiceResponse>> result = new CompletableFuture<ApiResponse<IncidentServiceResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (serviceId == null) {
            CompletableFuture<ApiResponse<IncidentServiceResponse>> result = new CompletableFuture<ApiResponse<IncidentServiceResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'serviceId' when calling getIncidentService"));
            return result;
        }
        IncidentRelatedObject include = parameters.include;
        String localVarPath = "/api/v2/services/{service_id}".replaceAll("\\{service_id\\}", this.apiClient.escapeString(serviceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        try {
            builder = this.apiClient.createBuilder("v2.IncidentServicesApi.getIncidentService", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentServiceResponse>> result = new CompletableFuture<ApiResponse<IncidentServiceResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentServiceResponse>(){});
    }

    public IncidentServicesResponse listIncidentServices() throws ApiException {
        return this.listIncidentServicesWithHttpInfo(new ListIncidentServicesOptionalParameters()).getData();
    }

    public CompletableFuture<IncidentServicesResponse> listIncidentServicesAsync() {
        return this.listIncidentServicesWithHttpInfoAsync(new ListIncidentServicesOptionalParameters()).thenApply(response -> (IncidentServicesResponse)response.getData());
    }

    public IncidentServicesResponse listIncidentServices(ListIncidentServicesOptionalParameters parameters) throws ApiException {
        return this.listIncidentServicesWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<IncidentServicesResponse> listIncidentServicesAsync(ListIncidentServicesOptionalParameters parameters) {
        return this.listIncidentServicesWithHttpInfoAsync(parameters).thenApply(response -> (IncidentServicesResponse)response.getData());
    }

    public ApiResponse<IncidentServicesResponse> listIncidentServicesWithHttpInfo(ListIncidentServicesOptionalParameters parameters) throws ApiException {
        String operationId = "listIncidentServices";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        IncidentRelatedObject include = parameters.include;
        Long pageSize = parameters.pageSize;
        Long pageOffset = parameters.pageOffset;
        String filter = parameters.filter;
        String localVarPath = "/api/v2/services";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentServicesApi.listIncidentServices", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentServicesResponse>(){});
    }

    public CompletableFuture<ApiResponse<IncidentServicesResponse>> listIncidentServicesWithHttpInfoAsync(ListIncidentServicesOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "listIncidentServices";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<IncidentServicesResponse>> result = new CompletableFuture<ApiResponse<IncidentServicesResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        IncidentRelatedObject include = parameters.include;
        Long pageSize = parameters.pageSize;
        Long pageOffset = parameters.pageOffset;
        String filter = parameters.filter;
        String localVarPath = "/api/v2/services";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        try {
            builder = this.apiClient.createBuilder("v2.IncidentServicesApi.listIncidentServices", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentServicesResponse>> result = new CompletableFuture<ApiResponse<IncidentServicesResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentServicesResponse>(){});
    }

    public IncidentServiceResponse updateIncidentService(String serviceId, IncidentServiceUpdateRequest body) throws ApiException {
        return this.updateIncidentServiceWithHttpInfo(serviceId, body).getData();
    }

    public CompletableFuture<IncidentServiceResponse> updateIncidentServiceAsync(String serviceId, IncidentServiceUpdateRequest body) {
        return this.updateIncidentServiceWithHttpInfoAsync(serviceId, body).thenApply(response -> (IncidentServiceResponse)response.getData());
    }

    public ApiResponse<IncidentServiceResponse> updateIncidentServiceWithHttpInfo(String serviceId, IncidentServiceUpdateRequest body) throws ApiException {
        String operationId = "updateIncidentService";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        IncidentServiceUpdateRequest localVarPostBody = body;
        if (serviceId == null) {
            throw new ApiException(400, "Missing the required parameter 'serviceId' when calling updateIncidentService");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateIncidentService");
        }
        String localVarPath = "/api/v2/services/{service_id}".replaceAll("\\{service_id\\}", this.apiClient.escapeString(serviceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentServicesApi.updateIncidentService", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentServiceResponse>(){});
    }

    public CompletableFuture<ApiResponse<IncidentServiceResponse>> updateIncidentServiceWithHttpInfoAsync(String serviceId, IncidentServiceUpdateRequest body) {
        Invocation.Builder builder;
        String operationId = "updateIncidentService";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<IncidentServiceResponse>> result = new CompletableFuture<ApiResponse<IncidentServiceResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        IncidentServiceUpdateRequest localVarPostBody = body;
        if (serviceId == null) {
            CompletableFuture<ApiResponse<IncidentServiceResponse>> result = new CompletableFuture<ApiResponse<IncidentServiceResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'serviceId' when calling updateIncidentService"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<IncidentServiceResponse>> result = new CompletableFuture<ApiResponse<IncidentServiceResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateIncidentService"));
            return result;
        }
        String localVarPath = "/api/v2/services/{service_id}".replaceAll("\\{service_id\\}", this.apiClient.escapeString(serviceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.IncidentServicesApi.updateIncidentService", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentServiceResponse>> result = new CompletableFuture<ApiResponse<IncidentServiceResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentServiceResponse>(){});
    }

    public static class ListIncidentServicesOptionalParameters {
        private IncidentRelatedObject include;
        private Long pageSize;
        private Long pageOffset;
        private String filter;

        public ListIncidentServicesOptionalParameters include(IncidentRelatedObject include) {
            this.include = include;
            return this;
        }

        public ListIncidentServicesOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListIncidentServicesOptionalParameters pageOffset(Long pageOffset) {
            this.pageOffset = pageOffset;
            return this;
        }

        public ListIncidentServicesOptionalParameters filter(String filter) {
            this.filter = filter;
            return this;
        }
    }

    public static class GetIncidentServiceOptionalParameters {
        private IncidentRelatedObject include;

        public GetIncidentServiceOptionalParameters include(IncidentRelatedObject include) {
            this.include = include;
            return this;
        }
    }
}

