/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.CIAppAggregateSortType;
import com.datadog.api.client.v2.model.CIAppAggregationFunction;
import com.datadog.api.client.v2.model.CIAppSortOrder;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"aggregation", "metric", "order", "type"})
public class CIAppAggregateSort {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AGGREGATION = "aggregation";
    private CIAppAggregationFunction aggregation;
    public static final String JSON_PROPERTY_METRIC = "metric";
    private String metric;
    public static final String JSON_PROPERTY_ORDER = "order";
    private CIAppSortOrder order;
    public static final String JSON_PROPERTY_TYPE = "type";
    private CIAppAggregateSortType type = CIAppAggregateSortType.ALPHABETICAL;
    private Map<String, Object> additionalProperties;

    public CIAppAggregateSort aggregation(CIAppAggregationFunction aggregation) {
        this.aggregation = aggregation;
        this.unparsed |= !aggregation.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="aggregation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CIAppAggregationFunction getAggregation() {
        return this.aggregation;
    }

    public void setAggregation(CIAppAggregationFunction aggregation) {
        if (!aggregation.isValid()) {
            this.unparsed = true;
        }
        this.aggregation = aggregation;
    }

    public CIAppAggregateSort metric(String metric) {
        this.metric = metric;
        return this;
    }

    @Nullable
    @JsonProperty(value="metric")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMetric() {
        return this.metric;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public CIAppAggregateSort order(CIAppSortOrder order) {
        this.order = order;
        this.unparsed |= !order.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="order")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CIAppSortOrder getOrder() {
        return this.order;
    }

    public void setOrder(CIAppSortOrder order) {
        if (!order.isValid()) {
            this.unparsed = true;
        }
        this.order = order;
    }

    public CIAppAggregateSort type(CIAppAggregateSortType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CIAppAggregateSortType getType() {
        return this.type;
    }

    public void setType(CIAppAggregateSortType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public CIAppAggregateSort putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CIAppAggregateSort ciAppAggregateSort = (CIAppAggregateSort)o;
        return Objects.equals(this.aggregation, ciAppAggregateSort.aggregation) && Objects.equals(this.metric, ciAppAggregateSort.metric) && Objects.equals(this.order, ciAppAggregateSort.order) && Objects.equals(this.type, ciAppAggregateSort.type) && Objects.equals(this.additionalProperties, ciAppAggregateSort.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.aggregation, this.metric, this.order, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CIAppAggregateSort {\n");
        sb.append("    aggregation: ").append(this.toIndentedString(this.aggregation)).append("\n");
        sb.append("    metric: ").append(this.toIndentedString(this.metric)).append("\n");
        sb.append("    order: ").append(this.toIndentedString(this.order)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

