/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.PaginationIterable;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.CIAppQueryPageOptions;
import com.datadog.api.client.v2.model.CIAppSort;
import com.datadog.api.client.v2.model.CIAppTestEvent;
import com.datadog.api.client.v2.model.CIAppTestEventsRequest;
import com.datadog.api.client.v2.model.CIAppTestEventsResponse;
import com.datadog.api.client.v2.model.CIAppTestsAggregateRequest;
import com.datadog.api.client.v2.model.CIAppTestsAnalyticsAggregateResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.CompletableFuture;

public class CiVisibilityTestsApi {
    private ApiClient apiClient;

    public CiVisibilityTestsApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public CiVisibilityTestsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CIAppTestsAnalyticsAggregateResponse aggregateCIAppTestEvents(CIAppTestsAggregateRequest body) throws ApiException {
        return this.aggregateCIAppTestEventsWithHttpInfo(body).getData();
    }

    public CompletableFuture<CIAppTestsAnalyticsAggregateResponse> aggregateCIAppTestEventsAsync(CIAppTestsAggregateRequest body) {
        return this.aggregateCIAppTestEventsWithHttpInfoAsync(body).thenApply(response -> (CIAppTestsAnalyticsAggregateResponse)response.getData());
    }

    public ApiResponse<CIAppTestsAnalyticsAggregateResponse> aggregateCIAppTestEventsWithHttpInfo(CIAppTestsAggregateRequest body) throws ApiException {
        CIAppTestsAggregateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling aggregateCIAppTestEvents");
        }
        String localVarPath = "/api/v2/ci/tests/analytics/aggregate";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CiVisibilityTestsApi.aggregateCIAppTestEvents", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CIAppTestsAnalyticsAggregateResponse>(){});
    }

    public CompletableFuture<ApiResponse<CIAppTestsAnalyticsAggregateResponse>> aggregateCIAppTestEventsWithHttpInfoAsync(CIAppTestsAggregateRequest body) {
        Invocation.Builder builder;
        CIAppTestsAggregateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<CIAppTestsAnalyticsAggregateResponse>> result = new CompletableFuture<ApiResponse<CIAppTestsAnalyticsAggregateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling aggregateCIAppTestEvents"));
            return result;
        }
        String localVarPath = "/api/v2/ci/tests/analytics/aggregate";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CiVisibilityTestsApi.aggregateCIAppTestEvents", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CIAppTestsAnalyticsAggregateResponse>> result = new CompletableFuture<ApiResponse<CIAppTestsAnalyticsAggregateResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CIAppTestsAnalyticsAggregateResponse>(){});
    }

    public CIAppTestEventsResponse listCIAppTestEvents() throws ApiException {
        return this.listCIAppTestEventsWithHttpInfo(new ListCIAppTestEventsOptionalParameters()).getData();
    }

    public CompletableFuture<CIAppTestEventsResponse> listCIAppTestEventsAsync() {
        return this.listCIAppTestEventsWithHttpInfoAsync(new ListCIAppTestEventsOptionalParameters()).thenApply(response -> (CIAppTestEventsResponse)response.getData());
    }

    public CIAppTestEventsResponse listCIAppTestEvents(ListCIAppTestEventsOptionalParameters parameters) throws ApiException {
        return this.listCIAppTestEventsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<CIAppTestEventsResponse> listCIAppTestEventsAsync(ListCIAppTestEventsOptionalParameters parameters) {
        return this.listCIAppTestEventsWithHttpInfoAsync(parameters).thenApply(response -> (CIAppTestEventsResponse)response.getData());
    }

    public PaginationIterable<CIAppTestEvent> listCIAppTestEventsWithPagination() {
        ListCIAppTestEventsOptionalParameters parameters = new ListCIAppTestEventsOptionalParameters();
        return this.listCIAppTestEventsWithPagination(parameters);
    }

    public PaginationIterable<CIAppTestEvent> listCIAppTestEventsWithPagination(ListCIAppTestEventsOptionalParameters parameters) {
        Integer limit;
        String resultsPath = "getData";
        String valueGetterPath = "getMeta.getPage.getAfter";
        String valueSetterPath = "pageCursor";
        Boolean valueSetterParamOptional = true;
        if (parameters.pageLimit == null) {
            limit = 10;
            parameters.pageLimit(limit);
        } else {
            limit = parameters.pageLimit;
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("optionalParams", parameters);
        PaginationIterable<CIAppTestEvent> iterator = new PaginationIterable<CIAppTestEvent>(this, "listCIAppTestEvents", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, limit, args);
        return iterator;
    }

    public ApiResponse<CIAppTestEventsResponse> listCIAppTestEventsWithHttpInfo(ListCIAppTestEventsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        String filterQuery = parameters.filterQuery;
        OffsetDateTime filterFrom = parameters.filterFrom;
        OffsetDateTime filterTo = parameters.filterTo;
        CIAppSort sort = parameters.sort;
        String pageCursor = parameters.pageCursor;
        Integer pageLimit = parameters.pageLimit;
        String localVarPath = "/api/v2/ci/tests/events";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[query]", filterQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[from]", filterFrom));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[to]", filterTo));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[cursor]", pageCursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CiVisibilityTestsApi.listCIAppTestEvents", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CIAppTestEventsResponse>(){});
    }

    public CompletableFuture<ApiResponse<CIAppTestEventsResponse>> listCIAppTestEventsWithHttpInfoAsync(ListCIAppTestEventsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String filterQuery = parameters.filterQuery;
        OffsetDateTime filterFrom = parameters.filterFrom;
        OffsetDateTime filterTo = parameters.filterTo;
        CIAppSort sort = parameters.sort;
        String pageCursor = parameters.pageCursor;
        Integer pageLimit = parameters.pageLimit;
        String localVarPath = "/api/v2/ci/tests/events";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[query]", filterQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[from]", filterFrom));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[to]", filterTo));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[cursor]", pageCursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        try {
            builder = this.apiClient.createBuilder("v2.CiVisibilityTestsApi.listCIAppTestEvents", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CIAppTestEventsResponse>> result = new CompletableFuture<ApiResponse<CIAppTestEventsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CIAppTestEventsResponse>(){});
    }

    public CIAppTestEventsResponse searchCIAppTestEvents() throws ApiException {
        return this.searchCIAppTestEventsWithHttpInfo(new SearchCIAppTestEventsOptionalParameters()).getData();
    }

    public CompletableFuture<CIAppTestEventsResponse> searchCIAppTestEventsAsync() {
        return this.searchCIAppTestEventsWithHttpInfoAsync(new SearchCIAppTestEventsOptionalParameters()).thenApply(response -> (CIAppTestEventsResponse)response.getData());
    }

    public CIAppTestEventsResponse searchCIAppTestEvents(SearchCIAppTestEventsOptionalParameters parameters) throws ApiException {
        return this.searchCIAppTestEventsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<CIAppTestEventsResponse> searchCIAppTestEventsAsync(SearchCIAppTestEventsOptionalParameters parameters) {
        return this.searchCIAppTestEventsWithHttpInfoAsync(parameters).thenApply(response -> (CIAppTestEventsResponse)response.getData());
    }

    public PaginationIterable<CIAppTestEvent> searchCIAppTestEventsWithPagination() {
        SearchCIAppTestEventsOptionalParameters parameters = new SearchCIAppTestEventsOptionalParameters();
        return this.searchCIAppTestEventsWithPagination(parameters);
    }

    public PaginationIterable<CIAppTestEvent> searchCIAppTestEventsWithPagination(SearchCIAppTestEventsOptionalParameters parameters) {
        Integer limit;
        String resultsPath = "getData";
        String valueGetterPath = "getMeta.getPage.getAfter";
        String valueSetterPath = "body.getPage.setCursor";
        Boolean valueSetterParamOptional = true;
        if (parameters.body == null) {
            parameters.body(new CIAppTestEventsRequest());
        }
        if (parameters.body.getPage() == null) {
            parameters.body.setPage(new CIAppQueryPageOptions());
        }
        if (parameters.body.getPage().getLimit() == null) {
            limit = 10;
            parameters.body.getPage().setLimit(limit);
        } else {
            limit = parameters.body.getPage().getLimit();
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("optionalParams", parameters);
        PaginationIterable<CIAppTestEvent> iterator = new PaginationIterable<CIAppTestEvent>(this, "searchCIAppTestEvents", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, limit, args);
        return iterator;
    }

    public ApiResponse<CIAppTestEventsResponse> searchCIAppTestEventsWithHttpInfo(SearchCIAppTestEventsOptionalParameters parameters) throws ApiException {
        CIAppTestEventsRequest localVarPostBody = parameters.body;
        String localVarPath = "/api/v2/ci/tests/events/search";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CiVisibilityTestsApi.searchCIAppTestEvents", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CIAppTestEventsResponse>(){});
    }

    public CompletableFuture<ApiResponse<CIAppTestEventsResponse>> searchCIAppTestEventsWithHttpInfoAsync(SearchCIAppTestEventsOptionalParameters parameters) {
        Invocation.Builder builder;
        CIAppTestEventsRequest localVarPostBody = parameters.body;
        String localVarPath = "/api/v2/ci/tests/events/search";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CiVisibilityTestsApi.searchCIAppTestEvents", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CIAppTestEventsResponse>> result = new CompletableFuture<ApiResponse<CIAppTestEventsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CIAppTestEventsResponse>(){});
    }

    public static class SearchCIAppTestEventsOptionalParameters {
        private CIAppTestEventsRequest body;

        public SearchCIAppTestEventsOptionalParameters body(CIAppTestEventsRequest body) {
            this.body = body;
            return this;
        }
    }

    public static class ListCIAppTestEventsOptionalParameters {
        private String filterQuery;
        private OffsetDateTime filterFrom;
        private OffsetDateTime filterTo;
        private CIAppSort sort;
        private String pageCursor;
        private Integer pageLimit;

        public ListCIAppTestEventsOptionalParameters filterQuery(String filterQuery) {
            this.filterQuery = filterQuery;
            return this;
        }

        public ListCIAppTestEventsOptionalParameters filterFrom(OffsetDateTime filterFrom) {
            this.filterFrom = filterFrom;
            return this;
        }

        public ListCIAppTestEventsOptionalParameters filterTo(OffsetDateTime filterTo) {
            this.filterTo = filterTo;
            return this;
        }

        public ListCIAppTestEventsOptionalParameters sort(CIAppSort sort) {
            this.sort = sort;
            return this;
        }

        public ListCIAppTestEventsOptionalParameters pageCursor(String pageCursor) {
            this.pageCursor = pageCursor;
            return this;
        }

        public ListCIAppTestEventsOptionalParameters pageLimit(Integer pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        }
    }
}

