/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.PaginationIterable;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.IncidentAttachmentAttachmentType;
import com.datadog.api.client.v2.model.IncidentAttachmentRelatedObject;
import com.datadog.api.client.v2.model.IncidentAttachmentUpdateRequest;
import com.datadog.api.client.v2.model.IncidentAttachmentUpdateResponse;
import com.datadog.api.client.v2.model.IncidentAttachmentsResponse;
import com.datadog.api.client.v2.model.IncidentCreateRequest;
import com.datadog.api.client.v2.model.IncidentRelatedObject;
import com.datadog.api.client.v2.model.IncidentResponse;
import com.datadog.api.client.v2.model.IncidentResponseData;
import com.datadog.api.client.v2.model.IncidentUpdateRequest;
import com.datadog.api.client.v2.model.IncidentsResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class IncidentsApi {
    private ApiClient apiClient;

    public IncidentsApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public IncidentsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public IncidentResponse createIncident(IncidentCreateRequest body) throws ApiException {
        return this.createIncidentWithHttpInfo(body).getData();
    }

    public CompletableFuture<IncidentResponse> createIncidentAsync(IncidentCreateRequest body) {
        return this.createIncidentWithHttpInfoAsync(body).thenApply(response -> (IncidentResponse)response.getData());
    }

    public ApiResponse<IncidentResponse> createIncidentWithHttpInfo(IncidentCreateRequest body) throws ApiException {
        String operationId = "createIncident";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        IncidentCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createIncident");
        }
        String localVarPath = "/api/v2/incidents";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentsApi.createIncident", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentResponse>(){});
    }

    public CompletableFuture<ApiResponse<IncidentResponse>> createIncidentWithHttpInfoAsync(IncidentCreateRequest body) {
        Invocation.Builder builder;
        String operationId = "createIncident";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<IncidentResponse>> result = new CompletableFuture<ApiResponse<IncidentResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        IncidentCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<IncidentResponse>> result = new CompletableFuture<ApiResponse<IncidentResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createIncident"));
            return result;
        }
        String localVarPath = "/api/v2/incidents";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.IncidentsApi.createIncident", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentResponse>> result = new CompletableFuture<ApiResponse<IncidentResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentResponse>(){});
    }

    public void deleteIncident(String incidentId) throws ApiException {
        this.deleteIncidentWithHttpInfo(incidentId);
    }

    public CompletableFuture<Void> deleteIncidentAsync(String incidentId) {
        return this.deleteIncidentWithHttpInfoAsync(incidentId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteIncidentWithHttpInfo(String incidentId) throws ApiException {
        String operationId = "deleteIncident";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (incidentId == null) {
            throw new ApiException(400, "Missing the required parameter 'incidentId' when calling deleteIncident");
        }
        String localVarPath = "/api/v2/incidents/{incident_id}".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentsApi.deleteIncident", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteIncidentWithHttpInfoAsync(String incidentId) {
        Invocation.Builder builder;
        String operationId = "deleteIncident";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (incidentId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'incidentId' when calling deleteIncident"));
            return result;
        }
        String localVarPath = "/api/v2/incidents/{incident_id}".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.IncidentsApi.deleteIncident", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public IncidentResponse getIncident(String incidentId) throws ApiException {
        return this.getIncidentWithHttpInfo(incidentId, new GetIncidentOptionalParameters()).getData();
    }

    public CompletableFuture<IncidentResponse> getIncidentAsync(String incidentId) {
        return this.getIncidentWithHttpInfoAsync(incidentId, new GetIncidentOptionalParameters()).thenApply(response -> (IncidentResponse)response.getData());
    }

    public IncidentResponse getIncident(String incidentId, GetIncidentOptionalParameters parameters) throws ApiException {
        return this.getIncidentWithHttpInfo(incidentId, parameters).getData();
    }

    public CompletableFuture<IncidentResponse> getIncidentAsync(String incidentId, GetIncidentOptionalParameters parameters) {
        return this.getIncidentWithHttpInfoAsync(incidentId, parameters).thenApply(response -> (IncidentResponse)response.getData());
    }

    public ApiResponse<IncidentResponse> getIncidentWithHttpInfo(String incidentId, GetIncidentOptionalParameters parameters) throws ApiException {
        String operationId = "getIncident";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (incidentId == null) {
            throw new ApiException(400, "Missing the required parameter 'incidentId' when calling getIncident");
        }
        List include = parameters.include;
        String localVarPath = "/api/v2/incidents/{incident_id}".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "include", include));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentsApi.getIncident", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentResponse>(){});
    }

    public CompletableFuture<ApiResponse<IncidentResponse>> getIncidentWithHttpInfoAsync(String incidentId, GetIncidentOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "getIncident";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<IncidentResponse>> result = new CompletableFuture<ApiResponse<IncidentResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (incidentId == null) {
            CompletableFuture<ApiResponse<IncidentResponse>> result = new CompletableFuture<ApiResponse<IncidentResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'incidentId' when calling getIncident"));
            return result;
        }
        List include = parameters.include;
        String localVarPath = "/api/v2/incidents/{incident_id}".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "include", include));
        try {
            builder = this.apiClient.createBuilder("v2.IncidentsApi.getIncident", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentResponse>> result = new CompletableFuture<ApiResponse<IncidentResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentResponse>(){});
    }

    public IncidentAttachmentsResponse listIncidentAttachments(String incidentId) throws ApiException {
        return this.listIncidentAttachmentsWithHttpInfo(incidentId, new ListIncidentAttachmentsOptionalParameters()).getData();
    }

    public CompletableFuture<IncidentAttachmentsResponse> listIncidentAttachmentsAsync(String incidentId) {
        return this.listIncidentAttachmentsWithHttpInfoAsync(incidentId, new ListIncidentAttachmentsOptionalParameters()).thenApply(response -> (IncidentAttachmentsResponse)response.getData());
    }

    public IncidentAttachmentsResponse listIncidentAttachments(String incidentId, ListIncidentAttachmentsOptionalParameters parameters) throws ApiException {
        return this.listIncidentAttachmentsWithHttpInfo(incidentId, parameters).getData();
    }

    public CompletableFuture<IncidentAttachmentsResponse> listIncidentAttachmentsAsync(String incidentId, ListIncidentAttachmentsOptionalParameters parameters) {
        return this.listIncidentAttachmentsWithHttpInfoAsync(incidentId, parameters).thenApply(response -> (IncidentAttachmentsResponse)response.getData());
    }

    public ApiResponse<IncidentAttachmentsResponse> listIncidentAttachmentsWithHttpInfo(String incidentId, ListIncidentAttachmentsOptionalParameters parameters) throws ApiException {
        String operationId = "listIncidentAttachments";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (incidentId == null) {
            throw new ApiException(400, "Missing the required parameter 'incidentId' when calling listIncidentAttachments");
        }
        List include = parameters.include;
        List filterAttachmentType = parameters.filterAttachmentType;
        String localVarPath = "/api/v2/incidents/{incident_id}/attachments".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "include", include));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[attachment_type]", filterAttachmentType));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentsApi.listIncidentAttachments", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentAttachmentsResponse>(){});
    }

    public CompletableFuture<ApiResponse<IncidentAttachmentsResponse>> listIncidentAttachmentsWithHttpInfoAsync(String incidentId, ListIncidentAttachmentsOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "listIncidentAttachments";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<IncidentAttachmentsResponse>> result = new CompletableFuture<ApiResponse<IncidentAttachmentsResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (incidentId == null) {
            CompletableFuture<ApiResponse<IncidentAttachmentsResponse>> result = new CompletableFuture<ApiResponse<IncidentAttachmentsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'incidentId' when calling listIncidentAttachments"));
            return result;
        }
        List include = parameters.include;
        List filterAttachmentType = parameters.filterAttachmentType;
        String localVarPath = "/api/v2/incidents/{incident_id}/attachments".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "include", include));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[attachment_type]", filterAttachmentType));
        try {
            builder = this.apiClient.createBuilder("v2.IncidentsApi.listIncidentAttachments", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentAttachmentsResponse>> result = new CompletableFuture<ApiResponse<IncidentAttachmentsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentAttachmentsResponse>(){});
    }

    public IncidentsResponse listIncidents() throws ApiException {
        return this.listIncidentsWithHttpInfo(new ListIncidentsOptionalParameters()).getData();
    }

    public CompletableFuture<IncidentsResponse> listIncidentsAsync() {
        return this.listIncidentsWithHttpInfoAsync(new ListIncidentsOptionalParameters()).thenApply(response -> (IncidentsResponse)response.getData());
    }

    public IncidentsResponse listIncidents(ListIncidentsOptionalParameters parameters) throws ApiException {
        return this.listIncidentsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<IncidentsResponse> listIncidentsAsync(ListIncidentsOptionalParameters parameters) {
        return this.listIncidentsWithHttpInfoAsync(parameters).thenApply(response -> (IncidentsResponse)response.getData());
    }

    public PaginationIterable<IncidentResponseData> listIncidentsWithPagination() {
        ListIncidentsOptionalParameters parameters = new ListIncidentsOptionalParameters();
        return this.listIncidentsWithPagination(parameters);
    }

    public PaginationIterable<IncidentResponseData> listIncidentsWithPagination(ListIncidentsOptionalParameters parameters) {
        Long limit;
        String resultsPath = "getData";
        String valueGetterPath = "";
        String valueSetterPath = "pageOffset";
        Boolean valueSetterParamOptional = true;
        if (parameters.pageSize == null) {
            limit = 10L;
            parameters.pageSize(limit);
        } else {
            limit = parameters.pageSize;
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("optionalParams", parameters);
        PaginationIterable<IncidentResponseData> iterator = new PaginationIterable<IncidentResponseData>(this, "listIncidents", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, limit, args);
        return iterator;
    }

    public ApiResponse<IncidentsResponse> listIncidentsWithHttpInfo(ListIncidentsOptionalParameters parameters) throws ApiException {
        String operationId = "listIncidents";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        List include = parameters.include;
        Long pageSize = parameters.pageSize;
        Long pageOffset = parameters.pageOffset;
        String localVarPath = "/api/v2/incidents";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "include", include));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentsApi.listIncidents", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentsResponse>(){});
    }

    public CompletableFuture<ApiResponse<IncidentsResponse>> listIncidentsWithHttpInfoAsync(ListIncidentsOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "listIncidents";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<IncidentsResponse>> result = new CompletableFuture<ApiResponse<IncidentsResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        List include = parameters.include;
        Long pageSize = parameters.pageSize;
        Long pageOffset = parameters.pageOffset;
        String localVarPath = "/api/v2/incidents";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "include", include));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        try {
            builder = this.apiClient.createBuilder("v2.IncidentsApi.listIncidents", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentsResponse>> result = new CompletableFuture<ApiResponse<IncidentsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentsResponse>(){});
    }

    public IncidentResponse updateIncident(String incidentId, IncidentUpdateRequest body) throws ApiException {
        return this.updateIncidentWithHttpInfo(incidentId, body, new UpdateIncidentOptionalParameters()).getData();
    }

    public CompletableFuture<IncidentResponse> updateIncidentAsync(String incidentId, IncidentUpdateRequest body) {
        return this.updateIncidentWithHttpInfoAsync(incidentId, body, new UpdateIncidentOptionalParameters()).thenApply(response -> (IncidentResponse)response.getData());
    }

    public IncidentResponse updateIncident(String incidentId, IncidentUpdateRequest body, UpdateIncidentOptionalParameters parameters) throws ApiException {
        return this.updateIncidentWithHttpInfo(incidentId, body, parameters).getData();
    }

    public CompletableFuture<IncidentResponse> updateIncidentAsync(String incidentId, IncidentUpdateRequest body, UpdateIncidentOptionalParameters parameters) {
        return this.updateIncidentWithHttpInfoAsync(incidentId, body, parameters).thenApply(response -> (IncidentResponse)response.getData());
    }

    public ApiResponse<IncidentResponse> updateIncidentWithHttpInfo(String incidentId, IncidentUpdateRequest body, UpdateIncidentOptionalParameters parameters) throws ApiException {
        String operationId = "updateIncident";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        IncidentUpdateRequest localVarPostBody = body;
        if (incidentId == null) {
            throw new ApiException(400, "Missing the required parameter 'incidentId' when calling updateIncident");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateIncident");
        }
        List include = parameters.include;
        String localVarPath = "/api/v2/incidents/{incident_id}".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "include", include));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentsApi.updateIncident", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentResponse>(){});
    }

    public CompletableFuture<ApiResponse<IncidentResponse>> updateIncidentWithHttpInfoAsync(String incidentId, IncidentUpdateRequest body, UpdateIncidentOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "updateIncident";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<IncidentResponse>> result = new CompletableFuture<ApiResponse<IncidentResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        IncidentUpdateRequest localVarPostBody = body;
        if (incidentId == null) {
            CompletableFuture<ApiResponse<IncidentResponse>> result = new CompletableFuture<ApiResponse<IncidentResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'incidentId' when calling updateIncident"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<IncidentResponse>> result = new CompletableFuture<ApiResponse<IncidentResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateIncident"));
            return result;
        }
        List include = parameters.include;
        String localVarPath = "/api/v2/incidents/{incident_id}".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "include", include));
        try {
            builder = this.apiClient.createBuilder("v2.IncidentsApi.updateIncident", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentResponse>> result = new CompletableFuture<ApiResponse<IncidentResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentResponse>(){});
    }

    public IncidentAttachmentUpdateResponse updateIncidentAttachments(String incidentId, IncidentAttachmentUpdateRequest body) throws ApiException {
        return this.updateIncidentAttachmentsWithHttpInfo(incidentId, body, new UpdateIncidentAttachmentsOptionalParameters()).getData();
    }

    public CompletableFuture<IncidentAttachmentUpdateResponse> updateIncidentAttachmentsAsync(String incidentId, IncidentAttachmentUpdateRequest body) {
        return this.updateIncidentAttachmentsWithHttpInfoAsync(incidentId, body, new UpdateIncidentAttachmentsOptionalParameters()).thenApply(response -> (IncidentAttachmentUpdateResponse)response.getData());
    }

    public IncidentAttachmentUpdateResponse updateIncidentAttachments(String incidentId, IncidentAttachmentUpdateRequest body, UpdateIncidentAttachmentsOptionalParameters parameters) throws ApiException {
        return this.updateIncidentAttachmentsWithHttpInfo(incidentId, body, parameters).getData();
    }

    public CompletableFuture<IncidentAttachmentUpdateResponse> updateIncidentAttachmentsAsync(String incidentId, IncidentAttachmentUpdateRequest body, UpdateIncidentAttachmentsOptionalParameters parameters) {
        return this.updateIncidentAttachmentsWithHttpInfoAsync(incidentId, body, parameters).thenApply(response -> (IncidentAttachmentUpdateResponse)response.getData());
    }

    public ApiResponse<IncidentAttachmentUpdateResponse> updateIncidentAttachmentsWithHttpInfo(String incidentId, IncidentAttachmentUpdateRequest body, UpdateIncidentAttachmentsOptionalParameters parameters) throws ApiException {
        String operationId = "updateIncidentAttachments";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        IncidentAttachmentUpdateRequest localVarPostBody = body;
        if (incidentId == null) {
            throw new ApiException(400, "Missing the required parameter 'incidentId' when calling updateIncidentAttachments");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateIncidentAttachments");
        }
        List include = parameters.include;
        String localVarPath = "/api/v2/incidents/{incident_id}/attachments".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "include", include));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentsApi.updateIncidentAttachments", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentAttachmentUpdateResponse>(){});
    }

    public CompletableFuture<ApiResponse<IncidentAttachmentUpdateResponse>> updateIncidentAttachmentsWithHttpInfoAsync(String incidentId, IncidentAttachmentUpdateRequest body, UpdateIncidentAttachmentsOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "updateIncidentAttachments";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<IncidentAttachmentUpdateResponse>> result = new CompletableFuture<ApiResponse<IncidentAttachmentUpdateResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        IncidentAttachmentUpdateRequest localVarPostBody = body;
        if (incidentId == null) {
            CompletableFuture<ApiResponse<IncidentAttachmentUpdateResponse>> result = new CompletableFuture<ApiResponse<IncidentAttachmentUpdateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'incidentId' when calling updateIncidentAttachments"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<IncidentAttachmentUpdateResponse>> result = new CompletableFuture<ApiResponse<IncidentAttachmentUpdateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateIncidentAttachments"));
            return result;
        }
        List include = parameters.include;
        String localVarPath = "/api/v2/incidents/{incident_id}/attachments".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "include", include));
        try {
            builder = this.apiClient.createBuilder("v2.IncidentsApi.updateIncidentAttachments", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentAttachmentUpdateResponse>> result = new CompletableFuture<ApiResponse<IncidentAttachmentUpdateResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentAttachmentUpdateResponse>(){});
    }

    public static class UpdateIncidentAttachmentsOptionalParameters {
        private List<IncidentAttachmentRelatedObject> include;

        public UpdateIncidentAttachmentsOptionalParameters include(List<IncidentAttachmentRelatedObject> include) {
            this.include = include;
            return this;
        }
    }

    public static class UpdateIncidentOptionalParameters {
        private List<IncidentRelatedObject> include;

        public UpdateIncidentOptionalParameters include(List<IncidentRelatedObject> include) {
            this.include = include;
            return this;
        }
    }

    public static class ListIncidentsOptionalParameters {
        private List<IncidentRelatedObject> include;
        private Long pageSize;
        private Long pageOffset;

        public ListIncidentsOptionalParameters include(List<IncidentRelatedObject> include) {
            this.include = include;
            return this;
        }

        public ListIncidentsOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListIncidentsOptionalParameters pageOffset(Long pageOffset) {
            this.pageOffset = pageOffset;
            return this;
        }
    }

    public static class ListIncidentAttachmentsOptionalParameters {
        private List<IncidentAttachmentRelatedObject> include;
        private List<IncidentAttachmentAttachmentType> filterAttachmentType;

        public ListIncidentAttachmentsOptionalParameters include(List<IncidentAttachmentRelatedObject> include) {
            this.include = include;
            return this;
        }

        public ListIncidentAttachmentsOptionalParameters filterAttachmentType(List<IncidentAttachmentAttachmentType> filterAttachmentType) {
            this.filterAttachmentType = filterAttachmentType;
            return this;
        }
    }

    public static class GetIncidentOptionalParameters {
        private List<IncidentRelatedObject> include;

        public GetIncidentOptionalParameters include(List<IncidentRelatedObject> include) {
            this.include = include;
            return this;
        }
    }
}

