/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import java.util.concurrent.ThreadLocalRandom;

public class DDId {
    public static final DDId ZERO = new DDId(0L, "0", "0");
    public static final DDId MAX = new DDId(-1L, "18446744073709551615", "ffffffffffffffff");
    private static final DDId ONE = DDId.from(1L);
    private final long id;
    private String str;
    private String hex;
    private static long MAX_FIRST_PART = 0x1999999999999999L;

    public static DDId generate() {
        long id;
        while ((id = ThreadLocalRandom.current().nextLong(Long.MAX_VALUE)) == 0L) {
        }
        return DDId.from(id);
    }

    public static DDId from(long id) {
        return DDId.create(id, null, null);
    }

    public static DDId from(String s) throws NumberFormatException {
        return DDId.create(DDId.parseUnsignedLong(s), s, null);
    }

    public static DDId fromHex(String s) throws NumberFormatException {
        long id = DDId.parseUnsignedLongHex(s);
        String hex = s.toLowerCase();
        int firstNonZero = DDId.firstNonZeroCharacter(s);
        if (firstNonZero > 0) {
            hex = hex.substring(firstNonZero);
        }
        return DDId.create(id, null, hex);
    }

    private DDId(long id, String str, String hex) {
        this.id = id;
        this.str = str;
        this.hex = hex;
    }

    private static DDId create(long id, String str, String hex) {
        if (id == 0L) {
            return ZERO;
        }
        if (id == -1L) {
            return MAX;
        }
        return new DDId(id, str, hex);
    }

    private static int firstNonZeroCharacter(String s) {
        int firstNonZero;
        for (firstNonZero = 0; firstNonZero < s.length() && s.charAt(firstNonZero) == '0'; ++firstNonZero) {
        }
        return firstNonZero;
    }

    private static NumberFormatException numberFormatOutOfRange(String s) {
        return new NumberFormatException(String.format("String value %s exceeds range of unsigned long.", s));
    }

    private static long parseUnsignedLong(String s) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        int len = s.length();
        if (len > 0) {
            char firstChar = s.charAt(0);
            if (firstChar == '-') {
                throw new NumberFormatException(String.format("Illegal leading minus sign on unsigned string %s.", s));
            }
            if (len <= 18) {
                return Long.parseLong(s);
            }
            if (len > 20) {
                throw DDId.numberFormatOutOfRange(s);
            }
            long first = 0L;
            int ok = 0;
            for (int i = 0; i < len - 1; ++i) {
                char c = s.charAt(i);
                int d = Character.digit(c, 10);
                ok |= d;
                first = first * 10L + (long)d;
            }
            int last = Character.digit(s.charAt(len - 1), 10);
            if ((ok |= last) < 0) {
                throw new NumberFormatException("Illegal character in " + s);
            }
            if (first > MAX_FIRST_PART) {
                throw DDId.numberFormatOutOfRange(s);
            }
            long guard = first * 10L;
            long result = guard + (long)last;
            if (guard < 0L && result >= 0L) {
                throw DDId.numberFormatOutOfRange(s);
            }
            return result;
        }
        throw new NumberFormatException("Empty input string");
    }

    private static long parseUnsignedLongHex(String s) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        int len = s.length();
        if (len > 0) {
            if (len > 16 && len - DDId.firstNonZeroCharacter(s) > 16) {
                throw DDId.numberFormatOutOfRange(s);
            }
            long result = 0L;
            int ok = 0;
            for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                int d = Character.digit(c, 16);
                ok |= d;
                result = result << 4 | (long)d;
            }
            if (ok < 0) {
                throw new NumberFormatException("Illegal character in " + s);
            }
            return result;
        }
        throw new NumberFormatException("Empty input string");
    }

    private static String toUnsignedString(long l) {
        if (l >= 0L) {
            return Long.toString(l);
        }
        long quot = (l >>> 1) / 5L;
        long rem = l - quot * 10L;
        return Long.toString(quot) + rem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DDId ddId = (DDId)o;
        return this.id == ddId.id;
    }

    public int hashCode() {
        long id = this.id;
        return (int)(id ^ id >>> 32);
    }

    public String toString() {
        String s = this.str;
        if (s == null) {
            this.str = s = DDId.toUnsignedString(this.id);
        }
        return s;
    }

    public String toHexString() {
        String h = this.hex;
        if (this.hex == null) {
            this.hex = h = Long.toHexString(this.id);
        }
        return h;
    }

    public long toLong() {
        return this.id;
    }
}

