/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;

public class DDId {
    private static final Logger log = LoggerFactory.getLogger(DDId.class);
    public static final DDId ZERO = new DDId(0L, "0");
    public static final DDId MAX = new DDId(-1L, "18446744073709551615");
    private static final Base64Decoder BASE64 = new Base64Decoder();
    private static final DDId ONE = DDId.from(1L);
    private final long id;
    private String str;
    private static long MAX_FIRST_PART = 0x1999999999999999L;

    public static DDId generate() {
        long id;
        while ((id = ThreadLocalRandom.current().nextLong(Long.MAX_VALUE)) == 0L) {
        }
        return DDId.from(id);
    }

    public static DDId from(long id) {
        return DDId.create(id, null);
    }

    public static DDId from(String s) throws NumberFormatException {
        try {
            return DDId.create(DDId.parseUnsignedLong(s), s);
        }
        catch (NumberFormatException e) {
            if (null != s) {
                try {
                    String decoded = new String(BASE64.decode(s), StandardCharsets.ISO_8859_1);
                    log.debug("id {} was base 64 encoded to {}, it was decoded but this indicates there is a problem elsewhere in your system", (Object)decoded, (Object)s);
                    return DDId.create(DDId.parseUnsignedLong(decoded), decoded);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    public static DDId fromHex(String s) throws NumberFormatException {
        try {
            long id = DDId.parseUnsignedLongHex(s);
            return DDId.create(id, null);
        }
        catch (NumberFormatException e) {
            if (null != s) {
                try {
                    String decoded = new String(BASE64.decode(s), StandardCharsets.ISO_8859_1);
                    log.debug("id {} was base 64 encoded to {}, it was decoded but this indicates there is a problem elsewhere in your system", (Object)decoded, (Object)s);
                    return DDId.create(DDId.parseUnsignedLongHex(decoded), null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    private DDId(long id, String str) {
        this.id = id;
        this.str = str;
    }

    private static DDId create(long id, String str) {
        if (id == 0L) {
            return ZERO;
        }
        if (id == -1L) {
            return MAX;
        }
        return new DDId(id, str);
    }

    private static int firstNonZeroCharacter(String s) {
        int firstNonZero;
        for (firstNonZero = 0; firstNonZero < s.length() && s.charAt(firstNonZero) == '0'; ++firstNonZero) {
        }
        return firstNonZero;
    }

    private static NumberFormatException numberFormatOutOfRange(String s) {
        return new NumberFormatException(String.format("String value %s exceeds range of unsigned long.", s));
    }

    private static long parseUnsignedLong(String s) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        int len = s.length();
        if (len > 0) {
            char firstChar = s.charAt(0);
            if (firstChar == '-') {
                throw new NumberFormatException(String.format("Illegal leading minus sign on unsigned string %s.", s));
            }
            if (len <= 18) {
                return Long.parseLong(s);
            }
            if (len > 20) {
                throw DDId.numberFormatOutOfRange(s);
            }
            long first = 0L;
            int ok = 0;
            for (int i = 0; i < len - 1; ++i) {
                char c = s.charAt(i);
                int d = Character.digit(c, 10);
                ok |= d;
                first = first * 10L + (long)d;
            }
            int last = Character.digit(s.charAt(len - 1), 10);
            if ((ok |= last) < 0) {
                throw new NumberFormatException("Illegal character in " + s);
            }
            if (first > MAX_FIRST_PART) {
                throw DDId.numberFormatOutOfRange(s);
            }
            long guard = first * 10L;
            long result = guard + (long)last;
            if (guard < 0L && result >= 0L) {
                throw DDId.numberFormatOutOfRange(s);
            }
            return result;
        }
        throw new NumberFormatException("Empty input string");
    }

    private static long parseUnsignedLongHex(String s) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        int len = s.length();
        if (len > 0) {
            if (len > 16 && len - DDId.firstNonZeroCharacter(s) > 16) {
                throw DDId.numberFormatOutOfRange(s);
            }
            long result = 0L;
            int ok = 0;
            for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                int d = Character.digit(c, 16);
                ok |= d;
                result = result << 4 | (long)d;
            }
            if (ok < 0) {
                throw new NumberFormatException("Illegal character in " + s);
            }
            return result;
        }
        throw new NumberFormatException("Empty input string");
    }

    private static String toUnsignedString(long l) {
        if (l >= 0L) {
            return Long.toString(l);
        }
        long quot = (l >>> 1) / 5L;
        long rem = l - quot * 10L;
        return Long.toString(quot) + rem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DDId ddId = (DDId)o;
        return this.id == ddId.id;
    }

    public int hashCode() {
        long id = this.id;
        return (int)(id ^ id >>> 32);
    }

    public String toString() {
        String s = this.str;
        if (s == null) {
            this.str = s = DDId.toUnsignedString(this.id);
        }
        return s;
    }

    public String toHexString() {
        return Long.toHexString(this.id);
    }

    public long toLong() {
        return this.id;
    }

    private static class Base64Decoder {
        private static final int[] BASE_64;

        private Base64Decoder() {
        }

        public byte[] decode(byte[] src) {
            byte[] dst = new byte[this.outLength(src, 0, src.length)];
            int ret = this.decode0(src, 0, src.length, dst);
            if (ret != dst.length) {
                dst = Arrays.copyOf(dst, ret);
            }
            return dst;
        }

        public byte[] decode(String src) {
            return this.decode(src.getBytes(StandardCharsets.ISO_8859_1));
        }

        private int outLength(byte[] src, int sp, int sl) {
            int paddings = 0;
            int len = sl - sp;
            if (len == 0) {
                return 0;
            }
            if (len < 2) {
                if (BASE_64[0] == -1) {
                    return 0;
                }
                throw new IllegalArgumentException("Input byte[] should at least have 2 bytes for base64 bytes");
            }
            int n = 0;
            while (sp < sl) {
                int b;
                if ((b = src[sp++] & 0xFF) == 61) {
                    len -= sl - sp + 1;
                    break;
                }
                if ((b = BASE_64[b]) != -1) continue;
                ++n;
            }
            if (((len -= n) & 3) != 0) {
                paddings = 4 - (len & 3);
            }
            return 3 * ((len + 3) / 4) - paddings;
        }

        private int decode0(byte[] src, int sp, int sl, byte[] dst) {
            int dp = 0;
            int bits = 0;
            int shiftto = 18;
            while (sp < sl) {
                if (shiftto == 18 && sp + 4 < sl) {
                    int sl0 = sp + (sl - sp & 0xFFFFFFFC);
                    while (sp < sl0) {
                        int b4;
                        int b3;
                        int b1 = BASE_64[src[sp++] & 0xFF];
                        int b2 = BASE_64[src[sp++] & 0xFF];
                        if ((b1 | b2 | (b3 = BASE_64[src[sp++] & 0xFF]) | (b4 = BASE_64[src[sp++] & 0xFF])) < 0) {
                            sp -= 4;
                            break;
                        }
                        int bits0 = b1 << 18 | b2 << 12 | b3 << 6 | b4;
                        dst[dp++] = (byte)(bits0 >> 16);
                        dst[dp++] = (byte)(bits0 >> 8);
                        dst[dp++] = (byte)bits0;
                    }
                    if (sp >= sl) break;
                }
                int b = src[sp++] & 0xFF;
                if ((b = BASE_64[b]) < 0 && b == -2) {
                    if ((shiftto != 6 || sp != sl && src[sp++] == 61) && shiftto != 18) break;
                    throw new IllegalArgumentException("Input byte array has wrong 4-byte ending unit");
                }
                bits |= b << shiftto;
                if ((shiftto -= 6) >= 0) continue;
                dst[dp++] = (byte)(bits >> 16);
                dst[dp++] = (byte)(bits >> 8);
                dst[dp++] = (byte)bits;
                shiftto = 18;
                bits = 0;
            }
            if (shiftto == 6) {
                dst[dp++] = (byte)(bits >> 16);
            } else if (shiftto == 0) {
                dst[dp++] = (byte)(bits >> 16);
                dst[dp++] = (byte)(bits >> 8);
            } else if (shiftto == 12) {
                throw new IllegalArgumentException("Last unit does not have enough valid bits");
            }
            while (sp < sl) {
                if (BASE_64[src[sp++] & 0xFF] < 0) continue;
                throw new IllegalArgumentException("Input byte array has incorrect ending byte at " + sp);
            }
            return dp;
        }

        static {
            int c;
            BASE_64 = new int[256];
            Arrays.fill(BASE_64, -1);
            int i = 0;
            for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
                Base64Decoder.BASE_64[c] = i++;
            }
            for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
                Base64Decoder.BASE_64[c] = i++;
            }
            for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
                Base64Decoder.BASE_64[c] = i++;
            }
            Base64Decoder.BASE_64[43] = i++;
            Base64Decoder.BASE_64[47] = i;
            Base64Decoder.BASE_64[61] = -2;
        }
    }
}

