/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.api;

import datadog.trace.api.DDId;
import datadog.trace.api.Tracer;
import datadog.trace.api.interceptor.MutableSpan;
import datadog.trace.api.interceptor.TraceInterceptor;
import datadog.trace.bootstrap.instrumentation.api.AgentPropagation;
import datadog.trace.bootstrap.instrumentation.api.AgentScope;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTrace;
import datadog.trace.bootstrap.instrumentation.api.ScopeSource;
import datadog.trace.context.ScopeListener;
import datadog.trace.context.TraceScope;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class AgentTracer {
    private static final TracerAPI DEFAULT = new NoopTracerAPI();
    private static final AtomicReference<TracerAPI> provider = new AtomicReference<TracerAPI>(DEFAULT);

    public static AgentSpan startSpan(String spanName) {
        return AgentTracer.get().startSpan(spanName);
    }

    public static AgentSpan startSpan(String spanName, long startTimeMicros) {
        return AgentTracer.get().startSpan(spanName, startTimeMicros);
    }

    public static AgentSpan startSpan(String spanName, AgentSpan.Context parent) {
        return AgentTracer.get().startSpan(spanName, parent);
    }

    public static AgentSpan startSpan(String spanName, AgentSpan.Context parent, long startTimeMicros) {
        return AgentTracer.get().startSpan(spanName, parent, startTimeMicros);
    }

    public static AgentScope activateSpan(AgentSpan span) {
        return AgentTracer.get().activateSpan(span, ScopeSource.INSTRUMENTATION);
    }

    public static AgentSpan activeSpan() {
        return AgentTracer.get().activeSpan();
    }

    @Deprecated
    public static TraceScope activeScope() {
        return AgentTracer.get().activeScope();
    }

    public static AgentPropagation propagate() {
        return AgentTracer.get().propagate();
    }

    public static AgentSpan noopSpan() {
        return AgentTracer.get().noopSpan();
    }

    public static boolean isRegistered() {
        return provider.get() != DEFAULT;
    }

    public static void registerIfAbsent(TracerAPI trace) {
        if (trace != null && trace != DEFAULT) {
            provider.compareAndSet(DEFAULT, trace);
        }
    }

    public static TracerAPI get() {
        return provider.get();
    }

    private AgentTracer() {
    }

    public static class NoopAgentTrace
    implements AgentTrace {
        public static final NoopAgentTrace INSTANCE = new NoopAgentTrace();

        @Override
        public void registerContinuation(AgentScope.Continuation continuation) {
        }

        @Override
        public void cancelContinuation(AgentScope.Continuation continuation) {
        }
    }

    public static class NoopContext
    implements AgentSpan.Context {
        public static final NoopContext INSTANCE = new NoopContext();

        @Override
        public DDId getTraceId() {
            return DDId.ZERO;
        }

        @Override
        public DDId getSpanId() {
            return DDId.ZERO;
        }

        @Override
        public AgentTrace getTrace() {
            return NoopAgentTrace.INSTANCE;
        }

        @Override
        public Iterable<Map.Entry<String, String>> baggageItems() {
            return Collections.emptyList();
        }
    }

    static class NoopContinuation
    implements AgentScope.Continuation {
        static final NoopContinuation INSTANCE = new NoopContinuation();

        NoopContinuation() {
        }

        @Override
        public TraceScope activate() {
            return NoopAgentScope.INSTANCE;
        }

        @Override
        public void cancel() {
        }

        @Override
        public boolean isRegistered() {
            return false;
        }

        @Override
        public WeakReference<AgentScope.Continuation> register(ReferenceQueue referenceQueue) {
            return new WeakReference<Object>(null);
        }

        @Override
        public void cancel(Set<WeakReference<AgentScope.Continuation>> weakReferences) {
        }
    }

    static class NoopAgentPropagation
    implements AgentPropagation {
        static final NoopAgentPropagation INSTANCE = new NoopAgentPropagation();

        NoopAgentPropagation() {
        }

        @Override
        public AgentScope.Continuation capture() {
            return NoopContinuation.INSTANCE;
        }

        @Override
        public <C> void inject(AgentSpan span, C carrier, AgentPropagation.Setter<C> setter) {
        }

        @Override
        public <C> void inject(AgentSpan.Context context, C carrier, AgentPropagation.Setter<C> setter) {
        }

        @Override
        public <C> AgentSpan.Context extract(C carrier, AgentPropagation.Getter<C> getter) {
            return NoopContext.INSTANCE;
        }
    }

    public static class NoopAgentScope
    implements AgentScope,
    TraceScope {
        public static final NoopAgentScope INSTANCE = new NoopAgentScope();

        @Override
        public AgentSpan span() {
            return NoopAgentSpan.INSTANCE;
        }

        @Override
        public void setAsyncPropagation(boolean value) {
        }

        @Override
        public AgentScope.Continuation capture() {
            return NoopContinuation.INSTANCE;
        }

        @Override
        public void close() {
        }

        @Override
        public boolean isAsyncPropagating() {
            return false;
        }
    }

    public static class NoopAgentSpan
    implements AgentSpan {
        public static final NoopAgentSpan INSTANCE = new NoopAgentSpan();

        @Override
        public DDId getTraceId() {
            return DDId.ZERO;
        }

        @Override
        public AgentSpan setTag(String key, boolean value) {
            return this;
        }

        @Override
        public MutableSpan setTag(String tag, Number value) {
            return this;
        }

        @Override
        public Boolean isError() {
            return false;
        }

        @Override
        public AgentSpan setTag(String key, int value) {
            return this;
        }

        @Override
        public AgentSpan setTag(String key, long value) {
            return this;
        }

        @Override
        public AgentSpan setTag(String key, double value) {
            return this;
        }

        @Override
        public AgentSpan setTag(String key, Object value) {
            return this;
        }

        @Override
        public Object getTag(String key) {
            return null;
        }

        @Override
        public long getStartTime() {
            return 0L;
        }

        @Override
        public long getDurationNano() {
            return 0L;
        }

        @Override
        public String getOperationName() {
            return null;
        }

        @Override
        public MutableSpan setOperationName(String serviceName) {
            return this;
        }

        @Override
        public String getServiceName() {
            return null;
        }

        @Override
        public MutableSpan setServiceName(String serviceName) {
            return this;
        }

        @Override
        public CharSequence getResourceName() {
            return null;
        }

        @Override
        public MutableSpan setResourceName(CharSequence resourceName) {
            return this;
        }

        @Override
        public Integer getSamplingPriority() {
            return Integer.MIN_VALUE;
        }

        @Override
        public MutableSpan setSamplingPriority(int newPriority) {
            return this;
        }

        @Override
        public String getSpanType() {
            return null;
        }

        @Override
        public MutableSpan setSpanType(String type) {
            return this;
        }

        @Override
        public Map<String, Object> getTags() {
            return Collections.emptyMap();
        }

        @Override
        public AgentSpan setTag(String key, String value) {
            return this;
        }

        @Override
        public AgentSpan setError(boolean error) {
            return this;
        }

        @Override
        public MutableSpan getRootSpan() {
            return this;
        }

        @Override
        public AgentSpan setErrorMessage(String errorMessage) {
            return this;
        }

        @Override
        public AgentSpan addThrowable(Throwable throwable) {
            return this;
        }

        @Override
        public AgentSpan getLocalRootSpan() {
            return this;
        }

        @Override
        public boolean isSameTrace(AgentSpan otherSpan) {
            return otherSpan instanceof NoopAgentSpan;
        }

        @Override
        public AgentSpan.Context context() {
            return NoopContext.INSTANCE;
        }

        @Override
        public String getBaggageItem(String key) {
            return null;
        }

        @Override
        public AgentSpan setBaggageItem(String key, String value) {
            return this;
        }

        @Override
        public void finish() {
        }

        @Override
        public void finish(long finishMicros) {
        }

        @Override
        public String getSpanName() {
            return "";
        }

        @Override
        public void setSpanName(String spanName) {
        }

        @Override
        public boolean hasResourceName() {
            return false;
        }
    }

    static class NoopTracerAPI
    implements TracerAPI {
        protected NoopTracerAPI() {
        }

        @Override
        public AgentSpan startSpan(String spanName) {
            return NoopAgentSpan.INSTANCE;
        }

        @Override
        public AgentSpan startSpan(String spanName, long startTimeMicros) {
            return NoopAgentSpan.INSTANCE;
        }

        @Override
        public AgentSpan startSpan(String spanName, AgentSpan.Context parent) {
            return NoopAgentSpan.INSTANCE;
        }

        @Override
        public AgentSpan startSpan(String spanName, AgentSpan.Context parent, long startTimeMicros) {
            return NoopAgentSpan.INSTANCE;
        }

        @Override
        public AgentScope activateSpan(AgentSpan span, ScopeSource source) {
            return NoopAgentScope.INSTANCE;
        }

        @Override
        public AgentSpan activeSpan() {
            return NoopAgentSpan.INSTANCE;
        }

        @Override
        public TraceScope activeScope() {
            return null;
        }

        @Override
        public AgentPropagation propagate() {
            return NoopAgentPropagation.INSTANCE;
        }

        @Override
        public AgentSpan noopSpan() {
            return NoopAgentSpan.INSTANCE;
        }

        @Override
        public SpanBuilder buildSpan(String spanName) {
            return null;
        }

        @Override
        public void close() {
        }

        @Override
        public String getTraceId() {
            return null;
        }

        @Override
        public String getSpanId() {
            return null;
        }

        @Override
        public boolean addTraceInterceptor(TraceInterceptor traceInterceptor) {
            return false;
        }

        @Override
        public void addScopeListener(ScopeListener listener) {
        }

        @Override
        public TraceScope.Continuation capture() {
            return null;
        }

        @Override
        public <C> void inject(AgentSpan span, C carrier, AgentPropagation.Setter<C> setter) {
        }

        @Override
        public <C> void inject(AgentSpan.Context context, C carrier, AgentPropagation.Setter<C> setter) {
        }

        @Override
        public <C> AgentSpan.Context extract(C carrier, AgentPropagation.Getter<C> getter) {
            return null;
        }
    }

    public static interface SpanBuilder {
        public AgentSpan start();

        public SpanBuilder asChildOf(AgentSpan.Context var1);

        public SpanBuilder ignoreActiveSpan();

        public SpanBuilder withTag(String var1, String var2);

        public SpanBuilder withTag(String var1, boolean var2);

        public SpanBuilder withTag(String var1, Number var2);

        public SpanBuilder withTag(String var1, Object var2);

        public SpanBuilder withStartTimestamp(long var1);

        public SpanBuilder withServiceName(String var1);

        public SpanBuilder withResourceName(String var1);

        public SpanBuilder withErrorFlag();

        public SpanBuilder withSpanType(String var1);
    }

    public static interface TracerAPI
    extends Tracer,
    AgentPropagation {
        public AgentSpan startSpan(String var1);

        public AgentSpan startSpan(String var1, long var2);

        public AgentSpan startSpan(String var1, AgentSpan.Context var2);

        public AgentSpan startSpan(String var1, AgentSpan.Context var2, long var3);

        public AgentScope activateSpan(AgentSpan var1, ScopeSource var2);

        public AgentSpan activeSpan();

        public TraceScope activeScope();

        public AgentPropagation propagate();

        public AgentSpan noopSpan();

        public SpanBuilder buildSpan(String var1);

        public void close();
    }
}

