/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.java.concurrent;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.bootstrap.ContextStore;
import datadog.trace.bootstrap.instrumentation.java.concurrent.State;
import datadog.trace.context.TraceScope;

public class AdviceUtils {
    private static final Logger log = LoggerFactory.getLogger(AdviceUtils.class);

    public static <T> TraceScope startTaskScope(ContextStore<T, State> contextStore, T task) {
        TraceScope.Continuation continuation;
        State state = contextStore.get(task);
        if (state != null && (continuation = state.getAndResetContinuation()) != null) {
            TraceScope scope = continuation.activate();
            scope.setAsyncPropagation(true);
            return scope;
        }
        return null;
    }

    public static void endTaskScope(TraceScope scope) {
        if (scope != null) {
            scope.close();
        }
    }
}

