/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.ConfigDefaults;
import datadog.trace.api.PropagationStyle;
import datadog.trace.api.env.CapturedEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.UUID;
import java.util.regex.Pattern;
import lombok.NonNull;

@Deprecated
public class Config {
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    private static final MethodHandles.Lookup PUBLIC_LOOKUP = MethodHandles.publicLookup();
    private static final String PREFIX = "dd.";
    public static final String CONFIGURATION_FILE = "trace.config";
    public static final String API_KEY = "api-key";
    public static final String API_KEY_FILE = "api-key-file";
    public static final String SITE = "site";
    public static final String SERVICE_NAME = "service.name";
    public static final String TRACE_ENABLED = "trace.enabled";
    public static final String INTEGRATIONS_ENABLED = "integrations.enabled";
    public static final String WRITER_TYPE = "writer.type";
    public static final String AGENT_HOST = "agent.host";
    public static final String TRACE_AGENT_PORT = "trace.agent.port";
    public static final String AGENT_PORT_LEGACY = "agent.port";
    public static final String AGENT_UNIX_DOMAIN_SOCKET = "trace.agent.unix.domain.socket";
    public static final String AGENT_TIMEOUT = "trace.agent.timeout";
    public static final String PRIORITY_SAMPLING = "priority.sampling";
    @Deprecated
    public static final String TRACE_RESOLVER_ENABLED = "trace.resolver.enabled";
    public static final String SERVICE_MAPPING = "service.mapping";
    private static final String ENV = "env";
    private static final String VERSION = "version";
    public static final String TAGS = "tags";
    @Deprecated
    public static final String GLOBAL_TAGS = "trace.global.tags";
    public static final String SPAN_TAGS = "trace.span.tags";
    public static final String JMX_TAGS = "trace.jmx.tags";
    public static final String TRACE_ANALYTICS_ENABLED = "trace.analytics.enabled";
    public static final String TRACE_ANNOTATIONS = "trace.annotations";
    public static final String TRACE_EXECUTORS_ALL = "trace.executors.all";
    public static final String TRACE_EXECUTORS = "trace.executors";
    public static final String TRACE_METHODS = "trace.methods";
    public static final String TRACE_CLASSES_EXCLUDE = "trace.classes.exclude";
    public static final String TRACE_SAMPLING_SERVICE_RULES = "trace.sampling.service.rules";
    public static final String TRACE_SAMPLING_OPERATION_RULES = "trace.sampling.operation.rules";
    public static final String TRACE_SAMPLE_RATE = "trace.sample.rate";
    public static final String TRACE_RATE_LIMIT = "trace.rate.limit";
    public static final String TRACE_REPORT_HOSTNAME = "trace.report-hostname";
    public static final String HEADER_TAGS = "trace.header.tags";
    public static final String HTTP_SERVER_ERROR_STATUSES = "http.server.error.statuses";
    public static final String HTTP_CLIENT_ERROR_STATUSES = "http.client.error.statuses";
    public static final String HTTP_SERVER_TAG_QUERY_STRING = "http.server.tag.query-string";
    public static final String HTTP_CLIENT_TAG_QUERY_STRING = "http.client.tag.query-string";
    public static final String HTTP_CLIENT_HOST_SPLIT_BY_DOMAIN = "trace.http.client.split-by-domain";
    public static final String DB_CLIENT_HOST_SPLIT_BY_INSTANCE = "trace.db.client.split-by-instance";
    public static final String SPLIT_BY_TAGS = "trace.split-by-tags";
    public static final String SCOPE_DEPTH_LIMIT = "trace.scope.depth.limit";
    public static final String SCOPE_STRICT_MODE = "trace.scope.strict.mode";
    public static final String PARTIAL_FLUSH_MIN_SPANS = "trace.partial.flush.min.spans";
    public static final String RUNTIME_CONTEXT_FIELD_INJECTION = "trace.runtime.context.field.injection";
    public static final String PROPAGATION_STYLE_EXTRACT = "propagation.style.extract";
    public static final String PROPAGATION_STYLE_INJECT = "propagation.style.inject";
    public static final String JMX_FETCH_ENABLED = "jmxfetch.enabled";
    public static final String JMX_FETCH_CONFIG_DIR = "jmxfetch.config.dir";
    public static final String JMX_FETCH_CONFIG = "jmxfetch.config";
    @Deprecated
    public static final String JMX_FETCH_METRICS_CONFIGS = "jmxfetch.metrics-configs";
    public static final String JMX_FETCH_CHECK_PERIOD = "jmxfetch.check-period";
    public static final String JMX_FETCH_REFRESH_BEANS_PERIOD = "jmxfetch.refresh-beans-period";
    public static final String JMX_FETCH_STATSD_HOST = "jmxfetch.statsd.host";
    public static final String JMX_FETCH_STATSD_PORT = "jmxfetch.statsd.port";
    public static final String HEALTH_METRICS_ENABLED = "trace.health.metrics.enabled";
    public static final String HEALTH_METRICS_STATSD_HOST = "trace.health.metrics.statsd.host";
    public static final String HEALTH_METRICS_STATSD_PORT = "trace.health.metrics.statsd.port";
    public static final String LOGS_INJECTION_ENABLED = "logs.injection";
    public static final String PROFILING_ENABLED = "profiling.enabled";
    @Deprecated
    public static final String PROFILING_URL = "profiling.url";
    @Deprecated
    public static final String PROFILING_API_KEY_OLD = "profiling.api-key";
    @Deprecated
    public static final String PROFILING_API_KEY_FILE_OLD = "profiling.api-key-file";
    @Deprecated
    public static final String PROFILING_API_KEY_VERY_OLD = "profiling.apikey";
    @Deprecated
    public static final String PROFILING_API_KEY_FILE_VERY_OLD = "profiling.apikey.file";
    public static final String PROFILING_TAGS = "profiling.tags";
    public static final String PROFILING_START_DELAY = "profiling.start-delay";
    public static final String PROFILING_START_FORCE_FIRST = "profiling.experimental.start-force-first";
    public static final String PROFILING_UPLOAD_PERIOD = "profiling.upload.period";
    public static final String PROFILING_TEMPLATE_OVERRIDE_FILE = "profiling.jfr-template-override-file";
    public static final String PROFILING_UPLOAD_TIMEOUT = "profiling.upload.timeout";
    public static final String PROFILING_UPLOAD_COMPRESSION = "profiling.upload.compression";
    public static final String PROFILING_PROXY_HOST = "profiling.proxy.host";
    public static final String PROFILING_PROXY_PORT = "profiling.proxy.port";
    public static final String PROFILING_PROXY_USERNAME = "profiling.proxy.username";
    public static final String PROFILING_PROXY_PASSWORD = "profiling.proxy.password";
    public static final String PROFILING_EXCEPTION_SAMPLE_LIMIT = "profiling.exception.sample.limit";
    public static final String PROFILING_EXCEPTION_HISTOGRAM_TOP_ITEMS = "profiling.exception.histogram.top-items";
    public static final String PROFILING_EXCEPTION_HISTOGRAM_MAX_COLLECTION_SIZE = "profiling.exception.histogram.max-collection-size";
    public static final String KAFKA_CLIENT_PROPAGATION_ENABLED = "kafka.client.propagation.enabled";
    public static final String KAFKA_CLIENT_BASE64_DECODING_ENABLED = "kafka.client.base64.decoding.enabled";
    private static final String PROFILING_REMOTE_URL_TEMPLATE = "https://intake.profile.%s/v1/input";
    private static final String PROFILING_LOCAL_URL_TEMPLATE = "http://%s:%d/profiling/v1/input";
    private static final Pattern ENV_REPLACEMENT = Pattern.compile("[^a-zA-Z0-9_]");
    private static final String SPLIT_BY_SPACE_OR_COMMA_REGEX = "[,\\s]+";
    private final String runtimeId;
    private final String apiKey;
    private final String site;
    private final String serviceName;
    private final boolean traceEnabled;
    private final boolean integrationsEnabled;
    private final String writerType;
    private final boolean agentConfiguredUsingDefault;
    private final String agentHost;
    private final int agentPort;
    private final String agentUnixDomainSocket;
    private final int agentTimeout;
    private final boolean prioritySamplingEnabled;
    private final boolean traceResolverEnabled;
    private final Map<String, String> serviceMapping;
    @NonNull
    private final Map<String, String> tags;
    private final Map<String, String> spanTags;
    private final Map<String, String> jmxTags;
    private final List<String> excludedClasses;
    private final Map<String, String> headerTags;
    private final BitSet httpServerErrorStatuses;
    private final BitSet httpClientErrorStatuses;
    private final boolean httpServerTagQueryString;
    private final boolean httpClientTagQueryString;
    private final boolean httpClientSplitByDomain;
    private final boolean dbClientSplitByInstance;
    private final Set<String> splitByTags;
    private final Integer scopeDepthLimit;
    private final boolean scopeStrictMode;
    private final Integer partialFlushMinSpans;
    private final boolean runtimeContextFieldInjection;
    private final Set<PropagationStyle> propagationStylesToExtract;
    private final Set<PropagationStyle> propagationStylesToInject;
    private final boolean jmxFetchEnabled;
    private final String jmxFetchConfigDir;
    private final List<String> jmxFetchConfigs;
    @Deprecated
    private final List<String> jmxFetchMetricsConfigs;
    private final Integer jmxFetchCheckPeriod;
    private final Integer jmxFetchRefreshBeansPeriod;
    private final String jmxFetchStatsdHost;
    private final Integer jmxFetchStatsdPort;
    private final boolean healthMetricsEnabled;
    private final String healthMetricsStatsdHost;
    private final Integer healthMetricsStatsdPort;
    private final boolean logsInjectionEnabled;
    private final boolean reportHostName;
    private final String traceAnnotations;
    private final String traceMethods;
    private final boolean traceExecutorsAll;
    private final List<String> traceExecutors;
    private final boolean traceAnalyticsEnabled;
    private final Map<String, String> traceSamplingServiceRules;
    private final Map<String, String> traceSamplingOperationRules;
    private final Double traceSampleRate;
    private final Double traceRateLimit;
    private final boolean profilingEnabled;
    @Deprecated
    private final String profilingUrl;
    private final Map<String, String> profilingTags;
    private final int profilingStartDelay;
    private final boolean profilingStartForceFirst;
    private final int profilingUploadPeriod;
    private final String profilingTemplateOverrideFile;
    private final int profilingUploadTimeout;
    private final String profilingUploadCompression;
    private final String profilingProxyHost;
    private final int profilingProxyPort;
    private final String profilingProxyUsername;
    private final String profilingProxyPassword;
    private final int profilingExceptionSampleLimit;
    private final int profilingExceptionHistogramTopItems;
    private final int profilingExceptionHistogramMaxCollectionSize;
    private final boolean kafkaClientPropagationEnabled;
    private final boolean kafkaClientBase64DecodingEnabled;
    private final boolean debugEnabled;
    private final String configFile;
    private static Properties propertiesFromConfigFile;
    private static Properties propertiesFromCapturedEnv;
    private static final Config INSTANCE;

    private String profilingApiKeyMasker() {
        return this.apiKey != null ? "****" : null;
    }

    private String profilingProxyPasswordMasker() {
        return this.profilingProxyPassword != null ? "****" : null;
    }

    private Config() {
        this(INSTANCE != null ? Config.INSTANCE.runtimeId : UUID.randomUUID().toString());
    }

    private Config(String runtimeId) {
        boolean socketConfiguredUsingDefault;
        boolean agentHostConfiguredUsingDefault;
        propertiesFromConfigFile = Config.loadConfigurationFile();
        propertiesFromCapturedEnv = Config.loadCapturedEnvironment();
        this.configFile = Config.findConfigurationFile();
        this.runtimeId = runtimeId;
        String apiKeyFile = Config.getSettingFromEnvironment(API_KEY_FILE, null);
        String tmpApiKey = System.getenv(Config.propertyNameToEnvironmentVariableName(API_KEY));
        if (apiKeyFile != null) {
            try {
                tmpApiKey = new String(Files.readAllBytes(Paths.get(apiKeyFile, new String[0])), StandardCharsets.UTF_8).trim();
            }
            catch (IOException e) {
                log.error("Cannot read API key from file {}, skipping", (Object)apiKeyFile, (Object)e);
            }
        }
        this.site = Config.getSettingFromEnvironment(SITE, "datadoghq.com");
        this.serviceName = Config.getSettingFromEnvironment("service", Config.getSettingFromEnvironment(SERVICE_NAME, "unnamed-java-app"));
        this.traceEnabled = Config.getBooleanSettingFromEnvironment(TRACE_ENABLED, true);
        this.integrationsEnabled = Config.getBooleanSettingFromEnvironment(INTEGRATIONS_ENABLED, true);
        this.writerType = Config.getSettingFromEnvironment(WRITER_TYPE, "DDAgentWriter");
        String agentHostFromEnvironment = Config.getSettingFromEnvironment(AGENT_HOST, null);
        if (agentHostFromEnvironment == null) {
            this.agentHost = "localhost";
            agentHostConfiguredUsingDefault = true;
        } else {
            this.agentHost = agentHostFromEnvironment;
            agentHostConfiguredUsingDefault = false;
        }
        String unixDomainFromEnv = Config.getSettingFromEnvironment(AGENT_UNIX_DOMAIN_SOCKET, null);
        if (unixDomainFromEnv == null) {
            this.agentUnixDomainSocket = ConfigDefaults.DEFAULT_AGENT_UNIX_DOMAIN_SOCKET;
            socketConfiguredUsingDefault = true;
        } else {
            this.agentUnixDomainSocket = unixDomainFromEnv;
            socketConfiguredUsingDefault = false;
        }
        this.agentPort = Config.getIntegerSettingFromEnvironment(TRACE_AGENT_PORT, Config.getIntegerSettingFromEnvironment(AGENT_PORT_LEGACY, 8126));
        this.agentConfiguredUsingDefault = agentHostConfiguredUsingDefault && socketConfiguredUsingDefault && this.agentPort == 8126;
        this.agentTimeout = Config.getIntegerSettingFromEnvironment(AGENT_TIMEOUT, 10);
        this.prioritySamplingEnabled = Config.getBooleanSettingFromEnvironment(PRIORITY_SAMPLING, true);
        this.traceResolverEnabled = Config.getBooleanSettingFromEnvironment(TRACE_RESOLVER_ENABLED, true);
        this.serviceMapping = Config.getMapSettingFromEnvironment(SERVICE_MAPPING, null);
        HashMap<String, String> tags = new HashMap<String, String>(Config.getMapSettingFromEnvironment(GLOBAL_TAGS, null));
        tags.putAll(Config.getMapSettingFromEnvironment(TAGS, null));
        this.tags = Config.getMapWithPropertiesDefinedByEnvironment(tags, ENV, VERSION);
        this.spanTags = Config.getMapSettingFromEnvironment(SPAN_TAGS, null);
        this.jmxTags = Config.getMapSettingFromEnvironment(JMX_TAGS, null);
        this.excludedClasses = Config.getListSettingFromEnvironment(TRACE_CLASSES_EXCLUDE, null);
        this.headerTags = Config.getMapSettingFromEnvironment(HEADER_TAGS, null);
        this.httpServerErrorStatuses = Config.getIntegerRangeSettingFromEnvironment(HTTP_SERVER_ERROR_STATUSES, ConfigDefaults.DEFAULT_HTTP_SERVER_ERROR_STATUSES);
        this.httpClientErrorStatuses = Config.getIntegerRangeSettingFromEnvironment(HTTP_CLIENT_ERROR_STATUSES, ConfigDefaults.DEFAULT_HTTP_CLIENT_ERROR_STATUSES);
        this.httpServerTagQueryString = Config.getBooleanSettingFromEnvironment(HTTP_SERVER_TAG_QUERY_STRING, false);
        this.httpClientTagQueryString = Config.getBooleanSettingFromEnvironment(HTTP_CLIENT_TAG_QUERY_STRING, false);
        this.httpClientSplitByDomain = Config.getBooleanSettingFromEnvironment(HTTP_CLIENT_HOST_SPLIT_BY_DOMAIN, false);
        this.dbClientSplitByInstance = Config.getBooleanSettingFromEnvironment(DB_CLIENT_HOST_SPLIT_BY_INSTANCE, false);
        this.splitByTags = Collections.unmodifiableSet(new LinkedHashSet<String>(Config.getListSettingFromEnvironment(SPLIT_BY_TAGS, "")));
        this.scopeDepthLimit = Config.getIntegerSettingFromEnvironment(SCOPE_DEPTH_LIMIT, 100);
        this.scopeStrictMode = Config.getBooleanSettingFromEnvironment(SCOPE_STRICT_MODE, false);
        this.partialFlushMinSpans = Config.getIntegerSettingFromEnvironment(PARTIAL_FLUSH_MIN_SPANS, 1000);
        this.runtimeContextFieldInjection = Config.getBooleanSettingFromEnvironment(RUNTIME_CONTEXT_FIELD_INJECTION, true);
        this.propagationStylesToExtract = Config.getPropagationStyleSetSettingFromEnvironmentOrDefault(PROPAGATION_STYLE_EXTRACT, ConfigDefaults.DEFAULT_PROPAGATION_STYLE_EXTRACT);
        this.propagationStylesToInject = Config.getPropagationStyleSetSettingFromEnvironmentOrDefault(PROPAGATION_STYLE_INJECT, ConfigDefaults.DEFAULT_PROPAGATION_STYLE_INJECT);
        this.jmxFetchEnabled = Config.getBooleanSettingFromEnvironment(JMX_FETCH_ENABLED, true);
        this.jmxFetchConfigDir = Config.getSettingFromEnvironment(JMX_FETCH_CONFIG_DIR, null);
        this.jmxFetchConfigs = Config.getListSettingFromEnvironment(JMX_FETCH_CONFIG, null);
        this.jmxFetchMetricsConfigs = Config.getListSettingFromEnvironment(JMX_FETCH_METRICS_CONFIGS, null);
        this.jmxFetchCheckPeriod = Config.getIntegerSettingFromEnvironment(JMX_FETCH_CHECK_PERIOD, null);
        this.jmxFetchRefreshBeansPeriod = Config.getIntegerSettingFromEnvironment(JMX_FETCH_REFRESH_BEANS_PERIOD, null);
        this.jmxFetchStatsdHost = Config.getSettingFromEnvironment(JMX_FETCH_STATSD_HOST, null);
        this.jmxFetchStatsdPort = Config.getIntegerSettingFromEnvironment(JMX_FETCH_STATSD_PORT, 8125);
        this.healthMetricsEnabled = Config.getBooleanSettingFromEnvironment(HEALTH_METRICS_ENABLED, false);
        this.healthMetricsStatsdHost = Config.getSettingFromEnvironment(HEALTH_METRICS_STATSD_HOST, null);
        this.healthMetricsStatsdPort = Config.getIntegerSettingFromEnvironment(HEALTH_METRICS_STATSD_PORT, null);
        this.logsInjectionEnabled = Config.getBooleanSettingFromEnvironment(LOGS_INJECTION_ENABLED, false);
        this.reportHostName = Config.getBooleanSettingFromEnvironment(TRACE_REPORT_HOSTNAME, false);
        this.traceAnnotations = Config.getSettingFromEnvironment(TRACE_ANNOTATIONS, ConfigDefaults.DEFAULT_TRACE_ANNOTATIONS);
        this.traceMethods = Config.getSettingFromEnvironment(TRACE_METHODS, ConfigDefaults.DEFAULT_TRACE_METHODS);
        this.traceExecutorsAll = Config.getBooleanSettingFromEnvironment(TRACE_EXECUTORS_ALL, false);
        this.traceExecutors = Config.getListSettingFromEnvironment(TRACE_EXECUTORS, "");
        this.traceAnalyticsEnabled = Config.getBooleanSettingFromEnvironment(TRACE_ANALYTICS_ENABLED, false);
        this.traceSamplingServiceRules = Config.getMapSettingFromEnvironment(TRACE_SAMPLING_SERVICE_RULES, null);
        this.traceSamplingOperationRules = Config.getMapSettingFromEnvironment(TRACE_SAMPLING_OPERATION_RULES, null);
        this.traceSampleRate = Config.getDoubleSettingFromEnvironment(TRACE_SAMPLE_RATE, null);
        this.traceRateLimit = Config.getDoubleSettingFromEnvironment(TRACE_RATE_LIMIT, 100.0);
        this.profilingEnabled = Config.getBooleanSettingFromEnvironment(PROFILING_ENABLED, false);
        this.profilingUrl = Config.getSettingFromEnvironment(PROFILING_URL, null);
        if (tmpApiKey == null) {
            String oldProfilingApiKeyFile = Config.getSettingFromEnvironment(PROFILING_API_KEY_FILE_OLD, null);
            tmpApiKey = System.getenv(Config.propertyNameToEnvironmentVariableName(PROFILING_API_KEY_OLD));
            if (oldProfilingApiKeyFile != null) {
                try {
                    tmpApiKey = new String(Files.readAllBytes(Paths.get(oldProfilingApiKeyFile, new String[0])), StandardCharsets.UTF_8).trim();
                }
                catch (IOException e) {
                    log.error("Cannot read API key from file {}, skipping", (Object)oldProfilingApiKeyFile, (Object)e);
                }
            }
        }
        if (tmpApiKey == null) {
            String veryOldProfilingApiKeyFile = Config.getSettingFromEnvironment(PROFILING_API_KEY_FILE_VERY_OLD, null);
            tmpApiKey = System.getenv(Config.propertyNameToEnvironmentVariableName(PROFILING_API_KEY_VERY_OLD));
            if (veryOldProfilingApiKeyFile != null) {
                try {
                    tmpApiKey = new String(Files.readAllBytes(Paths.get(veryOldProfilingApiKeyFile, new String[0])), StandardCharsets.UTF_8).trim();
                }
                catch (IOException e) {
                    log.error("Cannot read API key from file {}, skipping", (Object)veryOldProfilingApiKeyFile, (Object)e);
                }
            }
        }
        this.profilingTags = Config.getMapSettingFromEnvironment(PROFILING_TAGS, null);
        this.profilingStartDelay = Config.getIntegerSettingFromEnvironment(PROFILING_START_DELAY, 10);
        this.profilingStartForceFirst = Config.getBooleanSettingFromEnvironment(PROFILING_START_FORCE_FIRST, false);
        this.profilingUploadPeriod = Config.getIntegerSettingFromEnvironment(PROFILING_UPLOAD_PERIOD, 60);
        this.profilingTemplateOverrideFile = Config.getSettingFromEnvironment(PROFILING_TEMPLATE_OVERRIDE_FILE, null);
        this.profilingUploadTimeout = Config.getIntegerSettingFromEnvironment(PROFILING_UPLOAD_TIMEOUT, 30);
        this.profilingUploadCompression = Config.getSettingFromEnvironment(PROFILING_UPLOAD_COMPRESSION, "on");
        this.profilingProxyHost = Config.getSettingFromEnvironment(PROFILING_PROXY_HOST, null);
        this.profilingProxyPort = Config.getIntegerSettingFromEnvironment(PROFILING_PROXY_PORT, 8080);
        this.profilingProxyUsername = Config.getSettingFromEnvironment(PROFILING_PROXY_USERNAME, null);
        this.profilingProxyPassword = Config.getSettingFromEnvironment(PROFILING_PROXY_PASSWORD, null);
        this.profilingExceptionSampleLimit = Config.getIntegerSettingFromEnvironment(PROFILING_EXCEPTION_SAMPLE_LIMIT, 10000);
        this.profilingExceptionHistogramTopItems = Config.getIntegerSettingFromEnvironment(PROFILING_EXCEPTION_HISTOGRAM_TOP_ITEMS, 50);
        this.profilingExceptionHistogramMaxCollectionSize = Config.getIntegerSettingFromEnvironment(PROFILING_EXCEPTION_HISTOGRAM_MAX_COLLECTION_SIZE, 10000);
        this.kafkaClientPropagationEnabled = Config.getBooleanSettingFromEnvironment(KAFKA_CLIENT_PROPAGATION_ENABLED, true);
        this.kafkaClientBase64DecodingEnabled = Config.getBooleanSettingFromEnvironment(KAFKA_CLIENT_BASE64_DECODING_ENABLED, false);
        this.debugEnabled = Config.isDebugMode();
        this.apiKey = tmpApiKey;
        log.debug("New instance: {}", (Object)this);
    }

    private Config(Properties properties, Config parent) {
        this.runtimeId = parent.runtimeId;
        this.configFile = parent.configFile;
        this.apiKey = properties.getProperty(API_KEY, parent.apiKey);
        this.site = properties.getProperty(SITE, parent.site);
        this.serviceName = properties.getProperty("service", properties.getProperty(SERVICE_NAME, parent.serviceName));
        this.traceEnabled = Config.getPropertyBooleanValue(properties, TRACE_ENABLED, parent.traceEnabled);
        this.integrationsEnabled = Config.getPropertyBooleanValue(properties, INTEGRATIONS_ENABLED, parent.integrationsEnabled);
        this.writerType = properties.getProperty(WRITER_TYPE, parent.writerType);
        this.agentHost = properties.getProperty(AGENT_HOST, parent.agentHost);
        this.agentPort = Config.getPropertyIntegerValue(properties, TRACE_AGENT_PORT, Config.getPropertyIntegerValue(properties, AGENT_PORT_LEGACY, parent.agentPort));
        this.agentUnixDomainSocket = properties.getProperty(AGENT_UNIX_DOMAIN_SOCKET, parent.agentUnixDomainSocket);
        this.agentConfiguredUsingDefault = !properties.containsKey(AGENT_HOST) && !properties.containsKey(AGENT_UNIX_DOMAIN_SOCKET) && !properties.containsKey(TRACE_AGENT_PORT) && !properties.containsKey(AGENT_PORT_LEGACY) && parent.agentConfiguredUsingDefault;
        this.agentTimeout = Config.getPropertyIntegerValue(properties, AGENT_TIMEOUT, parent.agentTimeout);
        this.prioritySamplingEnabled = Config.getPropertyBooleanValue(properties, PRIORITY_SAMPLING, parent.prioritySamplingEnabled);
        this.traceResolverEnabled = Config.getPropertyBooleanValue(properties, TRACE_RESOLVER_ENABLED, parent.traceResolverEnabled);
        this.serviceMapping = Config.getPropertyMapValue(properties, SERVICE_MAPPING, parent.serviceMapping);
        HashMap<String, String> preTags = new HashMap<String, String>(Config.getPropertyMapValue(properties, GLOBAL_TAGS, Collections.emptyMap()));
        preTags.putAll(Config.getPropertyMapValue(properties, TAGS, parent.tags));
        this.tags = Config.overwriteKeysFromProperties(preTags, properties, ENV, VERSION);
        this.spanTags = Config.getPropertyMapValue(properties, SPAN_TAGS, parent.spanTags);
        this.jmxTags = Config.getPropertyMapValue(properties, JMX_TAGS, parent.jmxTags);
        this.excludedClasses = Config.getPropertyListValue(properties, TRACE_CLASSES_EXCLUDE, parent.excludedClasses);
        this.headerTags = Config.getPropertyMapValue(properties, HEADER_TAGS, parent.headerTags);
        this.httpServerErrorStatuses = Config.getPropertyIntegerRangeValue(properties, HTTP_SERVER_ERROR_STATUSES, parent.httpServerErrorStatuses);
        this.httpClientErrorStatuses = Config.getPropertyIntegerRangeValue(properties, HTTP_CLIENT_ERROR_STATUSES, parent.httpClientErrorStatuses);
        this.httpServerTagQueryString = Config.getPropertyBooleanValue(properties, HTTP_SERVER_TAG_QUERY_STRING, parent.httpServerTagQueryString);
        this.httpClientTagQueryString = Config.getPropertyBooleanValue(properties, HTTP_CLIENT_TAG_QUERY_STRING, parent.httpClientTagQueryString);
        this.httpClientSplitByDomain = Config.getPropertyBooleanValue(properties, HTTP_CLIENT_HOST_SPLIT_BY_DOMAIN, parent.httpClientSplitByDomain);
        this.dbClientSplitByInstance = Config.getPropertyBooleanValue(properties, DB_CLIENT_HOST_SPLIT_BY_INSTANCE, parent.dbClientSplitByInstance);
        this.splitByTags = Collections.unmodifiableSet(new LinkedHashSet<String>(Config.getPropertyListValue(properties, SPLIT_BY_TAGS, new ArrayList<String>(parent.splitByTags))));
        this.scopeDepthLimit = Config.getPropertyIntegerValue(properties, SCOPE_DEPTH_LIMIT, parent.scopeDepthLimit);
        this.scopeStrictMode = Config.getPropertyBooleanValue(properties, SCOPE_STRICT_MODE, parent.scopeStrictMode);
        this.partialFlushMinSpans = Config.getPropertyIntegerValue(properties, PARTIAL_FLUSH_MIN_SPANS, parent.partialFlushMinSpans);
        this.runtimeContextFieldInjection = Config.getPropertyBooleanValue(properties, RUNTIME_CONTEXT_FIELD_INJECTION, parent.runtimeContextFieldInjection);
        Set<PropagationStyle> parsedPropagationStylesToExtract = Config.getPropagationStyleSetFromPropertyValue(properties, PROPAGATION_STYLE_EXTRACT);
        this.propagationStylesToExtract = parsedPropagationStylesToExtract == null ? parent.propagationStylesToExtract : parsedPropagationStylesToExtract;
        Set<PropagationStyle> parsedPropagationStylesToInject = Config.getPropagationStyleSetFromPropertyValue(properties, PROPAGATION_STYLE_INJECT);
        this.propagationStylesToInject = parsedPropagationStylesToInject == null ? parent.propagationStylesToInject : parsedPropagationStylesToInject;
        this.jmxFetchEnabled = Config.getPropertyBooleanValue(properties, JMX_FETCH_ENABLED, parent.jmxFetchEnabled);
        this.jmxFetchConfigDir = properties.getProperty(JMX_FETCH_CONFIG_DIR, parent.jmxFetchConfigDir);
        this.jmxFetchConfigs = Config.getPropertyListValue(properties, JMX_FETCH_CONFIG, parent.jmxFetchConfigs);
        this.jmxFetchMetricsConfigs = Config.getPropertyListValue(properties, JMX_FETCH_METRICS_CONFIGS, parent.jmxFetchMetricsConfigs);
        this.jmxFetchCheckPeriod = Config.getPropertyIntegerValue(properties, JMX_FETCH_CHECK_PERIOD, parent.jmxFetchCheckPeriod);
        this.jmxFetchRefreshBeansPeriod = Config.getPropertyIntegerValue(properties, JMX_FETCH_REFRESH_BEANS_PERIOD, parent.jmxFetchRefreshBeansPeriod);
        this.jmxFetchStatsdHost = properties.getProperty(JMX_FETCH_STATSD_HOST, parent.jmxFetchStatsdHost);
        this.jmxFetchStatsdPort = Config.getPropertyIntegerValue(properties, JMX_FETCH_STATSD_PORT, parent.jmxFetchStatsdPort);
        this.healthMetricsEnabled = Config.getPropertyBooleanValue(properties, HEALTH_METRICS_ENABLED, false);
        this.healthMetricsStatsdHost = properties.getProperty(HEALTH_METRICS_STATSD_HOST, parent.healthMetricsStatsdHost);
        this.healthMetricsStatsdPort = Config.getPropertyIntegerValue(properties, HEALTH_METRICS_STATSD_PORT, parent.healthMetricsStatsdPort);
        this.logsInjectionEnabled = Config.getBooleanSettingFromEnvironment(LOGS_INJECTION_ENABLED, false);
        this.reportHostName = Config.getPropertyBooleanValue(properties, TRACE_REPORT_HOSTNAME, parent.reportHostName);
        this.traceAnnotations = properties.getProperty(TRACE_ANNOTATIONS, parent.traceAnnotations);
        this.traceMethods = properties.getProperty(TRACE_METHODS, parent.traceMethods);
        this.traceExecutorsAll = Config.getPropertyBooleanValue(properties, TRACE_EXECUTORS_ALL, parent.traceExecutorsAll);
        this.traceExecutors = Config.getPropertyListValue(properties, TRACE_EXECUTORS, parent.traceExecutors);
        this.traceAnalyticsEnabled = Config.getPropertyBooleanValue(properties, TRACE_ANALYTICS_ENABLED, parent.traceAnalyticsEnabled);
        this.traceSamplingServiceRules = Config.getPropertyMapValue(properties, TRACE_SAMPLING_SERVICE_RULES, parent.traceSamplingServiceRules);
        this.traceSamplingOperationRules = Config.getPropertyMapValue(properties, TRACE_SAMPLING_OPERATION_RULES, parent.traceSamplingOperationRules);
        this.traceSampleRate = Config.getPropertyDoubleValue(properties, TRACE_SAMPLE_RATE, parent.traceSampleRate);
        this.traceRateLimit = Config.getPropertyDoubleValue(properties, TRACE_RATE_LIMIT, parent.traceRateLimit);
        this.profilingEnabled = Config.getPropertyBooleanValue(properties, PROFILING_ENABLED, parent.profilingEnabled);
        this.profilingUrl = properties.getProperty(PROFILING_URL, parent.profilingUrl);
        this.profilingTags = Config.getPropertyMapValue(properties, PROFILING_TAGS, parent.profilingTags);
        this.profilingStartDelay = Config.getPropertyIntegerValue(properties, PROFILING_START_DELAY, parent.profilingStartDelay);
        this.profilingStartForceFirst = Config.getPropertyBooleanValue(properties, PROFILING_START_FORCE_FIRST, parent.profilingStartForceFirst);
        this.profilingUploadPeriod = Config.getPropertyIntegerValue(properties, PROFILING_UPLOAD_PERIOD, parent.profilingUploadPeriod);
        this.profilingTemplateOverrideFile = properties.getProperty(PROFILING_TEMPLATE_OVERRIDE_FILE, parent.profilingTemplateOverrideFile);
        this.profilingUploadTimeout = Config.getPropertyIntegerValue(properties, PROFILING_UPLOAD_TIMEOUT, parent.profilingUploadTimeout);
        this.profilingUploadCompression = properties.getProperty(PROFILING_UPLOAD_COMPRESSION, parent.profilingUploadCompression);
        this.profilingProxyHost = properties.getProperty(PROFILING_PROXY_HOST, parent.profilingProxyHost);
        this.profilingProxyPort = Config.getPropertyIntegerValue(properties, PROFILING_PROXY_PORT, parent.profilingProxyPort);
        this.profilingProxyUsername = properties.getProperty(PROFILING_PROXY_USERNAME, parent.profilingProxyUsername);
        this.profilingProxyPassword = properties.getProperty(PROFILING_PROXY_PASSWORD, parent.profilingProxyPassword);
        this.profilingExceptionSampleLimit = Config.getPropertyIntegerValue(properties, PROFILING_EXCEPTION_SAMPLE_LIMIT, parent.profilingExceptionSampleLimit);
        this.profilingExceptionHistogramTopItems = Config.getPropertyIntegerValue(properties, PROFILING_EXCEPTION_HISTOGRAM_TOP_ITEMS, parent.profilingExceptionHistogramTopItems);
        this.profilingExceptionHistogramMaxCollectionSize = Config.getPropertyIntegerValue(properties, PROFILING_EXCEPTION_HISTOGRAM_MAX_COLLECTION_SIZE, parent.profilingExceptionHistogramMaxCollectionSize);
        this.kafkaClientPropagationEnabled = Config.getPropertyBooleanValue(properties, KAFKA_CLIENT_PROPAGATION_ENABLED, parent.kafkaClientPropagationEnabled);
        this.debugEnabled = parent.debugEnabled || Config.isDebugMode();
        this.kafkaClientBase64DecodingEnabled = Config.getPropertyBooleanValue(properties, KAFKA_CLIENT_BASE64_DECODING_ENABLED, parent.kafkaClientBase64DecodingEnabled);
        log.debug("New instance: {}", (Object)this);
    }

    public Map<String, String> getLocalRootSpanTags() {
        String hostName;
        Map<String, String> runtimeTags = this.getRuntimeTags();
        HashMap<String, String> result = new HashMap<String, String>(runtimeTags);
        result.put("language", "jvm");
        if (this.reportHostName && null != (hostName = Config.getHostName()) && !hostName.isEmpty()) {
            result.put("_dd.hostname", hostName);
        }
        return Collections.unmodifiableMap(result);
    }

    public Map<String, String> getMergedSpanTags() {
        Map<String, String> result = Config.newHashMap(this.getGlobalTags().size() + this.spanTags.size());
        result.putAll(this.getGlobalTags());
        result.putAll(this.spanTags);
        return Collections.unmodifiableMap(result);
    }

    public Map<String, String> getMergedJmxTags() {
        Map<String, String> runtimeTags = this.getRuntimeTags();
        Map<String, String> result = Config.newHashMap(this.getGlobalTags().size() + this.jmxTags.size() + runtimeTags.size() + 1);
        result.putAll(this.getGlobalTags());
        result.putAll(this.jmxTags);
        result.putAll(runtimeTags);
        result.put("service", this.serviceName);
        return Collections.unmodifiableMap(result);
    }

    public Map<String, String> getMergedProfilingTags() {
        Map<String, String> runtimeTags = this.getRuntimeTags();
        String host = Config.getHostName();
        Map<String, String> result = Config.newHashMap(this.getGlobalTags().size() + this.profilingTags.size() + runtimeTags.size() + 3);
        result.put("host", host);
        result.putAll(this.getGlobalTags());
        result.putAll(this.profilingTags);
        result.putAll(runtimeTags);
        result.put("service", this.serviceName);
        result.put("language", "jvm");
        return Collections.unmodifiableMap(result);
    }

    public float getInstrumentationAnalyticsSampleRate(String ... aliases) {
        for (String alias : aliases) {
            Float rate = Config.getFloatSettingFromEnvironment(alias + ".analytics.sample-rate", null);
            if (null == rate) continue;
            return rate.floatValue();
        }
        return 1.0f;
    }

    private Map<String, String> getGlobalTags() {
        return this.tags;
    }

    private Map<String, String> getRuntimeTags() {
        Map<String, String> result = Config.newHashMap(2);
        result.put("runtime-id", this.runtimeId);
        return Collections.unmodifiableMap(result);
    }

    public String getFinalProfilingUrl() {
        if (this.profilingUrl != null) {
            return this.profilingUrl;
        }
        if (this.apiKey != null) {
            return String.format(PROFILING_REMOTE_URL_TEMPLATE, this.site);
        }
        return String.format(PROFILING_LOCAL_URL_TEMPLATE, this.agentHost, this.agentPort);
    }

    public boolean isIntegrationEnabled(SortedSet<String> integrationNames, boolean defaultEnabled) {
        return Config.integrationEnabled(integrationNames, defaultEnabled);
    }

    @Deprecated
    private static boolean integrationEnabled(SortedSet<String> integrationNames, boolean defaultEnabled) {
        boolean anyEnabled = defaultEnabled;
        for (String name : integrationNames) {
            boolean configEnabled = Config.getBooleanSettingFromEnvironment("integration." + name + ".enabled", defaultEnabled);
            if (defaultEnabled) {
                anyEnabled &= configEnabled;
                continue;
            }
            anyEnabled |= configEnabled;
        }
        return anyEnabled;
    }

    public boolean isJmxFetchIntegrationEnabled(SortedSet<String> integrationNames, boolean defaultEnabled) {
        return Config.jmxFetchIntegrationEnabled(integrationNames, defaultEnabled);
    }

    public boolean isRuleEnabled(String name) {
        return Config.getBooleanSettingFromEnvironment("trace." + name + ".enabled", true) != false && Config.getBooleanSettingFromEnvironment("trace." + name.toLowerCase() + ".enabled", true) != false;
    }

    public static boolean jmxFetchIntegrationEnabled(SortedSet<String> integrationNames, boolean defaultEnabled) {
        boolean anyEnabled = defaultEnabled;
        for (String name : integrationNames) {
            boolean configEnabled = Config.getBooleanSettingFromEnvironment("jmxfetch." + name + ".enabled", defaultEnabled);
            if (defaultEnabled) {
                anyEnabled &= configEnabled;
                continue;
            }
            anyEnabled |= configEnabled;
        }
        return anyEnabled;
    }

    public boolean isEndToEndDurationEnabled(boolean defaultEnabled, String ... integrationNames) {
        return Config.isEnabled(integrationNames, ".e2e.duration.enabled", defaultEnabled);
    }

    public boolean isTraceAnalyticsIntegrationEnabled(SortedSet<String> integrationNames, boolean defaultEnabled) {
        return Config.traceAnalyticsIntegrationEnabled(integrationNames, defaultEnabled);
    }

    public boolean isTraceAnalyticsIntegrationEnabled(boolean defaultEnabled, String ... integrationNames) {
        return Config.isEnabled(integrationNames, ".analytics.enabled", defaultEnabled);
    }

    private static boolean isDebugMode() {
        String tracerDebugLevelSysprop = "dd.trace.debug";
        String tracerDebugLevelProp = System.getProperty("dd.trace.debug");
        if (tracerDebugLevelProp != null) {
            return Boolean.parseBoolean(tracerDebugLevelProp);
        }
        String tracerDebugLevelEnv = System.getenv("dd.trace.debug".replace('.', '_').toUpperCase());
        if (tracerDebugLevelEnv != null) {
            return Boolean.parseBoolean(tracerDebugLevelEnv);
        }
        return false;
    }

    public static boolean traceAnalyticsIntegrationEnabled(SortedSet<String> integrationNames, boolean defaultEnabled) {
        boolean anyEnabled = defaultEnabled;
        for (String name : integrationNames) {
            boolean configEnabled = Config.getBooleanSettingFromEnvironment(name + ".analytics.enabled", defaultEnabled);
            if (defaultEnabled) {
                anyEnabled &= configEnabled;
                continue;
            }
            anyEnabled |= configEnabled;
        }
        return anyEnabled;
    }

    private static boolean isEnabled(String[] integrationNames, String settingSuffix, boolean defaultEnabled) {
        boolean anyEnabled = defaultEnabled;
        for (String name : integrationNames) {
            boolean configEnabled = Config.getBooleanSettingFromEnvironment(name + settingSuffix, defaultEnabled);
            if (defaultEnabled) {
                anyEnabled &= configEnabled;
                continue;
            }
            anyEnabled |= configEnabled;
        }
        return anyEnabled;
    }

    private static String getSettingFromEnvironment(String name, String defaultValue) {
        String systemPropertyName = Config.propertyNameToSystemPropertyName(name);
        String value = System.getProperties().getProperty(systemPropertyName);
        if (null != value) {
            return value;
        }
        value = System.getenv(Config.propertyNameToEnvironmentVariableName(name));
        if (null != value) {
            return value;
        }
        value = propertiesFromConfigFile.getProperty(systemPropertyName);
        if (null != value) {
            return value;
        }
        value = propertiesFromCapturedEnv.getProperty(name);
        if (null != value) {
            return value;
        }
        return defaultValue;
    }

    @NonNull
    private static Map<String, String> getMapSettingFromEnvironment(String name, String defaultValue) {
        return Config.parseMap(Config.getSettingFromEnvironment(name, defaultValue), Config.propertyNameToSystemPropertyName(name));
    }

    @NonNull
    private static List<String> getListSettingFromEnvironment(String name, String defaultValue) {
        return Config.parseList(Config.getSettingFromEnvironment(name, defaultValue));
    }

    public static Boolean getBooleanSettingFromEnvironment(String name, Boolean defaultValue) {
        return Config.getSettingFromEnvironmentWithLog(name, Boolean.class, defaultValue);
    }

    public static Float getFloatSettingFromEnvironment(String name, Float defaultValue) {
        return Config.getSettingFromEnvironmentWithLog(name, Float.class, defaultValue);
    }

    @Deprecated
    private static Double getDoubleSettingFromEnvironment(String name, Double defaultValue) {
        return Config.getSettingFromEnvironmentWithLog(name, Double.class, defaultValue);
    }

    private static Integer getIntegerSettingFromEnvironment(String name, Integer defaultValue) {
        return Config.getSettingFromEnvironmentWithLog(name, Integer.class, defaultValue);
    }

    private static <T> T getSettingFromEnvironmentWithLog(String name, Class<T> tClass, T defaultValue) {
        try {
            return Config.valueOf(Config.getSettingFromEnvironment(name, null), tClass, defaultValue);
        }
        catch (NumberFormatException e) {
            log.warn("Invalid configuration for " + name, e);
            return defaultValue;
        }
    }

    private static Set<PropagationStyle> getPropagationStyleSetSettingFromEnvironmentOrDefault(String name, String defaultValue) {
        String value = Config.getSettingFromEnvironment(name, defaultValue);
        Set<PropagationStyle> result = Config.convertStringSetToPropagationStyleSet(Config.parseStringIntoSetOfNonEmptyStrings(value));
        if (result.isEmpty()) {
            result = Config.convertStringSetToPropagationStyleSet(Config.parseStringIntoSetOfNonEmptyStrings(defaultValue));
        }
        return result;
    }

    private static BitSet getIntegerRangeSettingFromEnvironment(String name, BitSet defaultValue) {
        String value = Config.getSettingFromEnvironment(name, null);
        try {
            return value == null ? defaultValue : Config.parseIntegerRangeSet(value, name);
        }
        catch (NumberFormatException e) {
            log.warn("Invalid configuration for " + name, e);
            return defaultValue;
        }
    }

    @NonNull
    private static String propertyNameToEnvironmentVariableName(String setting) {
        return ENV_REPLACEMENT.matcher(Config.propertyNameToSystemPropertyName(setting).toUpperCase()).replaceAll("_");
    }

    @NonNull
    private static String propertyNameToSystemPropertyName(String setting) {
        return PREFIX + setting;
    }

    private static <T> T valueOf(String value, @NonNull Class<T> tClass, T defaultValue) {
        if (tClass == null) {
            throw new NullPointerException("tClass is marked non-null but is null");
        }
        if (value == null || value.trim().isEmpty()) {
            return defaultValue;
        }
        try {
            return (T)PUBLIC_LOOKUP.findStatic(tClass, "valueOf", MethodType.methodType(tClass, String.class)).invoke(value);
        }
        catch (NumberFormatException e) {
            throw e;
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            log.debug("Can't invoke or access 'valueOf': ", e);
            throw new NumberFormatException(e.toString());
        }
        catch (Throwable e) {
            log.debug("Can't parse: ", e);
            throw new NumberFormatException(e.toString());
        }
    }

    private static Map<String, String> getPropertyMapValue(Properties properties, String name, Map<String, String> defaultValue) {
        String value = properties.getProperty(name);
        return value == null || value.trim().isEmpty() ? defaultValue : Config.parseMap(value, name);
    }

    private static List<String> getPropertyListValue(Properties properties, String name, List<String> defaultValue) {
        String value = properties.getProperty(name);
        return value == null || value.trim().isEmpty() ? defaultValue : Config.parseList(value);
    }

    private static Boolean getPropertyBooleanValue(Properties properties, String name, Boolean defaultValue) {
        return Config.valueOf(properties.getProperty(name), Boolean.class, defaultValue);
    }

    private static Integer getPropertyIntegerValue(Properties properties, String name, Integer defaultValue) {
        return Config.valueOf(properties.getProperty(name), Integer.class, defaultValue);
    }

    private static Double getPropertyDoubleValue(Properties properties, String name, Double defaultValue) {
        return Config.valueOf(properties.getProperty(name), Double.class, defaultValue);
    }

    private static Set<PropagationStyle> getPropagationStyleSetFromPropertyValue(Properties properties, String name) {
        Set<PropagationStyle> result;
        String value = properties.getProperty(name);
        if (value != null && !(result = Config.convertStringSetToPropagationStyleSet(Config.parseStringIntoSetOfNonEmptyStrings(value))).isEmpty()) {
            return result;
        }
        return null;
    }

    private static BitSet getPropertyIntegerRangeValue(Properties properties, String name, BitSet defaultValue) {
        String value = properties.getProperty(name);
        try {
            return value == null ? defaultValue : Config.parseIntegerRangeSet(value, name);
        }
        catch (NumberFormatException e) {
            log.warn("Invalid configuration for " + name, e);
            return defaultValue;
        }
    }

    @NonNull
    private static Map<String, String> parseMap(String str, String settingName) {
        if (str == null || str.trim().isEmpty()) {
            return Collections.emptyMap();
        }
        if (!str.matches("(([^,:]+:[^,:]*,)*([^,:]+:[^,:]*),?)?")) {
            log.warn("Invalid config for {}: '{}'. Must match 'key1:value1,key2:value2'.", (Object)settingName, (Object)str);
            return Collections.emptyMap();
        }
        String[] tokens = str.split(",", -1);
        Map<String, String> map = Config.newHashMap(tokens.length);
        for (String token : tokens) {
            String[] keyValue = token.split(":", -1);
            if (keyValue.length != 2) continue;
            String key = keyValue[0].trim();
            String value = keyValue[1].trim();
            if (value.length() <= 0) {
                log.warn("Ignoring empty value for key '{}' in config for {}", (Object)key, (Object)settingName);
                continue;
            }
            map.put(key, value);
        }
        return Collections.unmodifiableMap(map);
    }

    @NonNull
    static BitSet parseIntegerRangeSet(@NonNull String str, String settingName) throws NumberFormatException {
        String[] tokens;
        if (str == null) {
            throw new NullPointerException("str is marked non-null but is null");
        }
        if (!(str = str.replaceAll("\\s", "")).matches("\\d{3}(?:-\\d{3})?(?:,\\d{3}(?:-\\d{3})?)*")) {
            log.warn("Invalid config for {}: '{}'. Must be formatted like '400-403,405,410-499'.", (Object)settingName, (Object)str);
            throw new NumberFormatException();
        }
        int lastSeparator = Math.max(str.lastIndexOf(44), str.lastIndexOf(45));
        int maxValue = Integer.parseInt(str.substring(lastSeparator + 1));
        BitSet set = new BitSet(maxValue);
        for (String token : tokens = str.split(",", -1)) {
            int separator = token.indexOf(45);
            if (separator == -1) {
                set.set(Integer.parseInt(token));
                continue;
            }
            if (separator <= 0) continue;
            int left = Integer.parseInt(token.substring(0, separator));
            int right = Integer.parseInt(token.substring(separator + 1));
            int min = Math.min(left, right);
            int max = Math.max(left, right);
            set.set(min, max + 1);
        }
        return set;
    }

    @NonNull
    private static Map<String, String> newHashMap(int size) {
        return new HashMap<String, String>(size + 1, 1.0f);
    }

    @NonNull
    private static Map<String, String> getMapWithPropertiesDefinedByEnvironment(@NonNull Map<String, String> map, String ... propNames) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        if (propNames == null) {
            throw new NullPointerException("propNames is marked non-null but is null");
        }
        HashMap<String, String> res = new HashMap<String, String>(map);
        for (String propName : propNames) {
            String val = Config.getSettingFromEnvironment(propName, null);
            if (val == null) continue;
            res.put(propName, val);
        }
        return Collections.unmodifiableMap(res);
    }

    @NonNull
    private static Map<String, String> overwriteKeysFromProperties(@NonNull Map<String, String> map, @NonNull Properties properties, String ... keys) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        HashMap<String, String> res = new HashMap<String, String>(map);
        for (String propName : keys) {
            String val = properties.getProperty(propName, null);
            if (val == null) continue;
            res.put(propName, val);
        }
        return Collections.unmodifiableMap(res);
    }

    @NonNull
    private static List<String> parseList(String str) {
        if (str == null || str.trim().isEmpty()) {
            return Collections.emptyList();
        }
        String[] tokens = str.split(",", -1);
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokens[i].trim();
        }
        return Collections.unmodifiableList(Arrays.asList(tokens));
    }

    @NonNull
    private static Set<String> parseStringIntoSetOfNonEmptyStrings(String str) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String value : str.split(SPLIT_BY_SPACE_OR_COMMA_REGEX)) {
            if (value.isEmpty()) continue;
            result.add(value);
        }
        return Collections.unmodifiableSet(result);
    }

    @NonNull
    private static Set<PropagationStyle> convertStringSetToPropagationStyleSet(Set<String> input) {
        LinkedHashSet<PropagationStyle> result = new LinkedHashSet<PropagationStyle>();
        for (String value : input) {
            try {
                result.add(PropagationStyle.valueOf(value.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                log.debug("Cannot recognize config string value: {}, {}", (Object)value, (Object)PropagationStyle.class);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    private static Properties loadConfigurationFile() {
        Properties properties = new Properties();
        String configurationFilePath = System.getProperty(Config.propertyNameToSystemPropertyName(CONFIGURATION_FILE));
        if (null == configurationFilePath) {
            configurationFilePath = System.getenv(Config.propertyNameToEnvironmentVariableName(CONFIGURATION_FILE));
        }
        if (null == configurationFilePath) {
            return properties;
        }
        File configurationFile = new File(configurationFilePath = configurationFilePath.replaceFirst("^~", System.getProperty("user.home")));
        if (!configurationFile.exists()) {
            log.error("Configuration file '{}' not found.", (Object)configurationFilePath);
            return properties;
        }
        try (FileReader fileReader = new FileReader(configurationFile);){
            properties.load(fileReader);
        }
        catch (FileNotFoundException fnf) {
            log.error("Configuration file '{}' not found.", (Object)configurationFilePath);
        }
        catch (IOException ioe) {
            log.error("Configuration file '{}' cannot be accessed or correctly parsed.", (Object)configurationFilePath);
        }
        return properties;
    }

    private static String findConfigurationFile() {
        File configurationFile;
        String configurationFilePath = System.getProperty(Config.propertyNameToSystemPropertyName(CONFIGURATION_FILE));
        if (null == configurationFilePath) {
            configurationFilePath = System.getenv(Config.propertyNameToEnvironmentVariableName(CONFIGURATION_FILE));
        }
        if (null != configurationFilePath && !(configurationFile = new File(configurationFilePath = configurationFilePath.replaceFirst("^~", System.getProperty("user.home")))).exists()) {
            return configurationFilePath;
        }
        return "no config file present";
    }

    private static Properties loadCapturedEnvironment() {
        CapturedEnvironment capturedEnvironment = CapturedEnvironment.get();
        Properties properties = new Properties();
        for (Map.Entry<String, String> entry : capturedEnvironment.getProperties().entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            properties.put(entry.getKey(), entry.getValue());
        }
        return properties;
    }

    private static String getHostName() {
        String possibleHostname = System.getProperty("os.name").startsWith("Windows") ? System.getenv("COMPUTERNAME") : System.getenv("HOSTNAME");
        if (possibleHostname != null && !possibleHostname.isEmpty()) {
            log.debug("Determined hostname from environment variable");
            return possibleHostname.trim();
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec("hostname").getInputStream()));){
            possibleHostname = reader.readLine();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (possibleHostname != null && !possibleHostname.isEmpty()) {
            log.debug("Determined hostname from hostname command");
            return possibleHostname.trim();
        }
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public static Config get() {
        return INSTANCE;
    }

    @Deprecated
    public static Config get(Properties properties) {
        if (properties == null || properties.isEmpty()) {
            return INSTANCE;
        }
        return new Config(properties, INSTANCE);
    }

    public String toString() {
        return "Config(apiKey=" + this.profilingApiKeyMasker() + ", profilingProxyPassword=" + this.profilingProxyPasswordMasker() + ", runtimeId=" + this.getRuntimeId() + ", site=" + this.getSite() + ", serviceName=" + this.getServiceName() + ", traceEnabled=" + this.isTraceEnabled() + ", integrationsEnabled=" + this.isIntegrationsEnabled() + ", writerType=" + this.getWriterType() + ", agentConfiguredUsingDefault=" + this.isAgentConfiguredUsingDefault() + ", agentHost=" + this.getAgentHost() + ", agentPort=" + this.getAgentPort() + ", agentUnixDomainSocket=" + this.getAgentUnixDomainSocket() + ", agentTimeout=" + this.getAgentTimeout() + ", prioritySamplingEnabled=" + this.isPrioritySamplingEnabled() + ", traceResolverEnabled=" + this.isTraceResolverEnabled() + ", serviceMapping=" + this.getServiceMapping() + ", tags=" + this.tags + ", spanTags=" + this.spanTags + ", jmxTags=" + this.jmxTags + ", excludedClasses=" + this.getExcludedClasses() + ", headerTags=" + this.getHeaderTags() + ", httpServerErrorStatuses=" + this.getHttpServerErrorStatuses() + ", httpClientErrorStatuses=" + this.getHttpClientErrorStatuses() + ", httpServerTagQueryString=" + this.isHttpServerTagQueryString() + ", httpClientTagQueryString=" + this.isHttpClientTagQueryString() + ", httpClientSplitByDomain=" + this.isHttpClientSplitByDomain() + ", dbClientSplitByInstance=" + this.isDbClientSplitByInstance() + ", splitByTags=" + this.getSplitByTags() + ", scopeDepthLimit=" + this.getScopeDepthLimit() + ", scopeStrictMode=" + this.isScopeStrictMode() + ", partialFlushMinSpans=" + this.getPartialFlushMinSpans() + ", runtimeContextFieldInjection=" + this.isRuntimeContextFieldInjection() + ", propagationStylesToExtract=" + this.getPropagationStylesToExtract() + ", propagationStylesToInject=" + this.getPropagationStylesToInject() + ", jmxFetchEnabled=" + this.isJmxFetchEnabled() + ", jmxFetchConfigDir=" + this.getJmxFetchConfigDir() + ", jmxFetchConfigs=" + this.getJmxFetchConfigs() + ", jmxFetchMetricsConfigs=" + this.getJmxFetchMetricsConfigs() + ", jmxFetchCheckPeriod=" + this.getJmxFetchCheckPeriod() + ", jmxFetchRefreshBeansPeriod=" + this.getJmxFetchRefreshBeansPeriod() + ", jmxFetchStatsdHost=" + this.getJmxFetchStatsdHost() + ", jmxFetchStatsdPort=" + this.getJmxFetchStatsdPort() + ", healthMetricsEnabled=" + this.isHealthMetricsEnabled() + ", healthMetricsStatsdHost=" + this.getHealthMetricsStatsdHost() + ", healthMetricsStatsdPort=" + this.getHealthMetricsStatsdPort() + ", logsInjectionEnabled=" + this.isLogsInjectionEnabled() + ", reportHostName=" + this.isReportHostName() + ", traceAnnotations=" + this.getTraceAnnotations() + ", traceMethods=" + this.getTraceMethods() + ", traceExecutorsAll=" + this.isTraceExecutorsAll() + ", traceExecutors=" + this.getTraceExecutors() + ", traceAnalyticsEnabled=" + this.isTraceAnalyticsEnabled() + ", traceSamplingServiceRules=" + this.getTraceSamplingServiceRules() + ", traceSamplingOperationRules=" + this.getTraceSamplingOperationRules() + ", traceSampleRate=" + this.getTraceSampleRate() + ", traceRateLimit=" + this.getTraceRateLimit() + ", profilingEnabled=" + this.isProfilingEnabled() + ", profilingUrl=" + this.profilingUrl + ", profilingTags=" + this.profilingTags + ", profilingStartDelay=" + this.getProfilingStartDelay() + ", profilingStartForceFirst=" + this.isProfilingStartForceFirst() + ", profilingUploadPeriod=" + this.getProfilingUploadPeriod() + ", profilingTemplateOverrideFile=" + this.getProfilingTemplateOverrideFile() + ", profilingUploadTimeout=" + this.getProfilingUploadTimeout() + ", profilingUploadCompression=" + this.getProfilingUploadCompression() + ", profilingProxyHost=" + this.getProfilingProxyHost() + ", profilingProxyPort=" + this.getProfilingProxyPort() + ", profilingProxyUsername=" + this.getProfilingProxyUsername() + ", profilingExceptionSampleLimit=" + this.getProfilingExceptionSampleLimit() + ", profilingExceptionHistogramTopItems=" + this.getProfilingExceptionHistogramTopItems() + ", profilingExceptionHistogramMaxCollectionSize=" + this.getProfilingExceptionHistogramMaxCollectionSize() + ", kafkaClientPropagationEnabled=" + this.isKafkaClientPropagationEnabled() + ", kafkaClientBase64DecodingEnabled=" + this.isKafkaClientBase64DecodingEnabled() + ", debugEnabled=" + this.isDebugEnabled() + ", configFile=" + this.getConfigFile() + ")";
    }

    public String getRuntimeId() {
        return this.runtimeId;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getSite() {
        return this.site;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public boolean isIntegrationsEnabled() {
        return this.integrationsEnabled;
    }

    public String getWriterType() {
        return this.writerType;
    }

    public boolean isAgentConfiguredUsingDefault() {
        return this.agentConfiguredUsingDefault;
    }

    public String getAgentHost() {
        return this.agentHost;
    }

    public int getAgentPort() {
        return this.agentPort;
    }

    public String getAgentUnixDomainSocket() {
        return this.agentUnixDomainSocket;
    }

    public int getAgentTimeout() {
        return this.agentTimeout;
    }

    public boolean isPrioritySamplingEnabled() {
        return this.prioritySamplingEnabled;
    }

    public boolean isTraceResolverEnabled() {
        return this.traceResolverEnabled;
    }

    public Map<String, String> getServiceMapping() {
        return this.serviceMapping;
    }

    public List<String> getExcludedClasses() {
        return this.excludedClasses;
    }

    public Map<String, String> getHeaderTags() {
        return this.headerTags;
    }

    public BitSet getHttpServerErrorStatuses() {
        return this.httpServerErrorStatuses;
    }

    public BitSet getHttpClientErrorStatuses() {
        return this.httpClientErrorStatuses;
    }

    public boolean isHttpServerTagQueryString() {
        return this.httpServerTagQueryString;
    }

    public boolean isHttpClientTagQueryString() {
        return this.httpClientTagQueryString;
    }

    public boolean isHttpClientSplitByDomain() {
        return this.httpClientSplitByDomain;
    }

    public boolean isDbClientSplitByInstance() {
        return this.dbClientSplitByInstance;
    }

    public Set<String> getSplitByTags() {
        return this.splitByTags;
    }

    public Integer getScopeDepthLimit() {
        return this.scopeDepthLimit;
    }

    public boolean isScopeStrictMode() {
        return this.scopeStrictMode;
    }

    public Integer getPartialFlushMinSpans() {
        return this.partialFlushMinSpans;
    }

    public boolean isRuntimeContextFieldInjection() {
        return this.runtimeContextFieldInjection;
    }

    public Set<PropagationStyle> getPropagationStylesToExtract() {
        return this.propagationStylesToExtract;
    }

    public Set<PropagationStyle> getPropagationStylesToInject() {
        return this.propagationStylesToInject;
    }

    public boolean isJmxFetchEnabled() {
        return this.jmxFetchEnabled;
    }

    public String getJmxFetchConfigDir() {
        return this.jmxFetchConfigDir;
    }

    public List<String> getJmxFetchConfigs() {
        return this.jmxFetchConfigs;
    }

    @Deprecated
    public List<String> getJmxFetchMetricsConfigs() {
        return this.jmxFetchMetricsConfigs;
    }

    public Integer getJmxFetchCheckPeriod() {
        return this.jmxFetchCheckPeriod;
    }

    public Integer getJmxFetchRefreshBeansPeriod() {
        return this.jmxFetchRefreshBeansPeriod;
    }

    public String getJmxFetchStatsdHost() {
        return this.jmxFetchStatsdHost;
    }

    public Integer getJmxFetchStatsdPort() {
        return this.jmxFetchStatsdPort;
    }

    public boolean isHealthMetricsEnabled() {
        return this.healthMetricsEnabled;
    }

    public String getHealthMetricsStatsdHost() {
        return this.healthMetricsStatsdHost;
    }

    public Integer getHealthMetricsStatsdPort() {
        return this.healthMetricsStatsdPort;
    }

    public boolean isLogsInjectionEnabled() {
        return this.logsInjectionEnabled;
    }

    public boolean isReportHostName() {
        return this.reportHostName;
    }

    public String getTraceAnnotations() {
        return this.traceAnnotations;
    }

    public String getTraceMethods() {
        return this.traceMethods;
    }

    public boolean isTraceExecutorsAll() {
        return this.traceExecutorsAll;
    }

    public List<String> getTraceExecutors() {
        return this.traceExecutors;
    }

    public boolean isTraceAnalyticsEnabled() {
        return this.traceAnalyticsEnabled;
    }

    public Map<String, String> getTraceSamplingServiceRules() {
        return this.traceSamplingServiceRules;
    }

    public Map<String, String> getTraceSamplingOperationRules() {
        return this.traceSamplingOperationRules;
    }

    public Double getTraceSampleRate() {
        return this.traceSampleRate;
    }

    public Double getTraceRateLimit() {
        return this.traceRateLimit;
    }

    public boolean isProfilingEnabled() {
        return this.profilingEnabled;
    }

    public int getProfilingStartDelay() {
        return this.profilingStartDelay;
    }

    public boolean isProfilingStartForceFirst() {
        return this.profilingStartForceFirst;
    }

    public int getProfilingUploadPeriod() {
        return this.profilingUploadPeriod;
    }

    public String getProfilingTemplateOverrideFile() {
        return this.profilingTemplateOverrideFile;
    }

    public int getProfilingUploadTimeout() {
        return this.profilingUploadTimeout;
    }

    public String getProfilingUploadCompression() {
        return this.profilingUploadCompression;
    }

    public String getProfilingProxyHost() {
        return this.profilingProxyHost;
    }

    public int getProfilingProxyPort() {
        return this.profilingProxyPort;
    }

    public String getProfilingProxyUsername() {
        return this.profilingProxyUsername;
    }

    public String getProfilingProxyPassword() {
        return this.profilingProxyPassword;
    }

    public int getProfilingExceptionSampleLimit() {
        return this.profilingExceptionSampleLimit;
    }

    public int getProfilingExceptionHistogramTopItems() {
        return this.profilingExceptionHistogramTopItems;
    }

    public int getProfilingExceptionHistogramMaxCollectionSize() {
        return this.profilingExceptionHistogramMaxCollectionSize;
    }

    public boolean isKafkaClientPropagationEnabled() {
        return this.kafkaClientPropagationEnabled;
    }

    public boolean isKafkaClientBase64DecodingEnabled() {
        return this.kafkaClientBase64DecodingEnabled;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    static {
        INSTANCE = new Config();
    }
}

