/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.bootstrap.InternalJarURLHandler;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class DatadogClassLoader
extends URLClassLoader {
    private static final Logger log = LoggerFactory.getLogger(DatadogClassLoader.class);
    protected final InternalJarURLHandler internalJarURLHandler;
    private final ClassLoader bootstrapProxy;
    private final String classLoaderName;
    private String lastPackage = null;

    public DatadogClassLoader(URL bootstrapJarLocation, String internalJarFileName, ClassLoader bootstrapProxy, ClassLoader parent) {
        super(new URL[0], parent);
        this.bootstrapProxy = bootstrapProxy;
        this.classLoaderName = null == internalJarFileName ? "datadog" : internalJarFileName;
        this.internalJarURLHandler = new InternalJarURLHandler(internalJarFileName, bootstrapJarLocation);
        try {
            this.addURL(new URL("x-internal-jar", null, 0, "/", this.internalJarURLHandler));
        }
        catch (MalformedURLException e) {
            log.error("URL malformed.  Unsupported JDK?", e);
        }
    }

    @Override
    public URL getResource(String resourceName) {
        URL bootstrapResource = this.bootstrapProxy.getResource(resourceName);
        if (null == bootstrapResource) {
            return super.getResource(resourceName);
        }
        return bootstrapResource;
    }

    public boolean hasLoadedClass(String className) {
        return this.findLoadedClass(className) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class<?> loadFromPackage(String packageName, String name) throws ClassNotFoundException {
        if (this.internalJarURLHandler.getPackages().contains(packageName)) {
            DatadogClassLoader datadogClassLoader = this;
            synchronized (datadogClassLoader) {
                Class<?> loaded = this.findLoadedClass(name);
                return null == loaded ? this.findClass(name) : loaded;
            }
        }
        return super.loadClass(name);
    }

    String getPackageName(String className) {
        String packageName = this.lastPackage;
        if (null == packageName || !className.startsWith(packageName)) {
            int end = className.lastIndexOf(46);
            if (end != -1) {
                this.lastPackage = packageName = className.substring(0, end);
            } else {
                packageName = "";
            }
        }
        return packageName;
    }

    public ClassLoader getBootstrapProxy() {
        return this.bootstrapProxy;
    }

    public String toString() {
        return this.classLoaderName;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }

    public static class DelegateClassLoader
    extends DatadogClassLoader {
        private final DatadogClassLoader shared;

        public DelegateClassLoader(URL bootstrapJarLocation, String internalJarFileName, ClassLoader bootstrapProxy, ClassLoader parent, ClassLoader shared) {
            super(bootstrapJarLocation, internalJarFileName, bootstrapProxy, parent);
            this.shared = (DatadogClassLoader)shared;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            String packageName = this.shared.getPackageName(name);
            if (this.internalJarURLHandler.getPackages().contains(packageName)) {
                DelegateClassLoader delegateClassLoader = this;
                synchronized (delegateClassLoader) {
                    Class<?> loaded = this.findLoadedClass(name);
                    return null == loaded ? this.findClass(name) : loaded;
                }
            }
            return this.shared.loadFromPackage(packageName, name);
        }

        static {
            ClassLoader.registerAsParallelCapable();
        }
    }

    public static final class BootstrapClassLoaderProxy
    extends URLClassLoader {
        public BootstrapClassLoaderProxy(URL url) {
            super(new URL[]{url}, (ClassLoader)null);
        }

        public BootstrapClassLoaderProxy() {
            super(new URL[0], (ClassLoader)null);
        }

        @Override
        public void addURL(URL url) {
            super.addURL(url);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            throw new ClassNotFoundException(name);
        }

        static {
            ClassLoader.registerAsParallelCapable();
        }
    }
}

