/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.decorator;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.decorator.BaseDecorator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public abstract class TestDecorator
extends BaseDecorator {
    private static final Logger log = LoggerFactory.getLogger(TestDecorator.class);
    public static final String TEST_PASS = "PASS";
    public static final String TEST_FAIL = "FAIL";
    public static final String TEST_SKIP = "SKIP";

    protected abstract String testFramework();

    protected String spanKind() {
        return "test";
    }

    @Override
    protected String spanType() {
        return "test";
    }

    @Override
    public AgentSpan afterStart(AgentSpan span) {
        assert (span != null);
        span.setTag("span.kind", this.spanKind());
        span.setTag("span.type", this.spanType());
        span.setTag("test.framework", this.testFramework());
        return super.afterStart(span);
    }

    public List<String> testNames(Class<?> testClass, Class<? extends Annotation> testAnnotation) {
        Method[] methods;
        ArrayList<String> testNames = new ArrayList<String>();
        for (Method method : methods = testClass.getMethods()) {
            if (method.getAnnotation(testAnnotation) == null) continue;
            testNames.add(method.getName());
        }
        return testNames;
    }
}

