/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.decorator;

import datadog.trace.api.Config;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.FixedSizeCache;
import datadog.trace.bootstrap.instrumentation.api.Function;
import datadog.trace.bootstrap.instrumentation.api.Functions;
import datadog.trace.bootstrap.instrumentation.decorator.ClientDecorator;

public abstract class DatabaseClientDecorator<CONNECTION>
extends ClientDecorator {
    private static final FixedSizeCache<CharSequence, CharSequence> CACHE = new FixedSizeCache(16);
    private static final Function<CharSequence, CharSequence> APPEND_OPERATION = new Functions.Suffix(".query");

    protected abstract String dbType();

    protected abstract String dbUser(CONNECTION var1);

    protected abstract String dbInstance(CONNECTION var1);

    public AgentSpan onConnection(AgentSpan span, CONNECTION connection) {
        assert (span != null);
        if (connection != null) {
            span.setTag("db.user", this.dbUser(connection));
            String instanceName = this.dbInstance(connection);
            span.setTag("db.instance", instanceName);
            if (instanceName != null && Config.get().isDbClientSplitByInstance()) {
                span.setTag("service.name", instanceName);
            }
        }
        return span;
    }

    public AgentSpan onStatement(AgentSpan span, CharSequence statement) {
        assert (span != null);
        span.setTag("db.statement", statement);
        return span;
    }

    protected void processDatabaseType(AgentSpan span, String dbType) {
        span.setServiceName(dbType);
        span.setOperationName(CACHE.computeIfAbsent(dbType, APPEND_OPERATION));
        span.setTag("db.type", dbType);
    }
}

