/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.bootstrap.instrumentation.api.Pair;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.Permission;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class InternalJarURLHandler
extends URLStreamHandler {
    private static final Logger log = LoggerFactory.getLogger(InternalJarURLHandler.class);
    private static final WeakReference<Pair<String, JarEntry>> NULL = new WeakReference<Object>(null);
    private final String name;
    private final FileNotInInternalJar notFound;
    private final Map<String, Object> packages = new HashMap<String, Object>();
    private final JarFile bootstrapJarFile;
    private static final ThreadLocal<StringBuilder> JAR_ENTRY_QUERY = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder(128);
        }
    };
    private WeakReference<Pair<String, JarEntry>> cache = NULL;

    InternalJarURLHandler(String internalJarFileName, URL bootstrapJarLocation) {
        this.name = internalJarFileName;
        this.notFound = new FileNotInInternalJar(internalJarFileName);
        String filePrefix = internalJarFileName + "/";
        JarFile jarFile = null;
        try {
            if (bootstrapJarLocation != null) {
                jarFile = new JarFile(new File(bootstrapJarLocation.toURI()), false);
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!name.startsWith(filePrefix) || !entry.isDirectory() || name.contains("/META-INF/")) continue;
                    int prefix = filePrefix.length();
                    if (name.length() <= prefix) continue;
                    String dir = name.substring(prefix, name.length() - 1);
                    String currentPackage = dir.replace('/', '.');
                    this.packages.put(currentPackage, new Object());
                }
            }
        }
        catch (IOException | URISyntaxException e) {
            log.error("Unable to read internal jar", e);
        }
        if (this.packages.isEmpty()) {
            log.warn("No internal jar entries found");
        }
        this.bootstrapJarFile = jarFile;
    }

    Map<String, Object> getPackages() {
        return this.packages;
    }

    Object getPackageLock(String packageName) {
        return this.packages.get(packageName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        String filename = url.getFile();
        if ("/".equals(filename)) {
            return new InternalJarURLConnection(url, new ByteArrayInputStream(new byte[0]));
        }
        Pair<String, JarEntry> pair = (Pair<String, JarEntry>)this.cache.get();
        if (null == pair || !filename.equals(pair.getLeft())) {
            StringBuilder sb = JAR_ENTRY_QUERY.get();
            sb.append(this.name).append(filename);
            if (filename.endsWith(".class")) {
                sb.append("data");
            }
            String classFileName = sb.toString();
            sb.setLength(0);
            JarEntry entry = this.bootstrapJarFile.getJarEntry(classFileName);
            if (null == entry) throw this.notFound;
            pair = Pair.of(filename, entry);
            this.cache = new WeakReference<Pair<String, JarEntry>>(pair);
            return new InternalJarURLConnection(url, this.bootstrapJarFile.getInputStream(pair.getRight()));
        } else {
            this.cache = NULL;
        }
        return new InternalJarURLConnection(url, this.bootstrapJarFile.getInputStream((ZipEntry)pair.getRight()));
    }

    private static class FileNotInInternalJar
    extends IOException {
        public FileNotInInternalJar(String jarName) {
            super("class not found in " + jarName);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    private static class InternalJarURLConnection
    extends URLConnection {
        private final InputStream inputStream;

        private InternalJarURLConnection(URL url, InputStream inputStream) {
            super(url);
            this.inputStream = inputStream;
        }

        @Override
        public void connect() {
            this.connected = true;
        }

        @Override
        public InputStream getInputStream() {
            return this.inputStream;
        }

        @Override
        public Permission getPermission() {
            return null;
        }
    }
}

