/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.java.concurrent;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.bootstrap.ContextStore;
import datadog.trace.context.TraceScope;
import java.util.concurrent.atomic.AtomicReference;

public class State {
    private static final Logger log = LoggerFactory.getLogger(State.class);
    public static ContextStore.Factory<State> FACTORY = new ContextStore.Factory<State>(){

        @Override
        public State create() {
            return new State();
        }
    };
    private final AtomicReference<TraceScope.Continuation> continuationRef = new AtomicReference<Object>(null);

    private State() {
    }

    public boolean setContinuation(TraceScope.Continuation continuation) {
        boolean result = this.continuationRef.compareAndSet(null, continuation);
        assert (result) : "Losing the race to set the continuation correlates with bugs. " + this.continuationRef.get() + " beat " + continuation;
        if (!result && log.isDebugEnabled()) {
            log.debug("Failed to set continuation because another continuation is already set {}: new: {}, old: {}", this, continuation, this.continuationRef.get());
        }
        return result;
    }

    public void closeContinuation() {
        TraceScope.Continuation continuation = this.continuationRef.getAndSet(null);
        if (continuation != null) {
            continuation.cancel();
        }
    }

    public TraceScope.Continuation getAndResetContinuation() {
        return this.continuationRef.getAndSet(null);
    }
}

