/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.env;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class CapturedEnvironment {
    private static final Logger log = LoggerFactory.getLogger(CapturedEnvironment.class);
    private static final CapturedEnvironment INSTANCE = new CapturedEnvironment();
    private final Map<String, String> properties = new HashMap<String, String>();

    CapturedEnvironment() {
        this.properties.put("service.name", this.autodetectServiceName());
    }

    static void useFixedEnv(Map<String, String> props) {
        CapturedEnvironment.INSTANCE.properties.clear();
        for (Map.Entry<String, String> entry : props.entrySet()) {
            CapturedEnvironment.INSTANCE.properties.put(entry.getKey(), entry.getValue());
        }
    }

    private String autodetectServiceName() {
        return this.extractJarOrClass(System.getProperty("sun.java.command"));
    }

    private String extractJarOrClass(String command) {
        if (command == null || command.equals("")) {
            return null;
        }
        String[] split = command.trim().split(" ");
        if (split.length == 0 || split[0].equals("")) {
            return null;
        }
        String candidate = split[0];
        if (candidate.endsWith(".jar")) {
            return new File(candidate).getName().replace(".jar", "");
        }
        return candidate;
    }

    public static CapturedEnvironment get() {
        return INSTANCE;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }
}

