/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.ci;

import datadog.trace.bootstrap.instrumentation.ci.CIProviderInfo;

class BitBucketInfo
extends CIProviderInfo {
    public static final String BITBUCKET = "BITBUCKET_COMMIT";
    public static final String BITBUCKET_PROVIDER_NAME = "bitbucket";
    public static final String BITBUCKET_PIPELINE_ID = "BITBUCKET_PIPELINE_UUID";
    public static final String BITBUCKET_REPO_FULL_NAME = "BITBUCKET_REPO_FULL_NAME";
    public static final String BITBUCKET_BUILD_NUMBER = "BITBUCKET_BUILD_NUMBER";
    public static final String BITBUCKET_WORKSPACE_PATH = "BITBUCKET_CLONE_DIR";
    public static final String BITBUCKET_GIT_REPOSITORY_URL = "BITBUCKET_GIT_SSH_ORIGIN";
    public static final String BITBUCKET_GIT_COMMIT = "BITBUCKET_COMMIT";
    public static final String BITBUCKET_GIT_BRANCH = "BITBUCKET_BRANCH";
    public static final String BITBUCKET_GIT_TAG = "BITBUCKET_TAG";

    BitBucketInfo() {
        String repo = System.getenv(BITBUCKET_REPO_FULL_NAME);
        String number = System.getenv(BITBUCKET_BUILD_NUMBER);
        String url = this.buildPipelineUrl(repo, number);
        this.ciTags = new CIProviderInfo.CITagsBuilder().withCiProviderName(BITBUCKET_PROVIDER_NAME).withCiPipelineId(this.buildPipelineId()).withCiPipelineName(repo).withCiPipelineNumber(number).withCiPipelineUrl(url).withCiJorUrl(url).withCiWorkspacePath(this.expandTilde(System.getenv(BITBUCKET_WORKSPACE_PATH))).withGitRepositoryUrl(this.filterSensitiveInfo(System.getenv(BITBUCKET_GIT_REPOSITORY_URL))).withGitCommit(System.getenv("BITBUCKET_COMMIT")).withGitBranch(this.normalizeRef(System.getenv(BITBUCKET_GIT_BRANCH))).withGitTag(this.normalizeRef(System.getenv(BITBUCKET_GIT_TAG))).build();
    }

    private String buildPipelineUrl(String repo, String number) {
        return String.format("https://bitbucket.org/%s/addon/pipelines/home#!/results/%s", repo, number);
    }

    private String buildPipelineId() {
        String id = System.getenv(BITBUCKET_PIPELINE_ID);
        if (id != null) {
            id = id.replaceAll("}", "").replaceAll("\\{", "");
        }
        return id;
    }
}

