/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.java.concurrent;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.bootstrap.ContextStore;
import datadog.trace.context.TraceScope;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public final class ConcurrentState {
    private static final Logger log = LoggerFactory.getLogger(ConcurrentState.class);
    private static final TraceScope.Continuation CLAIMED = new ContinuationClaim();
    public static ContextStore.Factory<ConcurrentState> FACTORY = new ContextStore.Factory<ConcurrentState>(){

        @Override
        public ConcurrentState create() {
            return new ConcurrentState();
        }
    };
    private volatile TraceScope.Continuation continuation = null;
    private static final AtomicReferenceFieldUpdater<ConcurrentState, TraceScope.Continuation> CONTINUATION = AtomicReferenceFieldUpdater.newUpdater(ConcurrentState.class, TraceScope.Continuation.class, "continuation");

    private ConcurrentState() {
    }

    public static <K> void captureScope(ContextStore<K, ConcurrentState> contextStore, K key, TraceScope scope) {
        ConcurrentState state;
        if (scope != null && !(state = contextStore.putIfAbsent(key, FACTORY)).captureAndSetContinuation(scope) && log.isDebugEnabled()) {
            log.debug("continuation was already set for {} in scope {}, no continuation captured.", (Object)key, (Object)scope);
        }
    }

    public static <K> TraceScope activateAndContinueContinuation(ContextStore<K, ConcurrentState> contextStore, K key) {
        ConcurrentState state = contextStore.get(key);
        if (state == null) {
            return null;
        }
        return state.activateAndContinueContinuation();
    }

    public static <K> void closeScope(ContextStore<K, ConcurrentState> contextStore, K key, TraceScope scope, Throwable throwable) {
        ConcurrentState state = contextStore.get(key);
        if (scope != null) {
            scope.close();
            return;
        }
        if (state == null) {
            return;
        }
        if (throwable != null) {
            state.closeContinuation();
        }
    }

    public static <K> void closeAndClearContinuation(ContextStore<K, ConcurrentState> contextStore, K key) {
        ConcurrentState state = contextStore.get(key);
        if (state == null) {
            return;
        }
        state.closeAndClearContinuation();
    }

    private boolean captureAndSetContinuation(TraceScope scope) {
        if (CONTINUATION.compareAndSet(this, null, CLAIMED)) {
            CONTINUATION.lazySet(this, scope.captureConcurrent());
            return true;
        }
        return false;
    }

    private TraceScope activateAndContinueContinuation() {
        TraceScope.Continuation continuation = CONTINUATION.get(this);
        if (continuation != null && continuation != CLAIMED) {
            return continuation.activate();
        }
        return null;
    }

    private void closeContinuation() {
        TraceScope.Continuation continuation = CONTINUATION.get(this);
        if (continuation != null && continuation != CLAIMED) {
            continuation.cancel();
        }
    }

    private void closeAndClearContinuation() {
        TraceScope.Continuation continuation = CONTINUATION.get(this);
        if (continuation != null && continuation != CLAIMED) {
            CONTINUATION.compareAndSet(this, continuation, CLAIMED);
            continuation.cancel();
        }
    }

    private static final class ContinuationClaim
    implements TraceScope.Continuation {
        private ContinuationClaim() {
        }

        @Override
        public TraceScope activate() {
            throw new IllegalStateException();
        }

        @Override
        public void cancel() {
            throw new IllegalStateException();
        }
    }
}

