/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.css.core.internal.Logger;
import org.eclipse.wst.css.core.internal.parser.CSSRegionUtil;
import org.eclipse.wst.css.core.internal.util.CSSUtil;
import org.eclipse.wst.css.core.internal.util.RegionIterator;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredTextReParser;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.text.StructuredDocumentReParser;

public class CSSStructuredDocumentReParser
extends StructuredDocumentReParser {
    @Override
    protected StructuredDocumentEvent checkForCrossStructuredDocumentRegionSyntax() {
        int checkStart = this.fStart;
        int checkEnd = this.fStart + this.fLengthToReplace - 1;
        IStructuredDocumentRegion endRegion = this.fStructuredDocument.getRegionAtCharacterOffset(checkEnd);
        if (endRegion != null) {
            checkEnd = endRegion.getEndOffset();
        }
        ReparseRange range = new ReparseRange(checkStart, checkEnd);
        range.expand(this.getUpdateRangeForDelimiter(range.getStart(), range.getEnd()));
        range.expand(this.getUpdateRangeForUnknownRegion(range.getStart(), range.getEnd()));
        range.expand(this.getUpdateRangeForQuotes(range.getStart(), range.getEnd()));
        range.expand(this.getUpdateRangeForComments(range.getStart(), range.getEnd()));
        range.expand(this.getUpdateRangeForBraces(range.getStart(), range.getEnd()));
        StructuredDocumentEvent result = this.checkInsideBrace(range.getStart(), range.getEnd());
        if (result == null) {
            result = this.reparse(range.getStart(), range.getEnd());
        }
        return result;
    }

    private ReparseRange getUpdateRangeForUnknownRegion(int start, int end) {
        int newStart = start;
        RegionIterator iterator = new RegionIterator(this.fStructuredDocument, start - 1);
        if (iterator.hasPrev()) {
            iterator.prev();
        }
        while (iterator.hasPrev()) {
            ITextRegion region = iterator.prev();
            if (region == null || region.getType() != "UNKNOWN") break;
            newStart = iterator.getStructuredDocumentRegion().getStartOffset(region);
        }
        if (start != newStart) {
            return new ReparseRange(newStart, end);
        }
        return null;
    }

    private ReparseRange getUpdateRangeForDelimiter(int start, int end) {
        IStructuredDocumentRegion prevRegion;
        IStructuredDocumentRegion docRegion;
        if (this.dirtyStart != null && this.dirtyStart.getStart() < start) {
            start = this.dirtyStart.getStart();
        }
        if ((docRegion = this.fStructuredDocument.getRegionAtCharacterOffset(start)) == null) {
            return null;
        }
        if (docRegion.getType() == "DELIMITER" && (prevRegion = docRegion.getPrevious()) != null) {
            return new ReparseRange(prevRegion.getStart(), end);
        }
        return null;
    }

    private ReparseRange getUpdateRangeForQuotes(int start, int end) {
        ReparseRange range = new ReparseRange();
        range.expand(this.getUpdateRangeForPair(start, end, '\"', '\"'));
        range.expand(this.getUpdateRangeForPair(start, end, '\'', '\''));
        return range.isValid() ? range : null;
    }

    private ReparseRange getUpdateRangeForComments(int start, int end) {
        ReparseRange range = new ReparseRange();
        range.expand(this.getUpdateRangeForPair(start, end, "/*", "*/"));
        range.expand(this.getUpdateRangeForPair(start, end, "<%", "%>"));
        return range.isValid() ? range : null;
    }

    private ReparseRange getUpdateRangeForBraces(int start, int end) {
        ReparseRange range = new ReparseRange();
        range.expand(this.getUpdateRangeForPair(start, end, '[', ']'));
        range.expand(this.getUpdateRangeForPair(start, end, '(', ')'));
        range.expand(this.getUpdateRangeForPair(start, end, '{', '}'));
        return range.isValid() ? range : null;
    }

    private StructuredDocumentEvent checkInsideBrace(int start, int end) {
        IStructuredDocumentRegion endRegion;
        IStructuredDocumentRegion startRegion;
        IStructuredDocumentRegion nextRegion;
        IStructuredDocumentRegion prevRegion;
        StructuredDocumentEvent result = null;
        IStructuredDocumentRegion region = this.fStructuredDocument.getRegionAtCharacterOffset(start);
        if (region == null) {
            return null;
        }
        boolean bDeclaration = false;
        String type = region.getType();
        if (CSSRegionUtil.isDeclarationType(type) || type == "LBRACE" || type == "RBRACE") {
            bDeclaration = true;
        }
        if (!bDeclaration && (prevRegion = CSSUtil.findPreviousSignificantNode(region)) != null && (CSSRegionUtil.isDeclarationType(type = prevRegion.getType()) || type == "LBRACE")) {
            bDeclaration = true;
        }
        if (!bDeclaration && (nextRegion = CSSUtil.findNextSignificantNode(region)) != null && (CSSRegionUtil.isDeclarationType(type = nextRegion.getType()) || type == "RBRACE")) {
            bDeclaration = true;
        }
        if (bDeclaration && (startRegion = this.findRuleStart(region)) != null && (endRegion = this.fStructuredDocument.getRegionAtCharacterOffset(end)) != null) {
            result = this.reparse(startRegion, endRegion);
        }
        return result;
    }

    private IStructuredDocumentRegion findRuleStart(IStructuredDocumentRegion startRegion) {
        IStructuredDocumentRegion region = startRegion;
        while (region != null && region.getType() != "LBRACE") {
            region = region.getPrevious();
        }
        if (region != null && this.isLeadingDeclarationType((region = region.getPrevious()).getType())) {
            return region;
        }
        return null;
    }

    private boolean isLeadingDeclarationType(String type) {
        return type == "PAGE" || type == "FONT_FACE" || CSSRegionUtil.isSelectorType(type);
    }

    private ReparseRange getUpdateRangeForPair(int start, int end, String opener, String closer) {
        StringBuffer deletionBuf = new StringBuffer();
        StringBuffer insertionBuf = new StringBuffer();
        int quoteLen = Math.max(opener.length(), closer.length());
        if (1 < quoteLen) {
            String addStr;
            int addStart = start - (quoteLen - 1);
            if (addStart >= 0) {
                addStr = this.fStructuredDocument.get(addStart, quoteLen - 1);
                deletionBuf.append(addStr);
                insertionBuf.append(addStr);
            }
            deletionBuf.append(this.fDeletedText);
            insertionBuf.append(this.fChanges);
            if (end + (quoteLen - 1) < this.fStructuredDocument.getLength()) {
                addStr = this.fStructuredDocument.get(end + 1, quoteLen - 1);
                deletionBuf.append(addStr);
                insertionBuf.append(addStr);
            }
        } else {
            deletionBuf.append(this.fDeletedText);
            insertionBuf.append(this.fChanges);
        }
        String deletion = deletionBuf.toString();
        String insertion = insertionBuf.toString();
        int rangeStart = start;
        int rangeEnd = end;
        if (deletion.indexOf(opener) >= 0 || deletion.indexOf(closer) >= 0 || insertion.indexOf(opener) >= 0 || insertion.indexOf(closer) >= 0) {
            int e;
            int s;
            try {
                IRegion endRegion;
                IRegion startRegion;
                s = start <= this.fStructuredDocument.getLength() ? ((startRegion = this.getFindReplaceDocumentAdapter().find(start - 1, opener, false, false, false, false)) != null ? startRegion.getOffset() : -1) : -1;
                e = end < this.fStructuredDocument.getLength() - 1 ? ((endRegion = this.getFindReplaceDocumentAdapter().find(end + 1, closer, true, false, false, false)) != null ? endRegion.getOffset() : -1) : -1;
            }
            catch (BadLocationException ex) {
                Logger.logException(ex);
                return null;
            }
            if (s >= 0) {
                rangeStart = Math.min(rangeStart, s);
            }
            if (e >= 0) {
                rangeEnd = Math.max(rangeEnd, e);
            }
        }
        if (rangeStart < start || end < rangeEnd) {
            return new ReparseRange(rangeStart, rangeEnd);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private int findChar(char c, int start, boolean forward) throws BadLocationException {
        block4: {
            v0 = stop = forward != false ? this.fStructuredDocument.getLength() : 0;
            if (!forward) ** GOTO lbl12
            while (start < stop) {
                if (this.fStructuredDocument.getChar(start) == c) {
                    return start;
                }
                ++start;
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                if (this.fStructuredDocument.getChar(start) == c) {
                    return start;
                }
                --start;
lbl12:
                // 2 sources

                ** while (start >= stop)
            }
        }
        return -1;
    }

    ReparseRange getUpdateRangeForPair(int start, int end, char opener, char closer) {
        StringBuffer deletionBuf = new StringBuffer();
        StringBuffer insertionBuf = new StringBuffer();
        deletionBuf.append(this.fDeletedText);
        insertionBuf.append(this.fChanges);
        String deletion = deletionBuf.toString();
        String insertion = insertionBuf.toString();
        int rangeStart = start;
        int rangeEnd = end;
        if (deletion.indexOf(opener) >= 0 || deletion.indexOf(closer) >= 0 || insertion.indexOf(opener) >= 0 || insertion.indexOf(closer) >= 0) {
            int s = -1;
            int e = -1;
            try {
                if (start <= this.fStructuredDocument.getLength()) {
                    s = this.findChar(opener, start - 1, false);
                }
                if (end < this.fStructuredDocument.getLength() - 1) {
                    e = this.findChar(closer, end + 1, true);
                }
            }
            catch (BadLocationException ex) {
                Logger.logException(ex);
                return null;
            }
            if (s >= 0) {
                rangeStart = Math.min(rangeStart, s);
            }
            if (e >= 0) {
                rangeEnd = Math.max(rangeEnd, e);
            }
        }
        if (rangeStart < start || end < rangeEnd) {
            return new ReparseRange(rangeStart, rangeEnd);
        }
        return null;
    }

    @Override
    public IStructuredTextReParser newInstance() {
        return new CSSStructuredDocumentReParser();
    }

    class ReparseRange {
        private int fRangeStart;
        private int fRangeEnd;

        ReparseRange() {
            this.reset();
        }

        ReparseRange(int start, int end) {
            this.fRangeStart = start;
            this.fRangeEnd = end;
        }

        void setStart(int start) {
            this.fRangeStart = start;
        }

        void setEnd(int end) {
            this.fRangeEnd = end;
        }

        int getStart() {
            return this.fRangeStart;
        }

        int getEnd() {
            return this.fRangeEnd;
        }

        boolean isValid() {
            return this.fRangeEnd - this.fRangeStart > 0;
        }

        void reset() {
            this.fRangeStart = Integer.MAX_VALUE;
            this.fRangeEnd = 0;
        }

        void expand(ReparseRange range) {
            int end;
            if (range == null || !range.isValid()) {
                return;
            }
            int start = range.getStart();
            if (start < this.fRangeStart) {
                this.fRangeStart = start;
            }
            if (this.fRangeEnd < (end = range.getEnd())) {
                this.fRangeEnd = end;
            }
        }
    }
}

