/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.cleanup;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.css.core.internal.formatter.CSSSourceFormatter;
import org.eclipse.wst.css.core.internal.formatter.CSSSourceFormatterFactory;
import org.eclipse.wst.css.core.internal.provisional.adapters.IStyleDeclarationAdapter;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSDocument;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.html.core.internal.Logger;
import org.eclipse.wst.html.core.internal.cleanup.AbstractNodeCleanupHandler;
import org.eclipse.wst.html.core.internal.cleanup.HTMLCleanupHandlerFactory;
import org.eclipse.wst.sse.core.internal.cleanup.IStructuredCleanupHandler;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.ISourceGenerator;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ElementNodeCleanupHandler
extends AbstractNodeCleanupHandler {
    protected static final String START_TAG_OPEN = "<";
    protected static final String END_TAG_OPEN = "</";
    protected static final String TAG_CLOSE = ">";
    protected static final String EMPTY_TAG_CLOSE = "/>";
    protected static final String SINGLE_QUOTES = "''";
    protected static final String DOUBLE_QUOTES = "\"\"";
    protected static final char SINGLE_QUOTE = '\'';
    protected static final char DOUBLE_QUOTE = '\"';

    @Override
    public Node cleanup(Node node) {
        IDOMNode renamedNode = (IDOMNode)this.cleanupChildren(node);
        if (!((IDOMElement)(renamedNode = this.quoteAttrValue(renamedNode))).isCommentTag() && renamedNode.getStartStructuredDocumentRegion() != null) {
            IDOMModel structuredModel = renamedNode.getModel();
            int startTagStartOffset = renamedNode.getStartOffset();
            IStructuredDocumentRegion startTagStructuredDocumentRegion = renamedNode.getStartStructuredDocumentRegion();
            this.insertTagClose(structuredModel, startTagStructuredDocumentRegion);
            renamedNode = (IDOMNode)structuredModel.getIndexedRegion(startTagStartOffset);
            startTagStructuredDocumentRegion = renamedNode.getStartStructuredDocumentRegion();
            IStructuredDocumentRegion endTagStructuredDocumentRegion = renamedNode.getEndStructuredDocumentRegion();
            if (endTagStructuredDocumentRegion != startTagStructuredDocumentRegion) {
                this.insertTagClose(structuredModel, endTagStructuredDocumentRegion);
            }
        }
        renamedNode = this.insertMissingTags(renamedNode);
        renamedNode = this.compressEmptyElementTag(renamedNode);
        renamedNode = this.insertRequiredAttrs(renamedNode);
        renamedNode = this.applyTagNameCase(renamedNode);
        this.applyAttrNameCase(renamedNode);
        this.cleanupCSSAttrValue(renamedNode);
        return renamedNode;
    }

    private boolean shouldPreserveCase(IDOMElement element) {
        return !element.isGlobalTag();
    }

    private boolean isXMLTag(IDOMElement element) {
        return element.isXMLTag();
    }

    protected void applyAttrNameCase(IDOMNode node) {
        IDOMElement element = (IDOMElement)node;
        if (element.isCommentTag()) {
            return;
        }
        int attrNameCase = 0;
        if (!this.shouldPreserveCase(element)) {
            attrNameCase = this.isXMLTag(element) ? 1 : this.getCleanupPreferences().getAttrNameCase();
        }
        NamedNodeMap attributes = node.getAttributes();
        int attributesLength = attributes.getLength();
        int i = 0;
        while (i < attributesLength) {
            IDOMNode eachAttr = (IDOMNode)attributes.item(i);
            if (!this.hasNestedRegion(eachAttr.getNameRegion())) {
                String oldAttrName;
                String newAttrName = oldAttrName = eachAttr.getNodeName();
                if (attrNameCase == 1) {
                    newAttrName = oldAttrName.toLowerCase(Locale.US);
                } else if (attrNameCase == 2) {
                    newAttrName = oldAttrName.toUpperCase(Locale.US);
                }
                if (newAttrName.compareTo(oldAttrName) != 0) {
                    int attrNameStartOffset = eachAttr.getStartOffset();
                    int attrNameLength = oldAttrName.length();
                    IDOMModel structuredModel = node.getModel();
                    IStructuredDocument structuredDocument = structuredModel.getStructuredDocument();
                    ElementNodeCleanupHandler.replaceSource(structuredModel, structuredDocument, attrNameStartOffset, attrNameLength, newAttrName);
                }
            }
            ++i;
        }
    }

    private boolean hasNestedRegion(ITextRegion container) {
        if (!(container instanceof ITextRegionContainer)) {
            return false;
        }
        ITextRegionList regions = ((ITextRegionContainer)container).getRegions();
        return regions != null;
    }

    protected IDOMNode applyTagNameCase(IDOMNode node) {
        ITextRegionList regions;
        IStructuredDocumentRegion endTagStructuredDocumentRegion;
        ITextRegionList regions2;
        String oldTagName;
        IDOMElement element = (IDOMElement)node;
        if (element.isCommentTag()) {
            return node;
        }
        int tagNameCase = 0;
        if (!this.shouldPreserveCase(element)) {
            tagNameCase = this.isXMLTag(element) ? 1 : this.getCleanupPreferences().getTagNameCase();
        }
        String newTagName = oldTagName = node.getNodeName();
        IDOMNode newNode = node;
        if (tagNameCase == 1) {
            newTagName = oldTagName.toLowerCase(Locale.US);
        } else if (tagNameCase == 2) {
            newTagName = oldTagName.toUpperCase(Locale.US);
        }
        IDOMModel structuredModel = node.getModel();
        IStructuredDocument structuredDocument = structuredModel.getStructuredDocument();
        IStructuredDocumentRegion startTagStructuredDocumentRegion = node.getStartStructuredDocumentRegion();
        if (startTagStructuredDocumentRegion != null && (regions2 = startTagStructuredDocumentRegion.getRegions()) != null && regions2.size() > 0) {
            ITextRegion startTagNameRegion = regions2.get(1);
            int startTagNameStartOffset = startTagStructuredDocumentRegion.getStartOffset(startTagNameRegion);
            int startTagNameLength = startTagStructuredDocumentRegion.getTextEndOffset(startTagNameRegion) - startTagNameStartOffset;
            if (!newTagName.equals(oldTagName)) {
                ElementNodeCleanupHandler.replaceSource(structuredModel, structuredDocument, startTagNameStartOffset, startTagNameLength, newTagName);
            }
            newNode = (IDOMNode)structuredModel.getIndexedRegion(startTagNameStartOffset);
        }
        if ((endTagStructuredDocumentRegion = node.getEndStructuredDocumentRegion()) != null && (regions = endTagStructuredDocumentRegion.getRegions()) != null && regions.size() > 0) {
            ITextRegion endTagNameRegion = regions.get(1);
            int endTagNameStartOffset = endTagStructuredDocumentRegion.getStartOffset(endTagNameRegion);
            int endTagNameLength = endTagStructuredDocumentRegion.getTextEndOffset(endTagNameRegion) - endTagNameStartOffset;
            if (startTagStructuredDocumentRegion != endTagStructuredDocumentRegion && !newTagName.equals(oldTagName)) {
                ElementNodeCleanupHandler.replaceSource(structuredModel, structuredDocument, endTagNameStartOffset, endTagNameLength, newTagName);
            }
        }
        return newNode;
    }

    protected Node cleanupChildren(Node node) {
        Node parentNode = node;
        if (node != null) {
            Node childNode = node.getFirstChild();
            HTMLCleanupHandlerFactory factory = HTMLCleanupHandlerFactory.getInstance();
            while (childNode != null) {
                IStructuredCleanupHandler cleanupHandler = factory.createHandler(childNode, this.getCleanupPreferences());
                childNode = cleanupHandler.cleanup(childNode);
                parentNode = childNode.getParentNode();
                childNode = childNode.getNextSibling();
            }
        }
        return parentNode;
    }

    protected void cleanupCSSAttrValue(IDOMNode node) {
        if (node == null || node.getNodeType() != 1) {
            return;
        }
        IDOMElement element = (IDOMElement)node;
        if (!element.isGlobalTag()) {
            return;
        }
        Attr attr = element.getAttributeNode("style");
        if (attr == null) {
            return;
        }
        String value = this.getCSSValue(attr);
        if (value == null) {
            return;
        }
        String oldValue = ((IDOMNode)((Object)attr)).getValueSource();
        if (oldValue != null && value.equals(oldValue)) {
            return;
        }
        attr.setValue(value);
    }

    private ICSSModel getCSSModel(Attr attr) {
        if (attr == null) {
            return null;
        }
        INodeNotifier notifier = (INodeNotifier)((Object)attr.getOwnerElement());
        if (notifier == null) {
            return null;
        }
        INodeAdapter adapter = notifier.getAdapterFor(IStyleDeclarationAdapter.class);
        if (adapter == null) {
            return null;
        }
        if (!(adapter instanceof IStyleDeclarationAdapter)) {
            return null;
        }
        IStyleDeclarationAdapter styleAdapter = (IStyleDeclarationAdapter)adapter;
        return styleAdapter.getModel();
    }

    private String getCSSValue(Attr attr) {
        ICSSModel model = this.getCSSModel(attr);
        if (model == null) {
            return null;
        }
        ICSSDocument document = model.getDocument();
        if (document == null) {
            return null;
        }
        INodeNotifier notifier = (INodeNotifier)((Object)document);
        CSSSourceFormatter formatter = (CSSSourceFormatter)((Object)notifier.getAdapterFor(CSSSourceFormatter.class));
        if (formatter == null) {
            formatter = CSSSourceFormatterFactory.getInstance().getSourceFormatter(notifier);
        }
        if (formatter == null) {
            return null;
        }
        StringBuffer buffer = formatter.cleanup(document);
        if (buffer == null) {
            return null;
        }
        return buffer.toString();
    }

    private boolean isEmptyElement(IDOMElement element) {
        Document document = element.getOwnerDocument();
        if (document == null) {
            return false;
        }
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery(document);
        if (modelQuery == null) {
            return false;
        }
        CMElementDeclaration decl = modelQuery.getCMElementDeclaration(element);
        if (decl == null) {
            return false;
        }
        return decl.getContentType() == 1;
    }

    protected IDOMNode insertEndTag(IDOMNode node) {
        IDOMElement element = (IDOMElement)node;
        int startTagStartOffset = node.getStartOffset();
        IDOMModel structuredModel = node.getModel();
        IDOMNode newNode = null;
        if (!element.isCommentTag()) {
            if (this.isEmptyElement(element)) {
                ITextRegion regionBeforeTagClose;
                IStructuredDocument structuredDocument = structuredModel.getStructuredDocument();
                IStructuredDocumentRegion startStructuredDocumentRegion = node.getStartStructuredDocumentRegion();
                ITextRegionList regions = startStructuredDocumentRegion.getRegions();
                ITextRegion lastRegion = regions.get(regions.size() - 1);
                ElementNodeCleanupHandler.replaceSource(structuredModel, structuredDocument, startStructuredDocumentRegion.getStartOffset(lastRegion), lastRegion.getLength(), EMPTY_TAG_CLOSE);
                if (regions.size() > 1 && (regionBeforeTagClose = regions.get(regions.size() - 1 - 1)).getTextLength() == regionBeforeTagClose.getLength()) {
                    ElementNodeCleanupHandler.replaceSource(structuredModel, structuredDocument, startStructuredDocumentRegion.getStartOffset(lastRegion), 0, " ");
                }
            } else {
                String tagName = node.getNodeName();
                String endTag = END_TAG_OPEN.concat(tagName).concat(TAG_CLOSE);
                IDOMNode lastChild = (IDOMNode)node.getLastChild();
                int endTagStartOffset = 0;
                endTagStartOffset = lastChild != null ? lastChild.getEndOffset() : node.getEndOffset();
                IStructuredDocument structuredDocument = structuredModel.getStructuredDocument();
                ElementNodeCleanupHandler.replaceSource(structuredModel, structuredDocument, endTagStartOffset, 0, endTag);
            }
        }
        newNode = (IDOMNode)structuredModel.getIndexedRegion(startTagStartOffset);
        return newNode;
    }

    protected IDOMNode insertMissingTags(IDOMNode node) {
        boolean insertMissingTags = this.getCleanupPreferences().getInsertMissingTags();
        IDOMNode newNode = node;
        if (insertMissingTags) {
            IStructuredDocumentRegion startTagStructuredDocumentRegion = node.getStartStructuredDocumentRegion();
            if (startTagStructuredDocumentRegion == null) {
                newNode = this.insertStartTag(node);
                startTagStructuredDocumentRegion = newNode.getStartStructuredDocumentRegion();
            }
            IStructuredDocumentRegion endTagStructuredDocumentRegion = newNode.getEndStructuredDocumentRegion();
            ITextRegionList regionList = startTagStructuredDocumentRegion.getRegions();
            if (startTagStructuredDocumentRegion == null || regionList == null || regionList.get(regionList.size() - 1).getType() != "XML_EMPTY_TAG_CLOSE") {
                if (startTagStructuredDocumentRegion == null) {
                    if (this.isStartTagRequired(newNode)) {
                        newNode = this.insertStartTag(newNode);
                    }
                } else if (endTagStructuredDocumentRegion == null && this.isEndTagRequired(newNode)) {
                    newNode = this.insertEndTag(newNode);
                }
            }
        }
        return newNode;
    }

    protected IDOMNode insertStartTag(IDOMNode node) {
        IDOMElement element = (IDOMElement)node;
        if (element.isCommentTag()) {
            return node;
        }
        IDOMNode newNode = null;
        String tagName = node.getNodeName();
        String startTag = START_TAG_OPEN.concat(tagName).concat(TAG_CLOSE);
        int startTagStartOffset = node.getStartOffset();
        IDOMModel structuredModel = node.getModel();
        IStructuredDocument structuredDocument = structuredModel.getStructuredDocument();
        ElementNodeCleanupHandler.replaceSource(structuredModel, structuredDocument, startTagStartOffset, 0, startTag);
        newNode = (IDOMNode)structuredModel.getIndexedRegion(startTagStartOffset);
        return newNode;
    }

    protected void insertTagClose(IDOMModel structuredModel, IStructuredDocumentRegion flatNode) {
        String regionType;
        ITextRegionList regionList;
        ITextRegion lastRegion;
        if (flatNode != null && flatNode.getRegions() != null && (lastRegion = (regionList = flatNode.getRegions()).get(regionList.size() - 1)) != null && (regionType = lastRegion.getType()) != "XML_EMPTY_TAG_CLOSE" && regionType != "XML_TAG_CLOSE") {
            IStructuredDocument structuredDocument = structuredModel.getStructuredDocument();
            ElementNodeCleanupHandler.replaceSource(structuredModel, structuredDocument, flatNode.getTextEndOffset(lastRegion), 0, TAG_CLOSE);
        }
    }

    protected boolean isEndTagRequired(IDOMNode node) {
        if (node == null) {
            return false;
        }
        return node.isContainer();
    }

    protected boolean isStartTagRequired(IDOMNode node) {
        if (node == null) {
            return false;
        }
        return node.isContainer();
    }

    protected boolean isXMLType(IDOMModel structuredModel) {
        IDOMDocument document;
        boolean result = false;
        if (structuredModel != null && (document = structuredModel.getDocument()) != null) {
            result = document.isXMLType();
        }
        return result;
    }

    protected IDOMNode quoteAttrValue(IDOMNode node) {
        IDOMElement element = (IDOMElement)node;
        if (element.isCommentTag()) {
            return node;
        }
        boolean quoteAttrValues = this.getCleanupPreferences().getQuoteAttrValues();
        IDOMNode newNode = node;
        if (quoteAttrValues) {
            NamedNodeMap attributes = newNode.getAttributes();
            int attributesLength = attributes.getLength();
            ISourceGenerator generator = node.getModel().getGenerator();
            int i = 0;
            while (i < attributesLength) {
                String newAttrValue;
                attributes = newNode.getAttributes();
                attributesLength = attributes.getLength();
                IDOMAttr eachAttr = (IDOMAttr)attributes.item(i);
                String oldAttrValue = eachAttr.getValueRegionText();
                if (oldAttrValue == null) {
                    IDOMModel structuredModel = node.getModel();
                    if (this.isXMLType(structuredModel)) {
                        newAttrValue = "=\"" + eachAttr.getNameRegionText() + "\"";
                        IStructuredDocument structuredDocument = structuredModel.getStructuredDocument();
                        ElementNodeCleanupHandler.replaceSource(structuredModel, structuredDocument, eachAttr.getNameRegionEndOffset(), 0, newAttrValue);
                        newNode = (IDOMNode)structuredModel.getIndexedRegion(node.getStartOffset());
                    }
                } else {
                    char quote = StringUtils.isQuoted(oldAttrValue) ? (char)oldAttrValue.charAt(0) : (char)'\"';
                    newAttrValue = generator.generateAttrValue(eachAttr, quote);
                    if (oldAttrValue.length() == 1) {
                        char firstChar = oldAttrValue.charAt(0);
                        if (firstChar == '\'') {
                            newAttrValue = SINGLE_QUOTES;
                        } else if (firstChar == '\"') {
                            newAttrValue = DOUBLE_QUOTES;
                        }
                    }
                    if (newAttrValue != null && newAttrValue.compareTo(oldAttrValue) != 0) {
                        int attrValueStartOffset = eachAttr.getValueRegionStartOffset();
                        int attrValueLength = oldAttrValue.length();
                        int startTagStartOffset = node.getStartOffset();
                        IDOMModel structuredModel = node.getModel();
                        IStructuredDocument structuredDocument = structuredModel.getStructuredDocument();
                        ElementNodeCleanupHandler.replaceSource(structuredModel, structuredDocument, attrValueStartOffset, attrValueLength, newAttrValue);
                        newNode = (IDOMNode)structuredModel.getIndexedRegion(startTagStartOffset);
                    }
                }
                ++i;
            }
        }
        return newNode;
    }

    private IDOMNode insertRequiredAttrs(IDOMNode node) {
        List requiredAttrs;
        boolean insertRequiredAttrs = this.getCleanupPreferences().getInsertRequiredAttrs();
        IDOMNode newNode = node;
        if (insertRequiredAttrs && (requiredAttrs = this.getRequiredAttrs(newNode)).size() > 0) {
            NamedNodeMap currentAttrs = node.getAttributes();
            ArrayList insertAttrs = new ArrayList();
            if (currentAttrs.getLength() == 0) {
                insertAttrs.addAll(requiredAttrs);
            } else {
                int i = 0;
                while (i < requiredAttrs.size()) {
                    String requiredAttrName = ((CMAttributeDeclaration)requiredAttrs.get(i)).getAttrName();
                    boolean found = false;
                    int j = 0;
                    while (j < currentAttrs.getLength()) {
                        String currentAttrName = currentAttrs.item(j).getNodeName();
                        if (requiredAttrName.compareToIgnoreCase(currentAttrName) == 0) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (!found) {
                        insertAttrs.add(requiredAttrs.get(i));
                    }
                    ++i;
                }
            }
            if (insertAttrs.size() > 0) {
                IStructuredDocumentRegion startStructuredDocumentRegion = newNode.getStartStructuredDocumentRegion();
                int index = startStructuredDocumentRegion.getEndOffset();
                ITextRegion lastRegion = startStructuredDocumentRegion.getLastRegion();
                if (lastRegion.getType() == "XML_TAG_CLOSE") {
                    lastRegion = startStructuredDocumentRegion.getRegionAtCharacterOffset(--index - 1);
                } else if (lastRegion.getType() == "XML_EMPTY_TAG_CLOSE") {
                    lastRegion = startStructuredDocumentRegion.getRegionAtCharacterOffset((index -= 2) - 1);
                }
                MultiTextEdit multiTextEdit = new MultiTextEdit();
                try {
                    int i = insertAttrs.size() - 1;
                    while (i >= 0) {
                        CMAttributeDeclaration attrDecl = (CMAttributeDeclaration)insertAttrs.get(i);
                        String requiredAttributeName = attrDecl.getAttrName();
                        String defaultValue = attrDecl.getDefaultValue();
                        if (defaultValue == null) {
                            defaultValue = "";
                        }
                        String nameAndDefaultValue = " ";
                        if (i == 0 && lastRegion.getLength() > lastRegion.getTextLength()) {
                            nameAndDefaultValue = "";
                        }
                        nameAndDefaultValue = String.valueOf(nameAndDefaultValue) + requiredAttributeName + "=\"" + defaultValue + "\"";
                        multiTextEdit.addChild((TextEdit)new InsertEdit(index, nameAndDefaultValue));
                        --i;
                    }
                    multiTextEdit.apply((IDocument)newNode.getStructuredDocument());
                }
                catch (BadLocationException e) {
                    Logger.log(1, e.getMessage());
                }
            }
        }
        return newNode;
    }

    protected ModelQuery getModelQuery(Node node) {
        ModelQuery result = null;
        result = node.getNodeType() == 9 ? ModelQueryUtil.getModelQuery((Document)node) : ModelQueryUtil.getModelQuery(node.getOwnerDocument());
        return result;
    }

    protected List getRequiredAttrs(Node node) {
        CMElementDeclaration elementDecl;
        ArrayList<CMAttributeDeclaration> result = new ArrayList<CMAttributeDeclaration>();
        ModelQuery modelQuery = this.getModelQuery(node);
        if (modelQuery != null && (elementDecl = modelQuery.getCMElementDeclaration((Element)node)) != null) {
            CMNamedNodeMap attrMap = elementDecl.getAttributes();
            Iterator it = attrMap.iterator();
            CMAttributeDeclaration attr = null;
            while (it.hasNext()) {
                attr = (CMAttributeDeclaration)it.next();
                if (attr.getUsage() != 2) continue;
                result.add(attr);
            }
        }
        return result;
    }

    private IDOMNode compressEmptyElementTag(IDOMNode node) {
        NodeList childNodes;
        ITextRegionList regions;
        ITextRegion lastRegion;
        boolean compressEmptyElementTags = this.getCleanupPreferences().getCompressEmptyElementTags();
        IDOMNode newNode = node;
        IStructuredDocumentRegion startTagStructuredDocumentRegion = newNode.getFirstStructuredDocumentRegion();
        IStructuredDocumentRegion endTagStructuredDocumentRegion = newNode.getLastStructuredDocumentRegion();
        if (compressEmptyElementTags && startTagStructuredDocumentRegion != endTagStructuredDocumentRegion && startTagStructuredDocumentRegion != null && (this.isXMLTag((IDOMElement)newNode) || !newNode.isContainer()) && (lastRegion = (regions = startTagStructuredDocumentRegion.getRegions()).get(regions.size() - 1)).getType() != "XML_EMPTY_TAG_CLOSE" && ((childNodes = newNode.getChildNodes()) == null || childNodes.getLength() == 0 || childNodes.getLength() == 1 && childNodes.item(0).getNodeType() == 3 && childNodes.item(0).getNodeValue().trim().length() == 0)) {
            IDOMModel structuredModel = newNode.getModel();
            IStructuredDocument structuredDocument = structuredModel.getStructuredDocument();
            int startTagStartOffset = newNode.getStartOffset();
            int offset = endTagStructuredDocumentRegion.getStart();
            int length = endTagStructuredDocumentRegion.getLength();
            structuredDocument.replaceText(structuredDocument, offset, length, "");
            newNode = (IDOMNode)structuredModel.getIndexedRegion(startTagStartOffset);
            offset = startTagStructuredDocumentRegion.getStart() + lastRegion.getStart();
            structuredDocument.replaceText(structuredDocument, offset, 0, "/");
            newNode = (IDOMNode)structuredModel.getIndexedRegion(startTagStartOffset);
        }
        return newNode;
    }
}

