/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.validate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;
import org.eclipse.wst.html.core.internal.Logger;
import org.eclipse.wst.html.core.internal.validate.CMUtil;
import org.eclipse.wst.html.core.internal.validate.CustomHTMLAttributeValidatorExtensionLoader;
import org.eclipse.wst.html.core.internal.validate.ErrorInfoImpl;
import org.eclipse.wst.html.core.internal.validate.ModuleCoreSupport;
import org.eclipse.wst.html.core.internal.validate.PrimeValidator;
import org.eclipse.wst.html.core.internal.validate.Segment;
import org.eclipse.wst.html.core.internal.validate.StringMatcher;
import org.eclipse.wst.html.core.validate.extension.IHTMLCustomAttributeValidator;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.validate.ValidationMessage;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeAdapter;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class HTMLAttributeValidator
extends PrimeValidator {
    private static final String JAVASCRIPT_PREFIX = "javascript:";
    public static final int REGION_NAME = 1;
    public static final int REGION_VALUE = 2;
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    private IPreferencesService fPreferenceService = Platform.getPreferencesService();
    private static Map fIgnorePatterns = new HashMap();
    private static final String ATTR_NAME_DATA = "data-";
    private static final int ATTR_NAME_DATA_LENGTH = "data-".length();
    private static final String ATTR_NAME_USER_AGENT_FEATURE = "x-";
    private static final int ATTR_NAME_USER_AGENT_FEATURE_LENGTH = "x-".length();
    private static final String ATTR_NAME_WAI_ARIA = "aria-";
    private static final int ATTR_NAME_WAI_ARIA_LENGTH = "aria-".length();
    private List<IHTMLCustomAttributeValidator> externalValidators;

    public static Segment getErrorSegment(IDOMNode errorNode, int regionType) {
        IStructuredDocumentRegion firstRegion;
        IDOMElement ownerElement;
        ITextRegion rgn = null;
        switch (regionType) {
            case 1: {
                rgn = errorNode.getNameRegion();
                break;
            }
            case 2: {
                rgn = errorNode.getValueRegion();
                break;
            }
        }
        if (rgn != null && errorNode instanceof IDOMAttr && (ownerElement = (IDOMElement)((IDOMAttr)errorNode).getOwnerElement()) != null && (firstRegion = ownerElement.getFirstStructuredDocumentRegion()) != null) {
            int regionStartOffset = firstRegion.getStartOffset(rgn);
            int regionLength = rgn.getTextLength();
            return new Segment(regionStartOffset, regionLength);
        }
        return new Segment(errorNode.getStartOffset(), 1);
    }

    @Override
    public boolean isAdapterForType(Object type) {
        return type == HTMLAttributeValidator.class || super.isAdapterForType(type);
    }

    @Override
    public void validate(IndexedRegion node) {
        block34: {
            CMElementDeclaration edec;
            Element target;
            block33: {
                target = (Element)((Object)node);
                if (CMUtil.isForeign(target)) {
                    return;
                }
                edec = CMUtil.getDeclaration(target);
                if (edec != null) break block33;
                NamedNodeMap attrs = target.getAttributes();
                int i = 0;
                while (i < attrs.getLength()) {
                    Attr a = (Attr)attrs.item(i);
                    String attrName = a.getName().toLowerCase(Locale.US);
                    if (this.shouldValidateAttributeName(target, attrName)) {
                        this.validateWithExtension(target, a, attrName);
                    }
                    ++i;
                }
                break block34;
            }
            CMNamedNodeMap declarations = edec.getAttributes();
            List modelQueryNodes = null;
            NamedNodeMap attrs = target.getAttributes();
            int i = 0;
            while (i < attrs.getLength()) {
                block35: {
                    Segment seg;
                    Attr a;
                    int state;
                    int rgnType;
                    block37: {
                        String source;
                        CMAttributeDeclaration adec;
                        boolean isXMLAttr;
                        block39: {
                            String desired;
                            block38: {
                                block36: {
                                    IDOMAttr xmlattr;
                                    rgnType = 1;
                                    state = 0;
                                    a = (Attr)attrs.item(i);
                                    isXMLAttr = a instanceof IDOMAttr;
                                    if (isXMLAttr && (!(xmlattr = (IDOMAttr)a).isGlobalAttr() || xmlattr.getNameRegion() instanceof ITextRegionContainer)) break block35;
                                    adec = (CMAttributeDeclaration)declarations.getNamedItem(a.getName());
                                    String attrName = a.getName().toLowerCase(Locale.US);
                                    if (adec == null) {
                                        if (modelQueryNodes == null) {
                                            modelQueryNodes = ModelQueryUtil.getModelQuery(target.getOwnerDocument()).getAvailableContent((Element)((Object)node), edec, 1);
                                        }
                                        int k = 0;
                                        while (k < modelQueryNodes.size()) {
                                            CMNode cmnode = (CMNode)modelQueryNodes.get(k);
                                            if (cmnode.getNodeType() == 2 && cmnode.getNodeName().toLowerCase(Locale.US).equals(attrName)) {
                                                adec = (CMAttributeDeclaration)cmnode;
                                                break;
                                            }
                                            ++k;
                                        }
                                    }
                                    if (adec != null) break block36;
                                    if ((attrName.startsWith(ATTR_NAME_DATA) && attrName.length() > ATTR_NAME_DATA_LENGTH || attrName.startsWith(ATTR_NAME_USER_AGENT_FEATURE) && attrName.length() > ATTR_NAME_USER_AGENT_FEATURE_LENGTH || attrName.startsWith(ATTR_NAME_WAI_ARIA) && attrName.length() > ATTR_NAME_WAI_ARIA_LENGTH) && this.isHTML5(target) || !this.shouldValidateAttributeName(target, attrName)) break block35;
                                    this.validateWithExtension(target, a, attrName);
                                    break block37;
                                }
                                if (CMUtil.isObsolete(adec)) {
                                    state = 14;
                                }
                                if (!CMUtil.isHTML(edec) || CMUtil.isXHTML(edec)) break block38;
                                if (!CMUtil.isBooleanAttr(adec) || !((IDOMAttr)a).hasNameOnly()) break block39;
                                break block35;
                            }
                            String actual = a.getName();
                            if (!actual.equals(desired = adec.getAttrName())) {
                                rgnType = 1;
                                state = 103;
                            }
                        }
                        if (state == 0) {
                            ITextRegion region;
                            CMDataType attrType = adec.getAttrType();
                            if (a instanceof IDOMAttr && (region = ((IDOMAttr)a).getEqualRegion()) == null) {
                                rgnType = 1;
                                state = 16;
                            }
                            String actualValue = a.getValue();
                            if (attrType.getImpliedValueKind() == 2) {
                                String validValue = attrType.getImpliedValue();
                                if (!actualValue.equals(validValue)) {
                                    rgnType = 2;
                                    state = 12;
                                }
                            } else if ("URI".equals(attrType.getDataTypeName())) {
                                Path basePath;
                                Collection dependencies;
                                IStructuredDocumentRegion start;
                                if (actualValue.indexOf(35) < 0 && actualValue.indexOf(":/") < 0 && !actualValue.toLowerCase(Locale.ENGLISH).startsWith(JAVASCRIPT_PREFIX) && CMUtil.isHTML(edec) && (start = ((IDOMNode)node).getStartStructuredDocumentRegion()) != null && start.getFirstRegion().getTextLength() == 1 && (dependencies = (Collection)((IDOMNode)((Object)((IDOMNode)node).getOwnerDocument())).getUserData("org.eclipse.wst.html.validator.dependencies")) != null && (basePath = new Path(((IDOMNode)node).getModel().getBaseLocation())).segmentCount() > 1) {
                                    IPath path = ModuleCoreSupport.resolve((IPath)basePath, actualValue);
                                    IResource found = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                                    if (found != null) {
                                        dependencies.add(found);
                                    }
                                }
                            } else if ("ENUM".equals(attrType.getDataTypeName())) {
                                String[] enumeratedValues = attrType.getEnumeratedValues();
                                boolean found = false;
                                int j = 0;
                                while (j < enumeratedValues.length) {
                                    if (actualValue.equalsIgnoreCase(enumeratedValues[j])) {
                                        found = true;
                                        if (!CMUtil.isCaseSensitive(edec) || actualValue.equals(enumeratedValues[j])) break;
                                        rgnType = 2;
                                        state = 13;
                                        break;
                                    }
                                    ++j;
                                }
                                if (!found) {
                                    String[] modelQueryExtensionValues = ModelQueryUtil.getModelQuery(target.getOwnerDocument()).getPossibleDataTypeValues((Element)((Object)node), adec);
                                    int j2 = 0;
                                    while (j2 < modelQueryExtensionValues.length) {
                                        if (actualValue.equalsIgnoreCase(modelQueryExtensionValues[j2])) {
                                            found = true;
                                            if (!CMUtil.isCaseSensitive(edec) || actualValue.equals(modelQueryExtensionValues[j2])) break;
                                            rgnType = 2;
                                            state = 13;
                                            break;
                                        }
                                        ++j2;
                                    }
                                    if (!this.hasNestedRegion(((IDOMNode)((Object)a)).getValueRegion())) {
                                        rgnType = 2;
                                        state = 12;
                                    }
                                }
                            }
                        }
                        if (state == 0 && isXMLAttr && (source = ((IDOMAttr)a).getValueRegionText()) != null) {
                            char firstChar = source.charAt(0);
                            char lastChar = source.charAt(source.length() - 1);
                            boolean unclosedAttr = false;
                            if (this.isQuote(firstChar) || this.isQuote(lastChar)) {
                                if (lastChar != firstChar) {
                                    unclosedAttr = true;
                                }
                            } else if (CMUtil.isXHTML(edec)) {
                                unclosedAttr = true;
                            }
                            if (unclosedAttr) {
                                rgnType = 2;
                                state = 113;
                            }
                        }
                    }
                    if (state != 0 && (seg = HTMLAttributeValidator.getErrorSegment((IDOMNode)((Object)a), rgnType)) != null) {
                        this.reporter.report(new ErrorInfoImpl(state, seg, a));
                    }
                }
                ++i;
            }
        }
    }

    private void initValidators(IStructuredDocument doc) {
        this.externalValidators = new ArrayList<IHTMLCustomAttributeValidator>();
        for (IConfigurationElement e : CustomHTMLAttributeValidatorExtensionLoader.getInstance().getValidators()) {
            try {
                IHTMLCustomAttributeValidator validator = (IHTMLCustomAttributeValidator)e.createExecutableExtension("class");
                validator.init(doc);
                this.externalValidators.add(validator);
            }
            catch (CoreException e1) {
                Logger.logException(e1);
            }
        }
    }

    private void validateWithExtension(Element target, Attr a, String attrName) {
        Segment seg;
        boolean validated = false;
        if (this.externalValidators == null) {
            this.initValidators(((IDOMElement)target).getStructuredDocument());
        }
        for (IHTMLCustomAttributeValidator v : this.externalValidators) {
            try {
                if (!v.canValidate((IDOMElement)target, attrName)) continue;
                validated = true;
                ValidationMessage result = v.validateAttribute((IDOMElement)target, attrName);
                if (result == null) continue;
                this.reporter.report(result);
                break;
            }
            catch (Throwable t) {
                Logger.logException(t);
            }
        }
        if (!validated && !this.hasNestedRegion(((IDOMNode)((Object)a)).getNameRegion()) && (seg = HTMLAttributeValidator.getErrorSegment((IDOMNode)((Object)a), 1)) != null) {
            this.reporter.report(new ErrorInfoImpl(11, seg, a));
        }
    }

    private boolean hasNestedRegion(ITextRegion container) {
        if (!(container instanceof ITextRegionContainer)) {
            return false;
        }
        ITextRegionList regions = ((ITextRegionContainer)container).getRegions();
        return regions != null;
    }

    private boolean isQuote(char c) {
        return c == '\'' || c == '\"';
    }

    private boolean isHTML5(Element target) {
        DocumentTypeAdapter documentTypeAdapter = (DocumentTypeAdapter)((INodeNotifier)((Object)target.getOwnerDocument())).getAdapterFor(DocumentTypeAdapter.class);
        return documentTypeAdapter != null && documentTypeAdapter.hasFeature("HTML5");
    }

    private boolean shouldValidateAttributeName(Element target, String attrName) {
        Object adapter = target instanceof IAdaptable ? ((IAdaptable)target).getAdapter(IResource.class) : null;
        IProject project = adapter instanceof IResource ? ((IResource)adapter).getProject() : null;
        for (String excluded : this.getExcludedAttributeNames(project)) {
            StringMatcher strMatcher = (StringMatcher)fIgnorePatterns.get(excluded);
            if (strMatcher == null) {
                strMatcher = new StringMatcher(excluded);
                fIgnorePatterns.put(excluded, strMatcher);
            }
            if (!strMatcher.match(attrName.toLowerCase())) continue;
            return false;
        }
        return true;
    }

    private Set getExcludedAttributeNames(IProject project) {
        ProjectScope projectScope;
        IScopeContext[] fLookupOrder = new IScopeContext[]{new InstanceScope(), new DefaultScope()};
        if (project != null && (projectScope = new ProjectScope(project)).getNode(HTMLCorePlugin.getDefault().getBundle().getSymbolicName()).getBoolean("use-project-settings", false)) {
            fLookupOrder = new IScopeContext[]{projectScope, new InstanceScope(), new DefaultScope()};
        }
        HashSet<String> result = new HashSet<String>();
        if (this.fPreferenceService.getBoolean(HTMLCorePlugin.getDefault().getBundle().getSymbolicName(), "ignoreAttrNames", false, fLookupOrder)) {
            String ignoreList = this.fPreferenceService.getString(HTMLCorePlugin.getDefault().getBundle().getSymbolicName(), "attrNamesToIgnore", "", fLookupOrder);
            if (ignoreList.trim().length() == 0) {
                return result;
            }
            String[] names = ignoreList.split(",");
            int i = 0;
            while (names != null && i < names.length) {
                String name;
                String string = name = names[i] == null ? null : names[i].trim();
                if (name != null && name.length() > 0) {
                    result.add(name.toLowerCase());
                }
                ++i;
            }
        }
        return result;
    }
}

