/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JDTChange;

public abstract class AbstractJavaElementRenameChange
extends JDTChange {
    private final String fNewName;
    private final String fOldName;
    private final IPath fResourcePath;
    private final long fStampToRestore;

    protected AbstractJavaElementRenameChange(IPath resourcePath, String oldName, String newName) {
        this(resourcePath, oldName, newName, -1L);
    }

    protected AbstractJavaElementRenameChange(IPath resourcePath, String oldName, String newName, long stampToRestore) {
        Assert.isNotNull((Object)newName, (String)"new name");
        Assert.isNotNull((Object)oldName, (String)"old name");
        this.fResourcePath = resourcePath;
        this.fOldName = oldName;
        this.fNewName = newName;
        this.fStampToRestore = stampToRestore;
    }

    protected abstract IPath createNewPath();

    protected abstract Change createUndoChange(long var1) throws CoreException;

    protected abstract void doRename(IProgressMonitor var1) throws CoreException;

    public Object getModifiedElement() {
        return JavaScriptCore.create(this.getResource());
    }

    public String getNewName() {
        return this.fNewName;
    }

    public String getOldName() {
        return this.fOldName;
    }

    protected final IResource getResource() {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(this.fResourcePath);
    }

    protected IPath getResourcePath() {
        return this.fResourcePath;
    }

    public final Change perform(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(RefactoringCoreMessages.AbstractRenameChange_Renaming, 1);
            IResource resource = this.getResource();
            IPath newPath = this.createNewPath();
            Change result = this.createUndoChange(resource.getModificationStamp());
            this.doRename((IProgressMonitor)new SubProgressMonitor(pm, 1));
            if (this.fStampToRestore != -1L) {
                IResource newResource = ResourcesPlugin.getWorkspace().getRoot().findMember(newPath);
                newResource.revertModificationStamp(this.fStampToRestore);
            }
            Change change = result;
            return change;
        }
        finally {
            pm.done();
        }
    }
}

