/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayCreation;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.HierarchicalASTVisitor;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedProposalPositionGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.NameCollector;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.TempAssignmentFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.TempDeclarationFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.TempOccurrenceAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.wst.jsdt.ui.CodeGeneration;

public class PromoteTempToFieldRefactoring
extends ScriptableRefactoring {
    private static final String ATTRIBUTE_STATIC = "static";
    private static final String ATTRIBUTE_FINAL = "final";
    private static final String ATTRIBUTE_VISIBILITY = "visibility";
    private static final String ATTRIBUTE_INITIALIZE = "initialize";
    private int fSelectionStart;
    private int fSelectionLength;
    private IJavaScriptUnit fCu;
    public static final int INITIALIZE_IN_FIELD = 0;
    public static final int INITIALIZE_IN_METHOD = 1;
    public static final int INITIALIZE_IN_CONSTRUCTOR = 2;
    private static final String LINKED_NAME = "name";
    private String fFieldName;
    private int fVisibility;
    private boolean fDeclareStatic;
    private boolean fDeclareFinal;
    private int fInitializeIn;
    private JavaScriptUnit fCompilationUnitNode;
    private VariableDeclaration fTempDeclarationNode;
    private boolean fInitializerUsesLocalTypes;
    private boolean fTempTypeUsesClassTypeVariables;
    private boolean fSelfInitializing = false;
    private LinkedProposalModel fLinkedProposalModel;

    public PromoteTempToFieldRefactoring(IJavaScriptUnit unit, int selectionStart, int selectionLength) {
        Assert.isTrue((selectionStart >= 0 ? 1 : 0) != 0);
        Assert.isTrue((selectionLength >= 0 ? 1 : 0) != 0);
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCu = unit;
        this.fFieldName = "";
        this.fVisibility = 2;
        this.fDeclareStatic = false;
        this.fDeclareFinal = false;
        this.fInitializeIn = 1;
        this.fLinkedProposalModel = null;
    }

    public PromoteTempToFieldRefactoring(VariableDeclaration declaration) {
        Assert.isTrue((declaration != null ? 1 : 0) != 0);
        this.fTempDeclarationNode = declaration;
        IVariableBinding resolveBinding = declaration.resolveBinding();
        Assert.isTrue((resolveBinding != null && !resolveBinding.isParameter() && !resolveBinding.isField() ? 1 : 0) != 0);
        ASTNode root = declaration.getRoot();
        Assert.isTrue((boolean)(root instanceof JavaScriptUnit));
        this.fCompilationUnitNode = (JavaScriptUnit)root;
        IJavaScriptElement input = this.fCompilationUnitNode.getJavaElement();
        Assert.isTrue((boolean)(input instanceof IJavaScriptUnit));
        this.fCu = (IJavaScriptUnit)input;
        this.fSelectionStart = declaration.getStartPosition();
        this.fSelectionLength = declaration.getLength();
        this.fFieldName = "";
        this.fVisibility = 2;
        this.fDeclareStatic = false;
        this.fDeclareFinal = false;
        this.fInitializeIn = 1;
        this.fLinkedProposalModel = null;
    }

    public String getName() {
        return RefactoringCoreMessages.PromoteTempToFieldRefactoring_name;
    }

    public int[] getAvailableVisibilities() {
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[1] = 4;
        nArray[3] = 2;
        return nArray;
    }

    public int getVisibility() {
        return this.fVisibility;
    }

    public boolean getDeclareFinal() {
        return this.fDeclareFinal;
    }

    public boolean getDeclareStatic() {
        return this.fDeclareStatic;
    }

    public int getInitializeIn() {
        return this.fInitializeIn;
    }

    public void setVisibility(int accessModifier) {
        Assert.isTrue((accessModifier == 2 || accessModifier == 0 || accessModifier == 4 || accessModifier == 1 ? 1 : 0) != 0);
        this.fVisibility = accessModifier;
    }

    public void setDeclareFinal(boolean declareFinal) {
        this.fDeclareFinal = declareFinal;
    }

    public void setDeclareStatic(boolean declareStatic) {
        this.fDeclareStatic = declareStatic;
    }

    public void setFieldName(String fieldName) {
        Assert.isNotNull((Object)fieldName);
        this.fFieldName = fieldName;
    }

    public void setInitializeIn(int initializeIn) {
        Assert.isTrue((initializeIn == 2 || initializeIn == 0 || initializeIn == 1 ? 1 : 0) != 0);
        this.fInitializeIn = initializeIn;
    }

    public boolean canEnableSettingStatic() {
        return this.fInitializeIn != 2 && !this.isTempDeclaredInStaticMethod() && !this.fTempTypeUsesClassTypeVariables;
    }

    public boolean canEnableSettingFinal() {
        if (this.fInitializeIn == 2) {
            return this.canEnableSettingDeclareInConstructors() && !this.tempHasAssignmentsOtherThanInitialization();
        }
        if (this.fInitializeIn == 0) {
            return this.canEnableSettingDeclareInFieldDeclaration() && !this.tempHasAssignmentsOtherThanInitialization();
        }
        if (this.getMethodDeclaration().isConstructor()) {
            return !this.tempHasAssignmentsOtherThanInitialization();
        }
        return false;
    }

    private boolean tempHasAssignmentsOtherThanInitialization() {
        TempAssignmentFinder assignmentFinder = new TempAssignmentFinder(this.fTempDeclarationNode);
        this.fCompilationUnitNode.accept(assignmentFinder);
        return assignmentFinder.hasAssignments();
    }

    public boolean canEnableSettingDeclareInConstructors() {
        return !this.fDeclareStatic && !this.fInitializerUsesLocalTypes && !this.getMethodDeclaration().isConstructor() && !this.isDeclaredInAnonymousClass() && !this.isTempDeclaredInStaticMethod() && this.tempHasInitializer();
    }

    public boolean canEnableSettingDeclareInMethod() {
        return !this.fDeclareFinal && this.tempHasInitializer();
    }

    private boolean tempHasInitializer() {
        return this.getTempInitializer() != null;
    }

    public boolean canEnableSettingDeclareInFieldDeclaration() {
        return !this.fInitializerUsesLocalTypes && this.tempHasInitializer();
    }

    private Expression getTempInitializer() {
        return this.fTempDeclarationNode.getInitializer();
    }

    private boolean isTempDeclaredInStaticMethod() {
        return Modifier.isStatic(this.getMethodDeclaration().getModifiers());
    }

    private FunctionDeclaration getMethodDeclaration() {
        return (FunctionDeclaration)ASTNodes.getParent((ASTNode)this.fTempDeclarationNode, FunctionDeclaration.class);
    }

    private boolean isDeclaredInAnonymousClass() {
        return ASTNodes.getParent((ASTNode)this.fTempDeclarationNode, AnonymousClassDeclaration.class) != null;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = Checks.validateModifiesFiles(ResourceUtil.getFiles(new IJavaScriptUnit[]{this.fCu}), this.getValidationContext());
        if (result.hasFatalError()) {
            return result;
        }
        this.initAST(pm);
        if (this.fTempDeclarationNode == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_select_declaration);
        }
        if (!Checks.isDeclaredIn(this.fTempDeclarationNode, FunctionDeclaration.class)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_only_declared_in_methods);
        }
        if (this.isMethodParameter()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_method_parameters);
        }
        if (this.isTempAnExceptionInCatchBlock()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_exceptions);
        }
        result.merge(this.checkTempTypeForLocalTypeUsage());
        if (result.hasFatalError()) {
            return result;
        }
        this.checkTempInitializerForLocalTypeUsage();
        if (!this.fSelfInitializing) {
            this.initializeDefaults();
        }
        return result;
    }

    private void initializeDefaults() {
        this.fVisibility = 2;
        this.fDeclareStatic = Modifier.isStatic(this.getMethodDeclaration().getModifiers());
        this.fDeclareFinal = false;
        if (this.canEnableSettingDeclareInMethod()) {
            this.fInitializeIn = 1;
        } else if (this.canEnableSettingDeclareInFieldDeclaration()) {
            this.fInitializeIn = 0;
        } else if (this.canEnableSettingDeclareInConstructors()) {
            this.fInitializeIn = 2;
        }
    }

    public String[] guessFieldNames() {
        String rawTempName = StubUtility.removePrefixAndSuffixForVariable(this.fCu.getJavaScriptProject(), this.fTempDeclarationNode.resolveBinding());
        String[] excludedNames = this.getNamesOfFieldsInDeclaringType();
        int dim = ASTNodes.getDimensions(this.fTempDeclarationNode);
        return StubUtility.getFieldNameSuggestions(this.fCu.getJavaScriptProject(), rawTempName, dim, this.getModifiers(), excludedNames);
    }

    private String getInitialFieldName() {
        String[] suggestedNames = this.guessFieldNames();
        if (suggestedNames.length > 0) {
            if (this.fLinkedProposalModel != null) {
                LinkedProposalPositionGroup nameGroup = this.fLinkedProposalModel.getPositionGroup(LINKED_NAME, true);
                int i = 0;
                while (i < suggestedNames.length) {
                    nameGroup.addProposal(suggestedNames[i], null, suggestedNames.length - i);
                    ++i;
                }
            }
            return suggestedNames[0];
        }
        return this.fTempDeclarationNode.getName().getIdentifier();
    }

    private String[] getNamesOfFieldsInDeclaringType() {
        AbstractTypeDeclaration type = this.getEnclosingType();
        if (type instanceof TypeDeclaration) {
            FieldDeclaration[] fields = ((TypeDeclaration)type).getFields();
            ArrayList<String> result = new ArrayList<String>(fields.length);
            int i = 0;
            while (i < fields.length) {
                for (VariableDeclarationFragment field : fields[i].fragments()) {
                    result.add(field.getName().getIdentifier());
                }
                ++i;
            }
            return result.toArray(new String[result.size()]);
        }
        return new String[0];
    }

    private void checkTempInitializerForLocalTypeUsage() {
        Expression initializer = this.fTempDeclarationNode.getInitializer();
        if (initializer == null) {
            return;
        }
        LocalTypeAndVariableUsageAnalyzer localTypeAnalyer = new LocalTypeAndVariableUsageAnalyzer(null);
        initializer.accept(localTypeAnalyer);
        this.fInitializerUsesLocalTypes = !localTypeAnalyer.getUsageOfEnclosingNodes().isEmpty();
    }

    private RefactoringStatus checkTempTypeForLocalTypeUsage() {
        VariableDeclarationStatement vds = this.getTempDeclarationStatement();
        if (vds == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_cannot_promote);
        }
        Type type = vds.getType();
        ITypeBinding binding = type.resolveBinding();
        if (binding == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_cannot_promote);
        }
        LocalTypeAndVariableUsageAnalyzer analyzer = new LocalTypeAndVariableUsageAnalyzer(null);
        type.accept(analyzer);
        boolean usesLocalTypes = !analyzer.getUsageOfEnclosingNodes().isEmpty();
        this.fTempTypeUsesClassTypeVariables = analyzer.getClassTypeVariablesUsed();
        if (usesLocalTypes) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_uses_type_declared_locally);
        }
        return null;
    }

    private VariableDeclarationStatement getTempDeclarationStatement() {
        return (VariableDeclarationStatement)ASTNodes.getParent((ASTNode)this.fTempDeclarationNode, VariableDeclarationStatement.class);
    }

    private boolean isTempAnExceptionInCatchBlock() {
        return this.fTempDeclarationNode.getParent() instanceof CatchClause;
    }

    private boolean isMethodParameter() {
        return this.fTempDeclarationNode.getParent() instanceof FunctionDeclaration;
    }

    private void initAST(IProgressMonitor pm) {
        if (this.fCompilationUnitNode == null) {
            this.fCompilationUnitNode = RefactoringASTParser.parseWithASTProvider(this.fCu, true, pm);
            this.fTempDeclarationNode = TempDeclarationFinder.findTempDeclaration(this.fCompilationUnitNode, this.fSelectionStart, this.fSelectionLength);
        }
    }

    public RefactoringStatus validateInput() {
        return Checks.checkFieldName(this.fFieldName);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        try {
            RefactoringStatus result = new RefactoringStatus();
            result.merge(this.checkClashesWithExistingFields());
            if (this.fInitializeIn == 2) {
                result.merge(this.checkClashesInConstructors());
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private RefactoringStatus checkClashesInConstructors() {
        Assert.isTrue((this.fInitializeIn == 2 ? 1 : 0) != 0);
        Assert.isTrue((!this.isDeclaredInAnonymousClass() ? 1 : 0) != 0);
        AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)this.getMethodDeclaration().getParent();
        if (declaration instanceof TypeDeclaration) {
            FunctionDeclaration[] methods = ((TypeDeclaration)declaration).getMethods();
            int i = 0;
            while (i < methods.length) {
                FunctionDeclaration method = methods[i];
                if (method.isConstructor()) {
                    NameCollector nameCollector = new NameCollector(method){

                        @Override
                        protected boolean visitNode(ASTNode node) {
                            return true;
                        }
                    };
                    method.accept(nameCollector);
                    List names = nameCollector.getNames();
                    if (names.contains(this.fFieldName)) {
                        Object[] keys = new String[]{this.fFieldName, BindingLabelProvider.getBindingLabel(method.resolveBinding(), 2235681801344L)};
                        String msg = Messages.format(RefactoringCoreMessages.PromoteTempToFieldRefactoring_Name_conflict, keys);
                        return RefactoringStatus.createFatalErrorStatus((String)msg);
                    }
                }
                ++i;
            }
        }
        return null;
    }

    private RefactoringStatus checkClashesWithExistingFields() {
        FieldDeclaration[] existingFields = this.getFieldDeclarations(this.getBodyDeclarationListOfDeclaringType());
        int i = 0;
        while (i < existingFields.length) {
            FieldDeclaration declaration = existingFields[i];
            VariableDeclarationFragment[] fragments = declaration.fragments().toArray(new VariableDeclarationFragment[declaration.fragments().size()]);
            int j = 0;
            while (j < fragments.length) {
                VariableDeclarationFragment fragment = fragments[j];
                if (this.fFieldName.equals(fragment.getName().getIdentifier())) {
                    RefactoringStatusContext context = JavaStatusContext.create((ITypeRoot)this.fCu, fragment);
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_Name_conflict_with_field, (RefactoringStatusContext)context);
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private ChildListPropertyDescriptor getBodyDeclarationListOfDeclaringType() {
        ASTNode methodParent = this.getMethodDeclaration().getParent();
        if (methodParent instanceof AbstractTypeDeclaration) {
            return ((AbstractTypeDeclaration)methodParent).getBodyDeclarationsProperty();
        }
        if (methodParent instanceof AnonymousClassDeclaration) {
            return AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY;
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private FieldDeclaration[] getFieldDeclarations(ChildListPropertyDescriptor descriptor) {
        List bodyDeclarations = (List)this.getMethodDeclaration().getParent().getStructuralProperty(descriptor);
        ArrayList fields = new ArrayList(1);
        for (Object each : bodyDeclarations) {
            if (!(each instanceof FieldDeclaration)) continue;
            fields.add(each);
        }
        return fields.toArray(new FieldDeclaration[fields.size()]);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        try {
            if (this.fFieldName.length() == 0) {
                this.fFieldName = this.getInitialFieldName();
            }
            ASTRewrite rewrite = ASTRewrite.create(this.fCompilationUnitNode.getAST());
            if (this.fInitializeIn == 1 && this.tempHasInitializer()) {
                this.addLocalDeclarationSplit(rewrite);
            } else {
                this.addLocalDeclarationRemoval(rewrite);
            }
            if (this.fInitializeIn == 2) {
                this.addInitializersToConstructors(rewrite);
            }
            this.addTempRenames(rewrite);
            this.addFieldDeclaration(rewrite);
            Change change = this.createChange(rewrite);
            return change;
        }
        finally {
            pm.done();
        }
    }

    private void addTempRenames(ASTRewrite rewrite) {
        boolean noNameChange = this.fFieldName.equals(this.fTempDeclarationNode.getName().getIdentifier());
        if (this.fLinkedProposalModel == null && noNameChange) {
            return;
        }
        TempOccurrenceAnalyzer analyzer = new TempOccurrenceAnalyzer(this.fTempDeclarationNode, false);
        analyzer.perform();
        SimpleName[] tempRefs = analyzer.getReferenceNodes();
        int j = 0;
        while (j < tempRefs.length) {
            SimpleName occurence = tempRefs[j];
            if (noNameChange) {
                this.addLinkedName(rewrite, occurence, false);
            } else {
                SimpleName newName = this.getAST().newSimpleName(this.fFieldName);
                this.addLinkedName(rewrite, newName, false);
                rewrite.replace(occurence, newName, null);
            }
            ++j;
        }
    }

    private void addInitializersToConstructors(ASTRewrite rewrite) throws CoreException {
        Assert.isTrue((!this.isDeclaredInAnonymousClass() ? 1 : 0) != 0);
        AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)this.getMethodDeclaration().getParent();
        FunctionDeclaration[] constructors = PromoteTempToFieldRefactoring.getAllConstructors(declaration);
        if (constructors.length == 0) {
            AST ast = rewrite.getAST();
            FunctionDeclaration newConstructor = ast.newFunctionDeclaration();
            newConstructor.setConstructor(true);
            newConstructor.modifiers().addAll(ast.newModifiers(declaration.getModifiers() & 7));
            newConstructor.setName(ast.newSimpleName(declaration.getName().getIdentifier()));
            newConstructor.setJavadoc(this.getNewConstructorComment(rewrite));
            newConstructor.setBody(ast.newBlock());
            this.addFieldInitializationToConstructor(rewrite, newConstructor);
            int insertionIndex = this.computeInsertIndexForNewConstructor(declaration);
            rewrite.getListRewrite(declaration, declaration.getBodyDeclarationsProperty()).insertAt(newConstructor, insertionIndex, null);
        } else {
            int index = 0;
            while (index < constructors.length) {
                if (PromoteTempToFieldRefactoring.shouldInsertTempInitialization(constructors[index])) {
                    this.addFieldInitializationToConstructor(rewrite, constructors[index]);
                }
                ++index;
            }
        }
    }

    private String getEnclosingTypeName() {
        return this.getEnclosingType().getName().getIdentifier();
    }

    private AbstractTypeDeclaration getEnclosingType() {
        return (AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)this.getTempDeclarationStatement(), AbstractTypeDeclaration.class);
    }

    private JSdoc getNewConstructorComment(ASTRewrite rewrite) throws CoreException {
        String comment;
        if (StubUtility.doAddComments(this.fCu.getJavaScriptProject()) && (comment = CodeGeneration.getMethodComment(this.fCu, this.getEnclosingTypeName(), this.getEnclosingTypeName(), new String[0], new String[0], null, null, StubUtility.getLineDelimiterUsed(this.fCu))) != null && comment.length() > 0) {
            return (JSdoc)rewrite.createStringPlaceholder(comment, 29);
        }
        return null;
    }

    private int computeInsertIndexForNewConstructor(AbstractTypeDeclaration declaration) {
        List declarations = declaration.bodyDeclarations();
        if (declarations.isEmpty()) {
            return 0;
        }
        int index = this.findFirstMethodIndex(declaration);
        if (index == -1) {
            return declarations.size();
        }
        return index;
    }

    private int findFirstMethodIndex(AbstractTypeDeclaration typeDeclaration) {
        int i = 0;
        int n = typeDeclaration.bodyDeclarations().size();
        while (i < n) {
            if (typeDeclaration.bodyDeclarations().get(i) instanceof FunctionDeclaration) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void addFieldInitializationToConstructor(ASTRewrite rewrite, FunctionDeclaration constructor) throws JavaScriptModelException {
        if (constructor.getBody() == null) {
            constructor.setBody(this.getAST().newBlock());
        }
        ExpressionStatement newStatement = this.createExpressionStatementThatInitializesField(rewrite);
        rewrite.getListRewrite(constructor.getBody(), Block.STATEMENTS_PROPERTY).insertLast(newStatement, null);
    }

    private static boolean shouldInsertTempInitialization(FunctionDeclaration constructor) {
        Assert.isTrue((boolean)constructor.isConstructor());
        if (constructor.getBody() == null) {
            return false;
        }
        List statements = constructor.getBody().statements();
        if (statements == null) {
            return false;
        }
        return statements.size() <= 0 || !(statements.get(0) instanceof ConstructorInvocation);
    }

    private static FunctionDeclaration[] getAllConstructors(AbstractTypeDeclaration typeDeclaration) {
        if (typeDeclaration instanceof TypeDeclaration) {
            FunctionDeclaration[] allMethods = ((TypeDeclaration)typeDeclaration).getMethods();
            ArrayList<FunctionDeclaration> result = new ArrayList<FunctionDeclaration>(Math.min(allMethods.length, 1));
            int i = 0;
            while (i < allMethods.length) {
                FunctionDeclaration declaration = allMethods[i];
                if (declaration.isConstructor()) {
                    result.add(declaration);
                }
                ++i;
            }
            return result.toArray(new FunctionDeclaration[result.size()]);
        }
        return new FunctionDeclaration[0];
    }

    private Change createChange(ASTRewrite rewrite) throws CoreException {
        HashMap<String, String> arguments = new HashMap<String, String>();
        String project = null;
        IJavaScriptProject javaProject = this.fCu.getJavaScriptProject();
        if (javaProject != null) {
            project = javaProject.getElementName();
        }
        IVariableBinding binding = this.fTempDeclarationNode.resolveBinding();
        String description = Messages.format(RefactoringCoreMessages.PromoteTempToFieldRefactoring_descriptor_description_short, binding.getName());
        String header = Messages.format(RefactoringCoreMessages.PromoteTempToFieldRefactoring_descriptor_description, new String[]{BindingLabelProvider.getBindingLabel(binding, 2235681801344L), BindingLabelProvider.getBindingLabel(binding.getDeclaringMethod(), 2235681801344L)});
        JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, this, header);
        comment.addSetting(Messages.format(RefactoringCoreMessages.PromoteTempToFieldRefactoring_original_pattern, BindingLabelProvider.getBindingLabel(binding, 2235681801344L)));
        comment.addSetting(Messages.format(RefactoringCoreMessages.PromoteTempToFieldRefactoring_field_pattern, this.fFieldName));
        switch (this.fInitializeIn) {
            case 2: {
                comment.addSetting(RefactoringCoreMessages.PromoteTempToFieldRefactoring_initialize_constructor);
                break;
            }
            case 0: {
                comment.addSetting(RefactoringCoreMessages.PromoteTempToFieldRefactoring_initialize_declaration);
                break;
            }
            case 1: {
                comment.addSetting(RefactoringCoreMessages.PromoteTempToFieldRefactoring_initialize_method);
            }
        }
        String visibility = JdtFlags.getVisibilityString(this.fVisibility);
        if ("".equals(visibility)) {
            visibility = RefactoringCoreMessages.PromoteTempToFieldRefactoring_default_visibility;
        }
        comment.addSetting(Messages.format(RefactoringCoreMessages.PromoteTempToFieldRefactoring_visibility_pattern, visibility));
        if (this.fDeclareFinal && this.fDeclareStatic) {
            comment.addSetting(RefactoringCoreMessages.PromoteTempToFieldRefactoring_declare_final_static);
        } else if (this.fDeclareFinal) {
            comment.addSetting(RefactoringCoreMessages.PromoteTempToFieldRefactoring_declare_final);
        } else if (this.fDeclareStatic) {
            comment.addSetting(RefactoringCoreMessages.PromoteTempToFieldRefactoring_declare_static);
        }
        JDTRefactoringDescriptor descriptor = new JDTRefactoringDescriptor("org.eclipse.wst.jsdt.ui.promote.temp", project, description, comment.asString(), arguments, 2);
        arguments.put("input", descriptor.elementToHandle(this.fCu));
        arguments.put(LINKED_NAME, this.fFieldName);
        arguments.put("selection", String.valueOf(Integer.valueOf(this.fSelectionStart).toString()) + " " + Integer.valueOf(this.fSelectionLength).toString());
        arguments.put(ATTRIBUTE_STATIC, Boolean.valueOf(this.fDeclareStatic).toString());
        arguments.put(ATTRIBUTE_FINAL, Boolean.valueOf(this.fDeclareFinal).toString());
        arguments.put(ATTRIBUTE_VISIBILITY, Integer.valueOf(this.fVisibility).toString());
        arguments.put(ATTRIBUTE_INITIALIZE, Integer.valueOf(this.fInitializeIn).toString());
        CompilationUnitChange result = new CompilationUnitChange(RefactoringCoreMessages.PromoteTempToFieldRefactoring_name, this.fCu);
        result.setDescriptor((ChangeDescriptor)new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor));
        TextEdit resultingEdits = rewrite.rewriteAST();
        TextChangeCompatibility.addTextEdit((TextChange)result, RefactoringCoreMessages.PromoteTempToFieldRefactoring_editName, resultingEdits);
        return result;
    }

    private void addLocalDeclarationSplit(ASTRewrite rewrite) throws JavaScriptModelException {
        VariableDeclarationStatement tempDeclarationStatement = this.getTempDeclarationStatement();
        Block block = (Block)tempDeclarationStatement.getParent();
        int statementIndex = block.statements().indexOf(tempDeclarationStatement);
        Assert.isTrue((statementIndex != -1 ? 1 : 0) != 0);
        List fragments = tempDeclarationStatement.fragments();
        int fragmentIndex = fragments.indexOf(this.fTempDeclarationNode);
        Assert.isTrue((fragmentIndex != -1 ? 1 : 0) != 0);
        int i1 = fragmentIndex;
        int n = fragments.size();
        while (i1 < n) {
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(i1);
            rewrite.remove(fragment, null);
            ++i1;
        }
        if (fragmentIndex == 0) {
            rewrite.remove(tempDeclarationStatement, null);
        }
        Assert.isTrue((boolean)this.tempHasInitializer());
        rewrite.getListRewrite(block, Block.STATEMENTS_PROPERTY).insertAt(this.createExpressionStatementThatInitializesField(rewrite), statementIndex + 1, null);
        if (fragmentIndex + 1 < fragments.size()) {
            VariableDeclarationFragment firstFragmentAfter = (VariableDeclarationFragment)fragments.get(fragmentIndex + 1);
            VariableDeclarationFragment copyfirstFragmentAfter = (VariableDeclarationFragment)rewrite.createCopyTarget(firstFragmentAfter);
            VariableDeclarationStatement statement = this.getAST().newVariableDeclarationStatement(copyfirstFragmentAfter);
            Type type = (Type)rewrite.createCopyTarget(tempDeclarationStatement.getType());
            statement.setType(type);
            List modifiers = tempDeclarationStatement.modifiers();
            if (modifiers.size() > 0) {
                ListRewrite modifiersRewrite = rewrite.getListRewrite(tempDeclarationStatement, VariableDeclarationStatement.MODIFIERS2_PROPERTY);
                ASTNode firstModifier = (ASTNode)modifiers.get(0);
                ASTNode lastModifier = (ASTNode)modifiers.get(modifiers.size() - 1);
                ASTNode modifiersCopy = modifiersRewrite.createCopyTarget(firstModifier, lastModifier);
                statement.modifiers().add(modifiersCopy);
            }
            int i = fragmentIndex + 2;
            while (i < fragments.size()) {
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(i);
                VariableDeclarationFragment fragmentCopy = (VariableDeclarationFragment)rewrite.createCopyTarget(fragment);
                statement.fragments().add(fragmentCopy);
                ++i;
            }
            rewrite.getListRewrite(block, Block.STATEMENTS_PROPERTY).insertAt(statement, statementIndex + 2, null);
        }
    }

    private ExpressionStatement createExpressionStatementThatInitializesField(ASTRewrite rewrite) throws JavaScriptModelException {
        AST ast = this.getAST();
        Assignment assignment = ast.newAssignment();
        SimpleName fieldName = ast.newSimpleName(this.fFieldName);
        this.addLinkedName(rewrite, fieldName, true);
        assignment.setLeftHandSide(fieldName);
        assignment.setRightHandSide(this.getTempInitializerCopy(rewrite));
        return ast.newExpressionStatement(assignment);
    }

    private void addLinkedName(ASTRewrite rewrite, SimpleName fieldName, boolean isFirst) {
        if (this.fLinkedProposalModel != null) {
            this.fLinkedProposalModel.getPositionGroup(LINKED_NAME, true).addPosition(rewrite.track(fieldName), isFirst);
        }
    }

    private Expression getTempInitializerCopy(ASTRewrite rewrite) throws JavaScriptModelException {
        Expression initializer = (Expression)rewrite.createCopyTarget(this.getTempInitializer());
        if (initializer instanceof ArrayInitializer && ASTNodes.getDimensions(this.fTempDeclarationNode) > 0) {
            ArrayCreation arrayCreation = rewrite.getAST().newArrayCreation();
            arrayCreation.setType((ArrayType)ASTNodeFactory.newType(rewrite.getAST(), this.fTempDeclarationNode));
            arrayCreation.setInitializer((ArrayInitializer)initializer);
            return arrayCreation;
        }
        return initializer;
    }

    private void addLocalDeclarationRemoval(ASTRewrite rewrite) {
        VariableDeclarationStatement tempDeclarationStatement = this.getTempDeclarationStatement();
        List fragments = tempDeclarationStatement.fragments();
        int fragmentIndex = fragments.indexOf(this.fTempDeclarationNode);
        Assert.isTrue((fragmentIndex != -1 ? 1 : 0) != 0);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(fragmentIndex);
        rewrite.remove(fragment, null);
        if (fragments.size() == 1) {
            rewrite.remove(tempDeclarationStatement, null);
        }
    }

    private void addFieldDeclaration(ASTRewrite rewrite) {
        ChildListPropertyDescriptor descriptor = this.getBodyDeclarationListOfDeclaringType();
        FieldDeclaration[] fields = this.getFieldDeclarations(this.getBodyDeclarationListOfDeclaringType());
        ASTNode parent = this.getMethodDeclaration().getParent();
        int insertIndex = fields.length == 0 ? 0 : ((List)parent.getStructuralProperty(descriptor)).indexOf(fields[fields.length - 1]) + 1;
        FieldDeclaration declaration = this.createNewFieldDeclaration(rewrite);
        rewrite.getListRewrite(parent, descriptor).insertAt(declaration, insertIndex, null);
    }

    private FieldDeclaration createNewFieldDeclaration(ASTRewrite rewrite) {
        AST ast = this.getAST();
        VariableDeclarationFragment fragment = ast.newVariableDeclarationFragment();
        SimpleName variableName = ast.newSimpleName(this.fFieldName);
        fragment.setName(variableName);
        this.addLinkedName(rewrite, variableName, false);
        fragment.setExtraDimensions(this.fTempDeclarationNode.getExtraDimensions());
        if (this.fInitializeIn == 0 && this.tempHasInitializer()) {
            Expression initializer = (Expression)rewrite.createCopyTarget(this.getTempInitializer());
            fragment.setInitializer(initializer);
        }
        FieldDeclaration fieldDeclaration = ast.newFieldDeclaration(fragment);
        VariableDeclarationStatement vds = this.getTempDeclarationStatement();
        Type type = (Type)rewrite.createCopyTarget(vds.getType());
        fieldDeclaration.setType(type);
        fieldDeclaration.modifiers().addAll(ASTNodeFactory.newModifiers(ast, this.getModifiers()));
        return fieldDeclaration;
    }

    private int getModifiers() {
        int flags = this.fVisibility;
        if (this.fDeclareFinal) {
            flags |= 0x10;
        }
        if (this.fDeclareStatic) {
            flags |= 8;
        }
        return flags;
    }

    private AST getAST() {
        return this.fTempDeclarationNode.getAST();
    }

    @Override
    public RefactoringStatus initialize(RefactoringArguments arguments) {
        String declareFinal;
        this.fSelfInitializing = true;
        if (arguments instanceof JavaRefactoringArguments) {
            String name;
            String initialize;
            IJavaScriptElement element;
            int length;
            int offset;
            JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
            String selection = extended.getAttribute("selection");
            if (selection != null) {
                offset = -1;
                length = -1;
                StringTokenizer tokenizer = new StringTokenizer(selection);
                if (tokenizer.hasMoreTokens()) {
                    offset = Integer.valueOf(tokenizer.nextToken());
                }
                if (tokenizer.hasMoreTokens()) {
                    length = Integer.valueOf(tokenizer.nextToken());
                }
                if (offset < 0 || length < 0) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{selection, "selection"}));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
            }
            this.fSelectionStart = offset;
            this.fSelectionLength = length;
            String handle = extended.getAttribute("input");
            if (handle != null) {
                element = JDTRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
                if (element == null || !element.exists() || element.getElementType() != 5) {
                    return this.createInputFatalStatus(element, "org.eclipse.wst.jsdt.ui.promote.temp");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            this.fCu = (IJavaScriptUnit)element;
            String visibility = extended.getAttribute(ATTRIBUTE_VISIBILITY);
            if (visibility != null && !"".equals(visibility)) {
                int flag = 0;
                try {
                    flag = Integer.parseInt(visibility);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_VISIBILITY));
                }
                this.fVisibility = flag;
            }
            if ((initialize = extended.getAttribute(ATTRIBUTE_INITIALIZE)) != null && !"".equals(initialize)) {
                int value = 0;
                try {
                    value = Integer.parseInt(initialize);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_INITIALIZE));
                }
                this.fInitializeIn = value;
            }
            if ((name = extended.getAttribute(LINKED_NAME)) == null || "".equals(name)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, LINKED_NAME));
            }
            this.fFieldName = name;
            String declareStatic = extended.getAttribute(ATTRIBUTE_STATIC);
            if (declareStatic == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_STATIC));
            }
            this.fDeclareStatic = Boolean.valueOf(declareStatic);
            declareFinal = extended.getAttribute(ATTRIBUTE_FINAL);
            if (declareFinal == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_FINAL));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.fDeclareFinal = Boolean.valueOf(declareFinal);
        return new RefactoringStatus();
    }

    public void setLinkedProposalModel(LinkedProposalModel model) {
        this.fLinkedProposalModel = model;
    }

    private static class LocalTypeAndVariableUsageAnalyzer
    extends HierarchicalASTVisitor {
        private final List fLocalDefinitions = new ArrayList(0);
        private final List fLocalReferencesToEnclosing = new ArrayList(0);
        private final List fMethodTypeVariables;
        private boolean fClassTypeVariablesUsed = false;

        public LocalTypeAndVariableUsageAnalyzer(ITypeBinding[] methodTypeVariables) {
            this.fMethodTypeVariables = Arrays.asList(methodTypeVariables);
        }

        public List getUsageOfEnclosingNodes() {
            return this.fLocalReferencesToEnclosing;
        }

        public boolean getClassTypeVariablesUsed() {
            return this.fClassTypeVariablesUsed;
        }

        @Override
        public boolean visit(SimpleName node) {
            IBinding binding;
            ITypeBinding typeBinding = node.resolveTypeBinding();
            if (typeBinding != null && typeBinding.isLocal()) {
                if (node.isDeclaration()) {
                    this.fLocalDefinitions.add(typeBinding);
                } else if (!this.fLocalDefinitions.contains(typeBinding)) {
                    this.fLocalReferencesToEnclosing.add(node);
                }
            }
            if ((binding = node.resolveBinding()) != null && binding.getKind() == 3 && !((IVariableBinding)binding).isField()) {
                if (node.isDeclaration()) {
                    this.fLocalDefinitions.add(binding);
                } else if (!this.fLocalDefinitions.contains(binding)) {
                    this.fLocalReferencesToEnclosing.add(node);
                }
            }
            return super.visit(node);
        }
    }
}

