/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.nls;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSSubstitution;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.changes.CreateTextFileChange;
import org.eclipse.wst.jsdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.preferences.MembersOrderPreferenceCache;
import org.eclipse.wst.jsdt.ui.CodeGeneration;

public class AccessorClassCreator {
    private final IJavaScriptUnit fCu;
    private final String fAccessorClassName;
    private final IPath fAccessorPath;
    private final IPath fResourceBundlePath;
    private final IPackageFragment fAccessorPackage;
    private final boolean fIsEclipseNLS;
    private final NLSSubstitution[] fNLSSubstitutions;
    private final String fSubstitutionPattern;

    private AccessorClassCreator(IJavaScriptUnit cu, String accessorClassname, IPath accessorPath, IPackageFragment accessorPackage, IPath resourceBundlePath, boolean isEclipseNLS, NLSSubstitution[] nlsSubstitutions, String substitutionPattern) {
        this.fCu = cu;
        this.fAccessorClassName = accessorClassname;
        this.fAccessorPath = accessorPath;
        this.fAccessorPackage = accessorPackage;
        this.fResourceBundlePath = resourceBundlePath;
        this.fIsEclipseNLS = isEclipseNLS;
        this.fNLSSubstitutions = nlsSubstitutions;
        this.fSubstitutionPattern = substitutionPattern;
    }

    public static Change create(IJavaScriptUnit cu, String accessorClassname, IPath accessorPath, IPackageFragment accessorPackage, IPath resourceBundlePath, boolean isEclipseNLS, NLSSubstitution[] nlsSubstitutions, String substitutionPattern, IProgressMonitor pm) throws CoreException {
        AccessorClassCreator accessorClass = new AccessorClassCreator(cu, accessorClassname, accessorPath, accessorPackage, resourceBundlePath, isEclipseNLS, nlsSubstitutions, substitutionPattern);
        return new CreateTextFileChange(accessorPath, accessorClass.createAccessorCUSource(pm), null, "java");
    }

    private String createAccessorCUSource(IProgressMonitor pm) throws CoreException {
        IProject project = AccessorClassCreator.getFileHandle(this.fAccessorPath).getProject();
        String lineDelimiter = StubUtility.getLineDelimiterPreference(project);
        return CodeFormatterUtil.format(8, this.getUnformattedSource(pm), 0, null, lineDelimiter, this.fCu.getJavaScriptProject());
    }

    private static IFile getFileHandle(IPath filePath) {
        if (filePath == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
    }

    private String getUnformattedSource(IProgressMonitor pm) throws CoreException {
        IJavaScriptUnit newCu = null;
        try {
            String classContent;
            String cuContent;
            newCu = this.fAccessorPackage.getJavaScriptUnit(this.fAccessorPath.lastSegment()).getWorkingCopy(null);
            String typeComment = null;
            String fileComment = null;
            IJavaScriptProject project = newCu.getJavaScriptProject();
            String lineDelim = StubUtility.getLineDelimiterUsed(project);
            if (StubUtility.doAddComments(project)) {
                typeComment = CodeGeneration.getTypeComment(newCu, this.fAccessorClassName, lineDelim);
                fileComment = CodeGeneration.getFileComment(newCu, lineDelim);
            }
            if ((cuContent = CodeGeneration.getCompilationUnitContent(newCu, fileComment, typeComment, classContent = this.createClass(lineDelim), lineDelim)) == null) {
                StringBuffer buf = new StringBuffer();
                if (fileComment != null) {
                    buf.append(fileComment).append(lineDelim);
                }
                if (!this.fAccessorPackage.isDefaultPackage()) {
                    buf.append("package ").append(this.fAccessorPackage.getElementName()).append(';');
                }
                buf.append(lineDelim).append(lineDelim);
                if (typeComment != null) {
                    buf.append(typeComment).append(lineDelim);
                }
                buf.append(classContent);
                cuContent = buf.toString();
            }
            newCu.getBuffer().setContents(cuContent);
            this.addImportsToAccessorCu(newCu, pm);
            String string = newCu.getSource();
            return string;
        }
        finally {
            if (newCu != null) {
                newCu.discardWorkingCopy();
            }
        }
    }

    private void addImportsToAccessorCu(IJavaScriptUnit newCu, IProgressMonitor pm) throws CoreException {
        ImportRewrite is = StubUtility.createImportRewrite(newCu, true);
        if (this.fIsEclipseNLS) {
            is.addImport("org.eclipse.osgi.util.NLS");
        } else {
            is.addImport("java.util.MissingResourceException");
            is.addImport("java.util.ResourceBundle");
        }
        TextEdit edit = is.rewriteImports(pm);
        JavaModelUtil.applyEdit(newCu, edit, false, null);
    }

    private String createClass(String lineDelim) throws CoreException {
        if (this.fIsEclipseNLS) {
            MembersOrderPreferenceCache sortOrder = JavaScriptPlugin.getDefault().getMemberOrderPreferenceCache();
            int constructorIdx = sortOrder.getCategoryIndex(1);
            int fieldIdx = sortOrder.getCategoryIndex(5);
            int initIdx = sortOrder.getCategoryIndex(6);
            String constructor = String.valueOf(this.createConstructor(lineDelim)) + lineDelim;
            String initializer = String.valueOf(this.createStaticInitializer(lineDelim)) + lineDelim;
            String fields = String.valueOf(this.createStaticFields(lineDelim)) + lineDelim;
            StringBuffer result = new StringBuffer();
            result.append("public class ").append(this.fAccessorClassName).append(" extends NLS {");
            result.append("private static final String ").append("BUNDLE_NAME").append(" = \"").append(this.getResourceBundleName()).append("\"; ");
            result.append(NLSElement.createTagText(1)).append(lineDelim);
            if (constructorIdx < fieldIdx) {
                if (fieldIdx < initIdx) {
                    result.append(constructor);
                    result.append(fields);
                    result.append(initializer);
                } else {
                    result.append(constructor);
                    result.append(initializer);
                    result.append(fields);
                }
            } else if (constructorIdx < initIdx) {
                result.append(fields);
                result.append(constructor);
                result.append(initializer);
            } else {
                result.append(fields);
                result.append(initializer);
                result.append(constructor);
            }
            result.append('}').append(lineDelim);
            return result.toString();
        }
        MembersOrderPreferenceCache sortOrder = JavaScriptPlugin.getDefault().getMemberOrderPreferenceCache();
        int constructorIdx = sortOrder.getCategoryIndex(1);
        int methodIdx = sortOrder.getCategoryIndex(2);
        String constructor = String.valueOf(lineDelim) + this.createConstructor(lineDelim);
        String method = String.valueOf(lineDelim) + this.createGetStringMethod(lineDelim);
        StringBuffer result = new StringBuffer();
        result.append("public class ").append(this.fAccessorClassName).append(" {");
        result.append("private static final String ").append("BUNDLE_NAME");
        result.append(" = \"").append(this.getResourceBundleName()).append("\"; ").append(NLSElement.createTagText(1)).append(lineDelim);
        result.append(lineDelim).append("private static final ResourceBundle ").append(this.getResourceBundleConstantName());
        result.append("= ResourceBundle.getBundle(").append("BUNDLE_NAME").append(");").append(lineDelim);
        if (constructorIdx < methodIdx) {
            result.append(constructor);
            result.append(method);
        } else {
            result.append(constructor);
            result.append(method);
        }
        result.append(lineDelim).append('}').append(lineDelim);
        return result.toString();
    }

    private String getResourceBundleConstantName() {
        return "RESOURCE_BUNDLE";
    }

    private String createStaticFields(String lineDelim) {
        HashSet<String> added = new HashSet<String>();
        ArrayList<NLSSubstitution> subs = new ArrayList<NLSSubstitution>();
        int i = 0;
        while (i < this.fNLSSubstitutions.length) {
            NLSSubstitution substitution = this.fNLSSubstitutions[i];
            int newState = substitution.getState();
            if ((substitution.hasStateChanged() || substitution.isAccessorRename()) && newState == 0 && added.add(substitution.getKey())) {
                subs.add(substitution);
            }
            ++i;
        }
        Collections.sort(subs, new Comparator(){
            private Collator fCollator = Collator.getInstance();

            public int compare(Object o1, Object o2) {
                NLSSubstitution s0 = (NLSSubstitution)o1;
                NLSSubstitution s1 = (NLSSubstitution)o2;
                return this.fCollator.compare(s0.getKey(), s1.getKey());
            }
        });
        StringBuffer buf = new StringBuffer();
        for (NLSSubstitution element : subs) {
            this.appendStaticField(buf, element);
        }
        return buf.toString();
    }

    private void appendStaticField(StringBuffer buf, NLSSubstitution substitution) {
        buf.append("public static String ");
        buf.append(substitution.getKey());
        buf.append(';');
    }

    private String createGetStringMethod(String lineDelim) throws CoreException {
        StringBuffer result = new StringBuffer();
        result.append("public static String ");
        int i = this.fSubstitutionPattern.indexOf("${key}");
        if (i != -1) {
            result.append(this.fSubstitutionPattern.substring(0, i));
            result.append("String key");
            result.append(this.fSubstitutionPattern.substring(i + "${key}".length()));
        } else {
            result.append("getString(String key)");
        }
        result.append('{').append(lineDelim);
        result.append("try {").append(lineDelim).append("return ").append(this.getResourceBundleConstantName()).append(".getString(key);").append(lineDelim).append("} catch (MissingResourceException e) {").append(lineDelim).append("return '!' + key + '!';").append(lineDelim).append("}");
        result.append(lineDelim).append('}');
        return result.toString();
    }

    private String createStaticInitializer(String lineDelim) throws CoreException {
        return "static {" + lineDelim + "// initialize resource bundle" + lineDelim + "NLS.initializeMessages(BUNDLE_NAME, " + this.fAccessorClassName + ".class);" + lineDelim + "}";
    }

    private String createConstructor(String lineDelim) {
        return "private " + this.fAccessorClassName + "(){" + lineDelim + '}';
    }

    private String getPropertyFileName() {
        return this.fResourceBundlePath.lastSegment();
    }

    private String getPropertyFileNameWithoutExtension() {
        String fileName = this.getPropertyFileName();
        return fileName.substring(0, fileName.indexOf(".properties"));
    }

    private String getResourceBundleName() throws CoreException {
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(this.fResourceBundlePath.removeLastSegments(1));
        if (res != null && res.exists()) {
            IJavaScriptElement el = JavaScriptCore.create(res);
            if (el instanceof IPackageFragment) {
                IPackageFragment p = (IPackageFragment)el;
                return String.valueOf(p.getElementName()) + '.' + this.getPropertyFileNameWithoutExtension();
            }
            if (el instanceof IPackageFragmentRoot || el instanceof IJavaScriptProject) {
                return this.getPropertyFileNameWithoutExtension();
            }
        }
        throw new CoreException((IStatus)new StatusInfo(4, "Resourcebundle not specified"));
    }
}

