/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IInitializer;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.Signature;

public class RefactoringHandleTransplanter {
    private final IType fOldType;
    private final IType fNewType;
    private final Map fRefactoredSimilarElements;

    public RefactoringHandleTransplanter(IType oldType, IType newType, Map refactoredSimilarElements) {
        this.fOldType = oldType;
        this.fNewType = newType;
        this.fRefactoredSimilarElements = refactoredSimilarElements == null ? Collections.EMPTY_MAP : refactoredSimilarElements;
    }

    public IMember transplantHandle(IMember handle) {
        LinkedList oldElements = new LinkedList();
        this.addElements(handle, oldElements);
        IMember[] newElements = this.convertElements(oldElements.toArray(new IMember[0]));
        return newElements[newElements.length - 1];
    }

    private void addElements(IMember element, LinkedList chain) {
        chain.addFirst(element);
        IJavaScriptElement parent = element.getParent();
        if (parent instanceof IMember) {
            this.addElements((IMember)parent, chain);
        }
    }

    private IMember[] convertElements(IMember[] oldElements) {
        IMember[] newElements = new IMember[oldElements.length];
        IMember first = oldElements[0];
        Assert.isTrue((boolean)(first instanceof IType));
        newElements[0] = first.equals(this.fOldType) ? this.fNewType : first;
        int i = 1;
        while (i < oldElements.length) {
            IMember newParent = newElements[i - 1];
            IMember currentElement = oldElements[i];
            switch (newParent.getElementType()) {
                case 7: {
                    switch (currentElement.getElementType()) {
                        case 7: {
                            String newName = this.resolveTypeName((IType)currentElement);
                            newElements[i] = ((IType)newParent).getType(newName);
                            break;
                        }
                        case 9: {
                            String newName = this.resolveElementName(currentElement);
                            String[] newParameterTypes = this.resolveParameterTypes((IFunction)currentElement);
                            newElements[i] = ((IType)newParent).getFunction(newName, newParameterTypes);
                            break;
                        }
                        case 10: {
                            IInitializer initializer = (IInitializer)currentElement;
                            newElements[i] = ((IType)newParent).getInitializer(initializer.getOccurrenceCount());
                            break;
                        }
                        case 8: {
                            String newName = this.resolveElementName(currentElement);
                            newElements[i] = ((IType)newParent).getField(newName);
                        }
                    }
                    break;
                }
                case 9: {
                    switch (currentElement.getElementType()) {
                        case 7: {
                            newElements[i] = this.resolveTypeInMember((IFunction)newParent, (IType)currentElement);
                        }
                    }
                    break;
                }
                case 10: {
                    switch (currentElement.getElementType()) {
                        case 7: {
                            newElements[i] = this.resolveTypeInMember((IInitializer)newParent, (IType)currentElement);
                        }
                    }
                    break;
                }
                case 8: {
                    switch (currentElement.getElementType()) {
                        case 7: {
                            newElements[i] = this.resolveTypeInMember((IField)newParent, (IType)currentElement);
                        }
                    }
                }
            }
            ++i;
        }
        return newElements;
    }

    private String[] resolveParameterTypes(IFunction method) {
        String[] oldParameterTypes = method.getParameterTypes();
        String[] newparams = new String[oldParameterTypes.length];
        String[] possibleOldSigs = new String[]{Signature.createTypeSignature(this.fOldType.getElementName(), false), Signature.createTypeSignature(this.fOldType.getElementName(), true), Signature.createTypeSignature(this.fOldType.getFullyQualifiedName(), false), Signature.createTypeSignature(this.fOldType.getFullyQualifiedName(), true)};
        String[] possibleNewSigs = new String[]{Signature.createTypeSignature(this.fNewType.getElementName(), false), Signature.createTypeSignature(this.fNewType.getElementName(), true), Signature.createTypeSignature(this.fNewType.getFullyQualifiedName(), false), Signature.createTypeSignature(this.fNewType.getFullyQualifiedName(), true)};
        int i = 0;
        while (i < oldParameterTypes.length) {
            newparams[i] = oldParameterTypes[i];
            int j = 0;
            while (j < possibleOldSigs.length) {
                newparams[i] = RefactoringHandleTransplanter.replaceAll(newparams[i], possibleOldSigs[j], possibleNewSigs[j]);
                ++j;
            }
            ++i;
        }
        return newparams;
    }

    private String resolveElementName(IJavaScriptElement element) {
        String newName = (String)this.fRefactoredSimilarElements.get(element);
        if (newName != null) {
            return newName;
        }
        return element.getElementName();
    }

    private IMember resolveTypeInMember(IMember newParent, IType oldChild) {
        String newName = "";
        if (oldChild.getElementName().length() != 0) {
            newName = this.resolveTypeName(oldChild);
        }
        return newParent.getType(newName, oldChild.getOccurrenceCount());
    }

    private String resolveTypeName(IType type) {
        return type.equals(this.fOldType) ? this.fNewType.getElementName() : type.getElementName();
    }

    private static String replaceAll(String source, String replaceFrom, String replaceTo) {
        int matchIndex;
        StringBuffer buf = new StringBuffer(source.length());
        int currentIndex = 0;
        while ((matchIndex = source.indexOf(replaceFrom, currentIndex)) != -1) {
            buf.append(source.substring(currentIndex, matchIndex));
            buf.append(replaceTo);
            currentIndex = matchIndex + replaceFrom.length();
        }
        buf.append(source.substring(currentIndex));
        return buf.toString();
    }
}

