/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ImportRemover;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;

public class CompilationUnitRewrite {
    private IJavaScriptUnit fCu;
    private List fTextEditGroups = new ArrayList();
    private JavaScriptUnit fRoot;
    private ASTRewrite fRewrite;
    private ImportRewrite fImportRewrite;
    private ImportRemover fImportRemover;
    private boolean fResolveBindings = true;
    private boolean fStatementsRecovery = false;
    private boolean fBindingsRecovery = false;
    private final WorkingCopyOwner fOwner;
    private IDocument fRememberContent = null;

    public CompilationUnitRewrite(IJavaScriptUnit cu) {
        this(null, cu, null);
    }

    public CompilationUnitRewrite(WorkingCopyOwner owner, IJavaScriptUnit cu) {
        this(owner, cu, null);
    }

    public CompilationUnitRewrite(IJavaScriptUnit cu, JavaScriptUnit root) {
        this(null, cu, root);
    }

    public CompilationUnitRewrite(WorkingCopyOwner owner, IJavaScriptUnit cu, JavaScriptUnit root) {
        this.fOwner = owner;
        this.fCu = cu;
        this.fRoot = root;
    }

    public void rememberContent() {
        this.fRememberContent = new Document();
    }

    public void setResolveBindings(boolean resolve) {
        this.fResolveBindings = resolve;
    }

    public void setStatementsRecovery(boolean statementsRecovery) {
        this.fStatementsRecovery = statementsRecovery;
    }

    public void setBindingRecovery(boolean bindingsRecovery) {
        this.fBindingsRecovery = bindingsRecovery;
    }

    public void clearASTRewrite() {
        this.fRewrite = null;
        this.fTextEditGroups = new ArrayList();
    }

    public void clearImportRewrites() {
        this.fImportRewrite = null;
    }

    public void clearASTAndImportRewrites() {
        this.clearASTRewrite();
        this.fImportRewrite = null;
    }

    public CategorizedTextEditGroup createCategorizedGroupDescription(String name, GroupCategorySet set) {
        CategorizedTextEditGroup result = new CategorizedTextEditGroup(name, set);
        this.fTextEditGroups.add(result);
        return result;
    }

    public TextEditGroup createGroupDescription(String name) {
        TextEditGroup result = new TextEditGroup(name);
        this.fTextEditGroups.add(result);
        return result;
    }

    public CompilationUnitChange createChange() throws CoreException {
        return this.createChange(true, null);
    }

    public CompilationUnitChange createChange(boolean generateGroups, IProgressMonitor monitor) throws CoreException {
        return this.createChange(this.fCu.getElementName(), generateGroups, monitor);
    }

    public CompilationUnitChange createChange(String name, boolean generateGroups, IProgressMonitor monitor) throws CoreException {
        CompilationUnitChange cuChange = new CompilationUnitChange(name, this.fCu);
        MultiTextEdit multiEdit = new MultiTextEdit();
        cuChange.setEdit((TextEdit)multiEdit);
        return this.attachChange(cuChange, generateGroups, monitor);
    }

    public CompilationUnitChange attachChange(CompilationUnitChange cuChange, boolean generateGroups, IProgressMonitor monitor) throws CoreException {
        try {
            TextEdit importsEdit;
            TextEdit rewriteEdit;
            boolean needsImportRewrite;
            boolean needsAstRewrite = this.fRewrite != null;
            boolean needsImportRemoval = this.fImportRemover != null && this.fImportRemover.hasRemovedNodes();
            boolean bl = needsImportRewrite = this.fImportRewrite != null && this.fImportRewrite.hasRecordedChanges() || needsImportRemoval;
            if (!(needsAstRewrite || needsImportRemoval || needsImportRewrite)) {
                return null;
            }
            MultiTextEdit multiEdit = (MultiTextEdit)cuChange.getEdit();
            if (multiEdit == null) {
                multiEdit = new MultiTextEdit();
                cuChange.setEdit((TextEdit)multiEdit);
            }
            if (needsAstRewrite && !CompilationUnitRewrite.isEmptyEdit(rewriteEdit = this.fRememberContent != null ? this.fRewrite.rewriteAST(this.fRememberContent, this.fCu.getJavaScriptProject().getOptions(true)) : this.fRewrite.rewriteAST())) {
                multiEdit.addChild(rewriteEdit);
                if (generateGroups) {
                    for (TextEditGroup group : this.fTextEditGroups) {
                        cuChange.addTextEditGroup(group);
                    }
                }
            }
            if (needsImportRemoval) {
                this.fImportRemover.applyRemoves(this.getImportRewrite());
            }
            if (needsImportRewrite && !CompilationUnitRewrite.isEmptyEdit(importsEdit = this.fImportRewrite.rewriteImports(monitor))) {
                multiEdit.addChild(importsEdit);
                String importUpdateName = RefactoringCoreMessages.ASTData_update_imports;
                cuChange.addTextEditGroup(new TextEditGroup(importUpdateName, importsEdit));
            }
            if (CompilationUnitRewrite.isEmptyEdit((TextEdit)multiEdit)) {
                return null;
            }
            CompilationUnitChange compilationUnitChange = cuChange;
            return compilationUnitChange;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private static boolean isEmptyEdit(TextEdit edit) {
        return edit.getClass() == MultiTextEdit.class && !edit.hasChildren();
    }

    public IJavaScriptUnit getCu() {
        return this.fCu;
    }

    public JavaScriptUnit getRoot() {
        if (this.fRoot == null) {
            this.fRoot = new RefactoringASTParser(3).parse(this.fCu, this.fOwner, this.fResolveBindings, this.fStatementsRecovery, this.fBindingsRecovery, null);
        }
        return this.fRoot;
    }

    public AST getAST() {
        return this.getRoot().getAST();
    }

    public ASTRewrite getASTRewrite() {
        if (this.fRewrite == null) {
            this.fRewrite = ASTRewrite.create(this.getRoot().getAST());
            if (this.fRememberContent != null) {
                try {
                    this.fRememberContent.set(this.fCu.getSource());
                }
                catch (JavaScriptModelException javaScriptModelException) {
                    this.fRememberContent = null;
                }
            }
        }
        return this.fRewrite;
    }

    public ImportRewrite getImportRewrite() {
        if (this.fImportRewrite == null) {
            try {
                this.fImportRewrite = this.fRoot == null ? StubUtility.createImportRewrite(this.fCu, true) : StubUtility.createImportRewrite(this.getRoot(), true);
            }
            catch (CoreException e) {
                JavaScriptPlugin.log(e);
                throw new IllegalStateException(e.getMessage());
            }
        }
        return this.fImportRewrite;
    }

    public ImportRemover getImportRemover() {
        if (this.fImportRemover == null) {
            this.fImportRemover = new ImportRemover(this.fCu.getJavaScriptProject(), this.getRoot());
        }
        return this.fImportRemover;
    }
}

