/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.wst.jsdt.internal.ui.fix.ICleanUp;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.util.ElementValidator;
import org.eclipse.wst.jsdt.ui.JavaScriptUI;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public abstract class CleanUpAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public CleanUpAction(IWorkbenchSite site) {
        super(site);
    }

    public CleanUpAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(CleanUpAction.getCompilationUnit(this.fEditor) != null);
    }

    protected abstract String getActionName();

    protected abstract ICleanUp[] createCleanUps(IJavaScriptUnit[] var1);

    protected void performRefactoring(IJavaScriptUnit[] units, ICleanUp[] cleanUps) throws JavaScriptModelException, InvocationTargetException {
        RefactoringExecutionStarter.startCleanupRefactoring(units, cleanUps, this.getShell(), false, this.getActionName());
    }

    @Override
    public void run(ITextSelection selection) {
        IJavaScriptUnit cu = CleanUpAction.getCompilationUnit(this.fEditor);
        if (cu != null) {
            this.run(cu);
        }
    }

    @Override
    public void run(IStructuredSelection selection) {
        IJavaScriptUnit[] cus = this.getCompilationUnits(selection);
        if (cus.length == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)this.getActionName(), (String)ActionMessages.CleanUpAction_EmptySelection_description);
        } else if (cus.length == 1) {
            this.run(cus[0]);
        } else {
            this.runOnMultiple(cus);
        }
    }

    @Override
    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(CleanUpAction.getCompilationUnit(this.fEditor) != null);
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.isEnabled(selection));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isEnabled(IStructuredSelection selection) {
        Object[] selected = selection.toArray();
        int i = 0;
        while (i < selected.length) {
            block13: {
                try {
                    if (selected[i] instanceof IJavaScriptElement) {
                        IJavaScriptElement elem = (IJavaScriptElement)selected[i];
                        if (elem.exists()) {
                            switch (elem.getElementType()) {
                                case 7: {
                                    return elem.getParent().getElementType() == 5;
                                }
                                case 5: {
                                    return true;
                                }
                                case 12: 
                                case 15: {
                                    return true;
                                }
                                case 3: 
                                case 4: {
                                    IPackageFragmentRoot root = (IPackageFragmentRoot)elem.getAncestor(3);
                                    return root.getKind() == 1;
                                }
                                case 2: {
                                    return true;
                                }
                            }
                        }
                        break block13;
                    }
                    if (selected[i] instanceof LogicalPackage) {
                        return true;
                    }
                }
                catch (JavaScriptModelException e) {
                    if (e.isDoesNotExist()) break block13;
                    JavaScriptPlugin.log((Throwable)((Object)e));
                }
            }
            ++i;
        }
        return false;
    }

    private void run(IJavaScriptUnit cu) {
        if (!ActionUtil.isEditable(this.fEditor, this.getShell(), cu)) {
            return;
        }
        ICleanUp[] cleanUps = this.createCleanUps(new IJavaScriptUnit[]{cu});
        if (cleanUps == null) {
            return;
        }
        if (!ElementValidator.check(cu, this.getShell(), this.getActionName(), this.fEditor != null)) {
            return;
        }
        try {
            this.performRefactoring(new IJavaScriptUnit[]{cu}, cleanUps);
        }
        catch (InvocationTargetException e) {
            JavaScriptPlugin.log(e);
            if (e.getCause() instanceof CoreException) {
                this.showUnexpectedError((CoreException)e.getCause());
            }
        }
        catch (JavaScriptModelException e) {
            this.showUnexpectedError(e);
        }
    }

    private void runOnMultiple(IJavaScriptUnit[] cus) {
        ICleanUp[] cleanUps = this.createCleanUps(cus);
        if (cleanUps == null) {
            return;
        }
        MultiStatus status = new MultiStatus("org.eclipse.wst.jsdt.ui", 0, ActionMessages.CleanUpAction_MultiStateErrorTitle, null);
        int i = 0;
        while (i < cus.length) {
            IJavaScriptUnit cu = cus[i];
            if (!ActionUtil.isOnBuildPath(cu)) {
                String cuLocation = cu.getPath().makeRelative().toString();
                String message = Messages.format(ActionMessages.CleanUpAction_CUNotOnBuildpathMessage, cuLocation);
                status.add((IStatus)new Status(1, "org.eclipse.wst.jsdt.ui", 4, message, null));
            }
            ++i;
        }
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)this.getActionName(), null, (IStatus)status);
            return;
        }
        try {
            this.performRefactoring(cus, cleanUps);
        }
        catch (InvocationTargetException e) {
            JavaScriptPlugin.log(e);
            if (e.getCause() instanceof CoreException) {
                this.showUnexpectedError((CoreException)e.getCause());
            }
        }
        catch (JavaScriptModelException e) {
            this.showUnexpectedError(e);
        }
    }

    private void showUnexpectedError(CoreException e) {
        String message2 = Messages.format(ActionMessages.CleanUpAction_UnexpectedErrorMessage, e.getStatus().getMessage());
        Status status = new Status(4, "org.eclipse.wst.jsdt.ui", 4, message2, null);
        ErrorDialog.openError((Shell)this.getShell(), (String)this.getActionName(), null, (IStatus)status);
    }

    public IJavaScriptUnit[] getCompilationUnits(IStructuredSelection selection) {
        HashSet<IJavaScriptElement> result = new HashSet<IJavaScriptElement>();
        Object[] selected = selection.toArray();
        int i = 0;
        while (i < selected.length) {
            block18: {
                try {
                    if (selected[i] instanceof IJavaScriptElement) {
                        IJavaScriptElement elem = (IJavaScriptElement)selected[i];
                        if (!elem.exists()) break block18;
                        switch (elem.getElementType()) {
                            case 7: {
                                if (elem.getParent().getElementType() == 5) {
                                    result.add(elem.getParent());
                                    break;
                                }
                                break block18;
                            }
                            case 5: {
                                result.add(elem);
                                break;
                            }
                            case 12: {
                                result.add(elem.getParent());
                                break;
                            }
                            case 15: {
                                result.add(elem.getParent());
                                break;
                            }
                            case 4: {
                                this.collectCompilationUnits((IPackageFragment)elem, result);
                                break;
                            }
                            case 3: {
                                this.collectCompilationUnits((IPackageFragmentRoot)elem, result);
                                break;
                            }
                            case 2: {
                                IPackageFragmentRoot[] roots = ((IJavaScriptProject)elem).getPackageFragmentRoots();
                                int k = 0;
                                while (k < roots.length) {
                                    this.collectCompilationUnits(roots[k], result);
                                    ++k;
                                }
                                break block1;
                            }
                        }
                        break block18;
                    }
                    if (selected[i] instanceof LogicalPackage) {
                        IPackageFragment[] packageFragments = ((LogicalPackage)((Object)selected[i])).getFragments();
                        int k = 0;
                        while (k < packageFragments.length) {
                            IPackageFragment pack = packageFragments[k];
                            if (pack.exists()) {
                                this.collectCompilationUnits(pack, result);
                            }
                            ++k;
                        }
                    }
                }
                catch (JavaScriptModelException e) {
                    if (!JavaModelUtil.isExceptionToBeLogged(e)) break block18;
                    JavaScriptPlugin.log((Throwable)((Object)e));
                }
            }
            ++i;
        }
        return result.toArray(new IJavaScriptUnit[result.size()]);
    }

    private void collectCompilationUnits(IPackageFragment pack, Collection result) throws JavaScriptModelException {
        result.addAll(Arrays.asList(pack.getJavaScriptUnits()));
    }

    private void collectCompilationUnits(IPackageFragmentRoot root, Collection result) throws JavaScriptModelException {
        if (root.getKind() == 1) {
            IJavaScriptElement[] children = root.getChildren();
            int i = 0;
            while (i < children.length) {
                this.collectCompilationUnits((IPackageFragment)children[i], result);
                ++i;
            }
        }
    }

    private static IJavaScriptUnit getCompilationUnit(JavaEditor editor) {
        IJavaScriptElement element = JavaScriptUI.getEditorInputJavaElement(editor.getEditorInput());
        if (!(element instanceof IJavaScriptUnit)) {
            return null;
        }
        return (IJavaScriptUnit)element;
    }
}

