/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.browsing;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.OpenInNewWindowAction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.internal.ui.browsing.JavaBrowsingPerspectiveFactory;

public class PatchedOpenInNewWindowAction
extends OpenInNewWindowAction {
    private IWorkbenchWindow fWorkbenchWindow;

    public PatchedOpenInNewWindowAction(IWorkbenchWindow window, IAdaptable input) {
        super(window, input);
        this.fWorkbenchWindow = window;
    }

    public void run() {
        JavaBrowsingPerspectiveFactory.setInputFromAction(this.getSelectedJavaElement());
        try {
            super.run();
        }
        finally {
            JavaBrowsingPerspectiveFactory.setInputFromAction(null);
        }
    }

    private IJavaScriptElement getSelectedJavaElement() {
        ISelection selection;
        if (this.fWorkbenchWindow.getActivePage() != null && (selection = this.fWorkbenchWindow.getActivePage().getSelection()) instanceof IStructuredSelection && !selection.isEmpty()) {
            Object selectedElement = ((IStructuredSelection)selection).getFirstElement();
            if (selectedElement instanceof IJavaScriptElement) {
                return (IJavaScriptElement)selectedElement;
            }
            if (!(selectedElement instanceof IJavaScriptElement) && selectedElement instanceof IAdaptable) {
                return (IJavaScriptElement)((IAdaptable)selectedElement).getAdapter(IJavaScriptElement.class);
            }
            if (selectedElement instanceof IWorkspace) {
                return JavaScriptCore.create(((IWorkspace)selectedElement).getRoot());
            }
        }
        return null;
    }
}

