/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.correction.AbstractMethodCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaElementImageProvider;

public class NewDefiningMethodProposal
extends AbstractMethodCompletionProposal {
    private final IFunctionBinding fMethod;
    private final String[] fParamNames;

    public NewDefiningMethodProposal(String label, IJavaScriptUnit targetCU, ASTNode invocationNode, ITypeBinding binding, IFunctionBinding method, String[] paramNames, int relevance) {
        super(label, targetCU, invocationNode, binding, relevance, null);
        this.fMethod = method;
        this.fParamNames = paramNames;
        ImageDescriptor desc = JavaElementImageProvider.getMethodImageDescriptor(false, method.getModifiers());
        this.setImage(JavaScriptPlugin.getImageDescriptorRegistry().get(desc));
    }

    @Override
    protected boolean isConstructor() {
        return this.fMethod.isConstructor();
    }

    @Override
    protected void addNewParameters(ASTRewrite rewrite, List takenNames, List params) throws CoreException {
        AST ast = rewrite.getAST();
        ImportRewrite importRewrite = this.getImportRewrite();
        ITypeBinding[] bindings = this.fMethod.getParameterTypes();
        IJavaScriptProject project = this.getCompilationUnit().getJavaScriptProject();
        String[][] paramNames = StubUtility.suggestArgumentNamesWithProposals(project, this.fParamNames);
        int i = 0;
        while (i < bindings.length) {
            ITypeBinding curr = bindings[i];
            String[] proposedNames = paramNames[i];
            SingleVariableDeclaration newParam = ast.newSingleVariableDeclaration();
            newParam.setType(importRewrite.addImport(curr, ast));
            newParam.setName(ast.newSimpleName(proposedNames[0]));
            params.add(newParam);
            String groupId = "arg_name_" + i;
            this.addLinkedPosition(rewrite.track(newParam.getName()), false, groupId);
            int k = 0;
            while (k < proposedNames.length) {
                this.addLinkedPositionProposal(groupId, proposedNames[k], null);
                ++k;
            }
            ++i;
        }
    }

    @Override
    protected SimpleName getNewName(ASTRewrite rewrite) {
        AST ast = rewrite.getAST();
        SimpleName nameNode = ast.newSimpleName(this.fMethod.getName());
        return nameNode;
    }

    private int evaluateModifiers() {
        int modifiers = this.fMethod.getModifiers();
        if (Modifier.isPrivate(modifiers)) {
            modifiers |= 4;
        }
        return modifiers & 0xC05;
    }

    @Override
    protected void addNewModifiers(ASTRewrite rewrite, ASTNode targetTypeDecl, List modifiers) {
        modifiers.addAll(rewrite.getAST().newModifiers(this.evaluateModifiers()));
    }

    @Override
    protected Type getNewMethodType(ASTRewrite rewrite) throws CoreException {
        return this.getImportRewrite().addImport(this.fMethod.getReturnType(), rewrite.getAST());
    }
}

