/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.LocalVariableIndex;
import org.eclipse.wst.jsdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;
import org.eclipse.wst.jsdt.internal.corext.dom.VariableDeclarationRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.InOutFlowAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.surround.SurroundWithAnalyzer;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.ui.text.java.IInvocationContext;

public abstract class SurroundWith {
    private final JavaScriptUnit fRootNode;
    private final Statement[] fSelectedStatements;
    private boolean fIsNewContext;
    private ITrackedNodePosition fFirstInsertedPosition;
    private ITrackedNodePosition fLastInsertedPosition;

    public SurroundWith(JavaScriptUnit root, Statement[] selectedStatements) {
        this.fRootNode = root;
        this.fSelectedStatements = selectedStatements;
    }

    public static boolean isApplicable(IInvocationContext context) throws JavaScriptModelException {
        IJavaScriptUnit unit = context.getCompilationUnit();
        JavaScriptUnit ast = ASTProvider.getASTProvider().getAST(unit, ASTProvider.WAIT_NO, null);
        if (ast == null) {
            return true;
        }
        Selection selection = Selection.createFromStartLength(context.getSelectionOffset(), context.getSelectionLength());
        SurroundWithAnalyzer analyzer = new SurroundWithAnalyzer(unit, selection);
        context.getASTRoot().accept(analyzer);
        return analyzer.getStatus().isOK() && analyzer.hasSelectedNodes();
    }

    public static Statement[] getSelectedStatements(IInvocationContext context) throws JavaScriptModelException {
        Selection selection = Selection.createFromStartLength(context.getSelectionOffset(), context.getSelectionLength());
        SurroundWithAnalyzer analyzer = new SurroundWithAnalyzer(context.getCompilationUnit(), selection);
        context.getASTRoot().accept(analyzer);
        if (!analyzer.getStatus().isOK() || !analyzer.hasSelectedNodes()) {
            return null;
        }
        return analyzer.getSelectedStatements();
    }

    public int getBodyStart() {
        return this.fFirstInsertedPosition.getStartPosition();
    }

    public int getBodyLength() {
        return this.fLastInsertedPosition.getStartPosition() + this.fLastInsertedPosition.getLength() - this.getBodyStart();
    }

    public ASTRewrite getRewrite() throws CoreException {
        Statement[] selectedStatements = this.fSelectedStatements;
        AST ast = this.getAst();
        ASTRewrite rewrite = ASTRewrite.create(ast);
        BodyDeclaration enclosingBodyDeclaration = (BodyDeclaration)ASTNodes.getParent((ASTNode)selectedStatements[0], BodyDeclaration.class);
        int maxVariableId = LocalVariableIndex.perform(enclosingBodyDeclaration) + 1;
        this.fIsNewContext = this.isNewContext();
        List accessedAfter = this.getVariableDeclarationsAccessedAfter(selectedStatements[selectedStatements.length - 1], maxVariableId);
        List readInside = this.getVariableDeclarationReadsInside(selectedStatements, maxVariableId);
        ArrayList inserted = new ArrayList();
        this.moveToBlock(selectedStatements, inserted, accessedAfter, readInside, rewrite);
        if (this.fIsNewContext) {
            ImportRewrite importRewrite = StubUtility.createImportRewrite((JavaScriptUnit)selectedStatements[0].getRoot(), false);
            int i = 0;
            while (i < selectedStatements.length) {
                this.qualifyThisExpressions(selectedStatements[i], rewrite, importRewrite);
                ++i;
            }
        }
        if (selectedStatements.length == 1 && ASTNodes.isControlStatementBody(selectedStatements[0].getLocationInParent())) {
            Block wrap = ast.newBlock();
            rewrite.replace(selectedStatements[0], wrap, null);
            ListRewrite listRewrite = rewrite.getListRewrite(wrap, Block.STATEMENTS_PROPERTY);
            for (ASTNode node : inserted) {
                listRewrite.insertLast(node, null);
            }
        } else {
            ListRewrite listRewrite = this.getListRewrite(selectedStatements[0], rewrite);
            ASTNode current = selectedStatements[selectedStatements.length - 1];
            for (ASTNode node : inserted) {
                listRewrite.insertAfter(node, current, null);
                current = node;
            }
        }
        this.fFirstInsertedPosition = rewrite.track((ASTNode)inserted.get(0));
        this.fLastInsertedPosition = rewrite.track((ASTNode)inserted.get(inserted.size() - 1));
        return rewrite;
    }

    protected abstract boolean isNewContext();

    protected List getVariableDeclarationReadsInside(Statement[] selectedNodes, int maxVariableId) {
        ArrayList<ASTNode> result = new ArrayList<ASTNode>();
        if (!this.fIsNewContext) {
            return result;
        }
        IVariableBinding[] reads = this.getReads(selectedNodes, maxVariableId);
        int i = 0;
        while (i < reads.length) {
            ASTNode readDecl;
            IVariableBinding read = reads[i];
            if (!read.isField() && (readDecl = this.getRootNode().findDeclaringNode(read)) instanceof VariableDeclaration) {
                result.add(readDecl);
            }
            ++i;
        }
        return result;
    }

    protected List getVariableDeclarationsAccessedAfter(ASTNode startNode, int maxVariableId) {
        List statements;
        Statement block;
        if (startNode.getLocationInParent() == SwitchStatement.STATEMENTS_PROPERTY) {
            block = (SwitchStatement)ASTNodes.getParent(startNode, SwitchStatement.class);
            statements = ((SwitchStatement)block).statements();
        } else {
            block = (Block)ASTNodes.getParent(startNode, Block.class);
            statements = ((Block)block).statements();
        }
        List bodyAfterSelection = statements.subList(statements.indexOf(startNode) + 1, statements.size());
        ArrayList<ASTNode> result = new ArrayList<ASTNode>();
        if (!bodyAfterSelection.isEmpty()) {
            IVariableBinding[] accesses = this.getAccesses(bodyAfterSelection.toArray(new ASTNode[bodyAfterSelection.size()]), maxVariableId);
            int i = 0;
            while (i < accesses.length) {
                ASTNode readDecl;
                IVariableBinding curVar = accesses[i];
                if (!curVar.isField() && (readDecl = ASTNodes.findDeclaration(curVar, this.getRootNode())) instanceof VariableDeclarationFragment) {
                    result.add(readDecl);
                }
                ++i;
            }
        }
        return result;
    }

    private IVariableBinding[] getReads(ASTNode[] region, int maxVariableId) {
        FlowContext flowContext = new FlowContext(0, maxVariableId);
        flowContext.setConsiderAccessMode(true);
        flowContext.setComputeMode(FlowContext.ARGUMENTS);
        FlowInfo argInfo = new InOutFlowAnalyzer(flowContext).perform(region);
        IVariableBinding[] reads = argInfo.get(flowContext, 38);
        return reads;
    }

    private IVariableBinding[] getAccesses(ASTNode[] region, int maxVariableId) {
        FlowContext flowContext = new FlowContext(0, maxVariableId);
        flowContext.setConsiderAccessMode(true);
        flowContext.setComputeMode(FlowContext.ARGUMENTS);
        FlowInfo argInfo = new InOutFlowAnalyzer(flowContext).perform(region);
        IVariableBinding[] varsAccessedAfter = argInfo.get(flowContext, 62);
        return varsAccessedAfter;
    }

    private final void moveToBlock(Statement[] toMove, List statements, List accessedAfter, List accessedInside, ASTRewrite rewrite) {
        int i = 0;
        while (i < toMove.length) {
            Statement node = toMove[i];
            if (node instanceof VariableDeclarationStatement) {
                VariableDeclarationStatement statement = (VariableDeclarationStatement)node;
                ListRewrite blockRewrite = this.getListRewrite(statement, rewrite);
                this.splitVariableDeclarationStatement(statement, this.createSplitSelectedOperator(accessedAfter, accessedInside, rewrite, statements, blockRewrite), rewrite);
                Iterator iter = statement.fragments().iterator();
                while (iter.hasNext()) {
                    accessedInside.remove(iter.next());
                }
            } else {
                this.insertNodeAtEnd(rewrite, statements, node);
            }
            ++i;
        }
        while (!accessedInside.isEmpty()) {
            VariableDeclaration variableDeclaration = (VariableDeclaration)accessedInside.get(0);
            if (variableDeclaration instanceof SingleVariableDeclaration) {
                if (ASTNodes.findModifierNode(16, ASTNodes.getModifiers(variableDeclaration)) == null) {
                    ModifierRewrite.create(rewrite, variableDeclaration).setModifiers(16, 0, null);
                }
                accessedInside.remove(0);
                continue;
            }
            if (variableDeclaration.getParent() instanceof VariableDeclarationStatement) {
                VariableDeclarationStatement statement = (VariableDeclarationStatement)variableDeclaration.getParent();
                ListRewrite blockRewrite = this.getListRewrite(statement, rewrite);
                this.splitVariableDeclarationStatement(statement, this.createSplitUnselectedOperator(accessedInside, rewrite, blockRewrite), rewrite);
                for (VariableDeclarationFragment fragment : statement.fragments()) {
                    accessedInside.remove(fragment);
                }
                continue;
            }
            if (!(variableDeclaration.getParent() instanceof VariableDeclarationExpression)) continue;
            VariableDeclarationExpression expression = (VariableDeclarationExpression)variableDeclaration.getParent();
            VariableDeclarationRewrite.rewriteModifiers(expression, 16, 0, rewrite, null);
            for (VariableDeclarationFragment fragment : expression.fragments()) {
                accessedInside.remove(fragment);
            }
        }
    }

    private void insertNodeAtEnd(ASTRewrite rewrite, List statements, ASTNode node) {
        statements.add(rewrite.createMoveTarget(node));
    }

    protected ISplitOperation createSplitUnselectedOperator(List accessedInside, ASTRewrite rewrite, ListRewrite blockRewrite) {
        return new SplitUnselectedOperator(accessedInside, blockRewrite, rewrite);
    }

    protected ISplitOperation createSplitSelectedOperator(List accessedAfter, List accessedInside, ASTRewrite rewrite, List statements, ListRewrite blockRewrite) {
        return new SplitSelectedOperator(accessedInside, accessedAfter, blockRewrite, rewrite, statements);
    }

    private void splitVariableDeclarationStatement(VariableDeclarationStatement statement, ISplitOperation splitOperator, ASTRewrite rewrite) {
        List fragments = statement.fragments();
        Iterator iter = fragments.iterator();
        VariableDeclarationFragment lastFragment = (VariableDeclarationFragment)iter.next();
        VariableDeclarationStatement lastStatement = statement;
        splitOperator.initializeStatement(lastStatement, lastFragment);
        ListRewrite fragmentsRewrite = null;
        while (iter.hasNext()) {
            VariableDeclarationFragment currentFragment = (VariableDeclarationFragment)iter.next();
            if (splitOperator.needsSplit(lastFragment, currentFragment)) {
                VariableDeclarationStatement newStatement = this.getAst().newVariableDeclarationStatement((VariableDeclarationFragment)rewrite.createMoveTarget(currentFragment));
                ListRewrite modifierRewrite = rewrite.getListRewrite(newStatement, VariableDeclarationStatement.MODIFIERS2_PROPERTY);
                Iterator iterator = statement.modifiers().iterator();
                while (iterator.hasNext()) {
                    modifierRewrite.insertLast(rewrite.createCopyTarget((ASTNode)iterator.next()), null);
                }
                newStatement.setType((Type)rewrite.createCopyTarget(statement.getType()));
                splitOperator.initializeStatement(newStatement, currentFragment);
                fragmentsRewrite = rewrite.getListRewrite(newStatement, VariableDeclarationStatement.FRAGMENTS_PROPERTY);
                lastStatement = newStatement;
            } else if (fragmentsRewrite != null) {
                ASTNode fragment0 = rewrite.createMoveTarget(currentFragment);
                fragmentsRewrite.insertLast(fragment0, null);
            }
            lastFragment = currentFragment;
        }
    }

    protected static void makeFinal(VariableDeclarationStatement statement, ASTRewrite rewrite) {
        VariableDeclaration fragment = (VariableDeclaration)statement.fragments().get(0);
        if (ASTNodes.findModifierNode(16, ASTNodes.getModifiers(fragment)) == null) {
            ModifierRewrite.create(rewrite, statement).setModifiers(16, 0, null);
        }
    }

    private void qualifyThisExpressions(ASTNode node, final ASTRewrite rewrite, ImportRewrite importRewrite) {
        node.accept(new GenericVisitor(){

            @Override
            public boolean visit(ThisExpression thisExpr) {
                IJavaScriptElement javaElement;
                ITypeBinding typeBinding;
                if (thisExpr.getQualifier() == null && (typeBinding = thisExpr.resolveTypeBinding()) != null && (javaElement = typeBinding.getJavaElement()) instanceof IType) {
                    String typeName = ((IType)javaElement).getElementName();
                    SimpleName simpleName = thisExpr.getAST().newSimpleName(typeName);
                    rewrite.set(thisExpr, ThisExpression.QUALIFIER_PROPERTY, simpleName, null);
                }
                return super.visit(thisExpr);
            }
        });
    }

    protected static void splitOffInitializer(List statements, VariableDeclarationFragment fragment, ASTRewrite rewrite) {
        Expression initializer = fragment.getInitializer();
        if (initializer != null) {
            AST ast = rewrite.getAST();
            Assignment assignment = ast.newAssignment();
            assignment.setLeftHandSide((Expression)rewrite.createCopyTarget(fragment.getName()));
            assignment.setRightHandSide((Expression)rewrite.createMoveTarget(initializer));
            statements.add(ast.newExpressionStatement(assignment));
        }
    }

    private ListRewrite getListRewrite(ASTNode node, ASTRewrite rewrite) {
        if (node.getLocationInParent() == SwitchStatement.STATEMENTS_PROPERTY) {
            ASTNode block = ASTNodes.getParent(node, SwitchStatement.class);
            return rewrite.getListRewrite(block, SwitchStatement.STATEMENTS_PROPERTY);
        }
        ASTNode block = ASTNodes.getParent(node, Block.class);
        return rewrite.getListRewrite(block, Block.STATEMENTS_PROPERTY);
    }

    protected final AST getAst() {
        return this.getRootNode().getAST();
    }

    protected final Statement[] getSelectedStatements() {
        return this.fSelectedStatements;
    }

    private JavaScriptUnit getRootNode() {
        if (this.fSelectedStatements.length > 0) {
            return (JavaScriptUnit)this.fSelectedStatements[0].getRoot();
        }
        return this.fRootNode;
    }

    protected static interface ISplitOperation {
        public boolean needsSplit(VariableDeclarationFragment var1, VariableDeclarationFragment var2);

        public void initializeStatement(VariableDeclarationStatement var1, VariableDeclarationFragment var2);
    }

    private static final class SplitSelectedOperator
    implements ISplitOperation {
        private List fAccessedInside;
        private List fStatements;
        private List fAccessedAfter;
        private ASTRewrite fRewrite;
        private ListRewrite fBlockRewrite;
        private VariableDeclarationStatement fLastStatement = null;

        public SplitSelectedOperator(List inside, List after, ListRewrite blockRewrite, ASTRewrite rewrite, List statements) {
            this.fAccessedInside = inside;
            this.fStatements = statements;
            this.fAccessedAfter = after;
            this.fRewrite = rewrite;
            this.fBlockRewrite = blockRewrite;
        }

        @Override
        public boolean needsSplit(VariableDeclarationFragment last, VariableDeclarationFragment current) {
            return this.fAccessedInside.contains(last) != this.fAccessedInside.contains(current) || this.fAccessedAfter.contains(last) != this.fAccessedAfter.contains(current);
        }

        @Override
        public void initializeStatement(VariableDeclarationStatement statement, VariableDeclarationFragment current) {
            if (this.fAccessedAfter.contains(current)) {
                if (this.fAccessedInside.contains(current)) {
                    SurroundWith.makeFinal(statement, this.fRewrite);
                }
                this.handleInitializer(current);
                if (this.fLastStatement != null) {
                    this.fBlockRewrite.insertAfter(statement, this.fLastStatement, null);
                }
                this.fLastStatement = statement;
            } else if (this.fLastStatement != null) {
                this.handleNewStatement(statement);
            } else {
                this.handleStatement(statement);
                this.fLastStatement = statement;
            }
        }

        protected void handleStatement(Statement statement) {
            this.fStatements.add(this.fRewrite.createMoveTarget(statement));
        }

        protected void handleNewStatement(Statement statement) {
            this.fStatements.add(statement);
        }

        protected void handleInitializer(VariableDeclarationFragment fragment) {
            SurroundWith.splitOffInitializer(this.fStatements, fragment, this.fRewrite);
        }
    }

    private static final class SplitUnselectedOperator
    implements ISplitOperation {
        private List fAccessedInside;
        private ListRewrite fBlockRewrite;
        private ASTRewrite fRewrite;
        private VariableDeclarationStatement fLastStatement;

        private SplitUnselectedOperator(List accessedInside, ListRewrite blockRewrite, ASTRewrite rewrite) {
            this.fAccessedInside = accessedInside;
            this.fBlockRewrite = blockRewrite;
            this.fRewrite = rewrite;
            this.fLastStatement = null;
        }

        @Override
        public boolean needsSplit(VariableDeclarationFragment last, VariableDeclarationFragment current) {
            return this.fAccessedInside.contains(last) ^ this.fAccessedInside.contains(current);
        }

        @Override
        public void initializeStatement(VariableDeclarationStatement statement, VariableDeclarationFragment current) {
            if (this.fAccessedInside.contains(current)) {
                SurroundWith.makeFinal(statement, this.fRewrite);
            }
            if (this.fLastStatement != null) {
                this.fBlockRewrite.insertAfter(statement, this.fLastStatement, null);
            }
            this.fLastStatement = statement;
        }
    }
}

