/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchQuery;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;
import org.eclipse.wst.jsdt.internal.ui.search.SearchUtil;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabelProvider;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;
import org.eclipse.wst.jsdt.ui.search.ElementQuerySpecification;
import org.eclipse.wst.jsdt.ui.search.QuerySpecification;

public abstract class FindAction
extends SelectionDispatchAction {
    private static final IJavaScriptElement RETURN_WITHOUT_BEEP = JavaScriptCore.create(JavaScriptPlugin.getWorkspace().getRoot());
    private Class[] fValidTypes = this.getValidTypes();
    private JavaEditor fEditor;

    FindAction(IWorkbenchSite site) {
        super(site);
        this.init();
    }

    FindAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    abstract void init();

    abstract Class[] getValidTypes();

    private boolean canOperateOn(IStructuredSelection sel) {
        return sel != null && !sel.isEmpty() && this.canOperateOn(this.getJavaElement(sel, true));
    }

    boolean canOperateOn(IJavaScriptElement element) {
        if (element == null || this.fValidTypes == null || this.fValidTypes.length == 0 || !ActionUtil.isOnBuildPath(element)) {
            return false;
        }
        int i = 0;
        while (i < this.fValidTypes.length) {
            if (this.fValidTypes[i].isInstance(element)) {
                if (element.getElementType() == 4) {
                    return this.hasChildren((IPackageFragment)element);
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasChildren(IPackageFragment packageFragment) {
        try {
            return packageFragment.hasChildren();
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return false;
        }
    }

    private IJavaScriptElement getTypeIfPossible(IJavaScriptElement o, boolean silent) {
        switch (o.getElementType()) {
            case 5: {
                if (silent) {
                    return o;
                }
                return this.findType((IJavaScriptUnit)o, silent);
            }
            case 6: {
                return ((IClassFile)o).getType();
            }
        }
        return o;
    }

    IJavaScriptElement getJavaElement(IStructuredSelection selection, boolean silent) {
        if (selection.size() == 1) {
            Object firstElement = selection.getFirstElement();
            IJavaScriptElement elem = null;
            if (firstElement instanceof IJavaScriptElement) {
                elem = (IJavaScriptElement)firstElement;
            } else if (firstElement instanceof IAdaptable) {
                elem = (IJavaScriptElement)((IAdaptable)firstElement).getAdapter(IJavaScriptElement.class);
            }
            if (elem != null) {
                return this.getTypeIfPossible(elem, silent);
            }
        }
        return null;
    }

    private void showOperationUnavailableDialog() {
        MessageDialog.openInformation((Shell)this.getShell(), (String)SearchMessages.JavaElementAction_operationUnavailable_title, (String)this.getOperationUnavailableMessage());
    }

    String getOperationUnavailableMessage() {
        return SearchMessages.JavaElementAction_operationUnavailable_generic;
    }

    private IJavaScriptElement findType(IJavaScriptUnit cu, boolean silent) {
        Object[] types = null;
        try {
            types = cu.getAllTypes();
        }
        catch (JavaScriptModelException ex) {
            if (JavaModelUtil.isExceptionToBeLogged(ex)) {
                ExceptionHandler.log((Throwable)((Object)ex), SearchMessages.JavaElementAction_error_open_message);
            }
            if (silent) {
                return RETURN_WITHOUT_BEEP;
            }
            return null;
        }
        if (types.length == 1 || silent && types.length > 0) {
            return types[0];
        }
        if (silent) {
            return RETURN_WITHOUT_BEEP;
        }
        if (types.length == 0) {
            return null;
        }
        String title = SearchMessages.JavaElementAction_typeSelectionDialog_title;
        String message = SearchMessages.JavaElementAction_typeSelectionDialog_message;
        int flags = 18;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new JavaScriptElementLabelProvider(flags));
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setElements(types);
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        return RETURN_WITHOUT_BEEP;
    }

    @Override
    public void run(IStructuredSelection selection) {
        IJavaScriptElement element = this.getJavaElement(selection, false);
        if (element == null || !element.exists()) {
            this.showOperationUnavailableDialog();
            return;
        }
        if (element == RETURN_WITHOUT_BEEP) {
            return;
        }
        this.run(element);
    }

    @Override
    public void run(ITextSelection selection) {
        if (!ActionUtil.isProcessable(this.fEditor)) {
            return;
        }
        try {
            String title = SearchMessages.SearchElementSelectionDialog_title;
            String message = SearchMessages.SearchElementSelectionDialog_message;
            IJavaScriptElement[] elements = SelectionConverter.codeResolveForked(this.fEditor, true);
            if (elements.length > 0 && this.canOperateOn(elements[0])) {
                IJavaScriptElement element = elements[0];
                if (elements.length > 1) {
                    element = SelectionConverter.selectJavaElement(elements, this.getShell(), title, message);
                }
                if (element != null) {
                    this.run(element);
                }
            } else {
                this.showOperationUnavailableDialog();
            }
        }
        catch (InvocationTargetException ex) {
            String title = SearchMessages.Search_Error_search_title;
            String message = SearchMessages.Search_Error_codeResolve;
            ExceptionHandler.handle(ex, this.getShell(), title, message);
        }
        catch (InterruptedException interruptedException) {}
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.canOperateOn(selection));
    }

    @Override
    public void selectionChanged(ITextSelection selection) {
    }

    public void run(IJavaScriptElement element) {
        if (!ActionUtil.isProcessable(this.getShell(), element)) {
            return;
        }
        try {
            this.performNewSearch(element);
        }
        catch (JavaScriptModelException ex) {
            ExceptionHandler.handle(ex, this.getShell(), SearchMessages.Search_Error_search_notsuccessful_title, SearchMessages.Search_Error_search_notsuccessful_message);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void performNewSearch(IJavaScriptElement element) throws JavaScriptModelException, InterruptedException {
        JavaSearchQuery query = new JavaSearchQuery(this.createQuery(element));
        if (query.canRunInBackground()) {
            SearchUtil.runQueryInBackground(query);
        } else {
            IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
            IStatus status = SearchUtil.runQueryInForeground((IRunnableContext)progressService, query);
            if (status.matches(7)) {
                ErrorDialog.openError((Shell)this.getShell(), (String)SearchMessages.Search_Error_search_title, (String)SearchMessages.Search_Error_search_message, (IStatus)status);
            }
        }
    }

    QuerySpecification createQuery(IJavaScriptElement element) throws JavaScriptModelException, InterruptedException {
        JavaSearchScopeFactory factory = JavaSearchScopeFactory.getInstance();
        IJavaScriptSearchScope scope = factory.createWorkspaceScope(true);
        String description = factory.getWorkspaceScopeDescription(true);
        return new ElementQuerySpecification(element, this.getLimitTo(), scope, description);
    }

    abstract int getLimitTo();

    IType getType(IJavaScriptElement element) {
        if (element == null) {
            return null;
        }
        IType type = null;
        if (element.getElementType() == 7) {
            type = (IType)element;
        } else if (element instanceof IMember) {
            type = ((IMember)element).getDeclaringType();
        } else if (element instanceof ILocalVariable) {
            type = (IType)element.getAncestor(7);
        }
        return type;
    }

    JavaEditor getEditor() {
        return this.fEditor;
    }
}

