/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class ModifyParametersAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public ModifyParametersAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public ModifyParametersAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.RefactoringGroup_modify_Parameters_label);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.modify_parameters_action");
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isChangeSignatureAvailable(selection));
        }
        catch (JavaScriptModelException e) {
            if (JavaModelUtil.isExceptionToBeLogged(e)) {
                JavaScriptPlugin.log((Throwable)((Object)e));
            }
            this.setEnabled(false);
        }
    }

    @Override
    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    @Override
    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isChangeSignatureAvailable(selection));
        }
        catch (JavaScriptModelException javaScriptModelException) {
            this.setEnabled(false);
        }
    }

    @Override
    public void run(IStructuredSelection selection) {
        try {
            if (RefactoringAvailabilityTester.isChangeSignatureAvailable(selection)) {
                IFunction method = ModifyParametersAction.getSingleSelectedMethod(selection);
                if (!ActionUtil.isEditable(this.getShell(), method)) {
                    return;
                }
                RefactoringExecutionStarter.startChangeSignatureRefactoring(method, this, this.getShell());
            }
        }
        catch (JavaScriptModelException e) {
            ExceptionHandler.handle(e, RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }

    @Override
    public void run(ITextSelection selection) {
        try {
            if (!ActionUtil.isEditable(this.fEditor)) {
                return;
            }
            IFunction method = this.getSingleSelectedMethod(selection);
            if (RefactoringAvailabilityTester.isChangeSignatureAvailable(method)) {
                RefactoringExecutionStarter.startChangeSignatureRefactoring(method, this, this.getShell());
            } else {
                MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.OpenRefactoringWizardAction_unavailable, (String)RefactoringMessages.ModifyParametersAction_unavailable);
            }
        }
        catch (JavaScriptModelException e) {
            ExceptionHandler.handle(e, RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }

    private static IFunction getSingleSelectedMethod(IStructuredSelection selection) {
        if (selection.isEmpty() || selection.size() != 1) {
            return null;
        }
        if (selection.getFirstElement() instanceof IFunction) {
            return (IFunction)selection.getFirstElement();
        }
        return null;
    }

    private IFunction getSingleSelectedMethod(ITextSelection selection) throws JavaScriptModelException {
        IJavaScriptElement[] elements = SelectionConverter.codeResolve(this.fEditor);
        if (elements.length > 1) {
            return null;
        }
        if (elements.length == 1 && elements[0] instanceof IFunction) {
            return (IFunction)elements[0];
        }
        IJavaScriptElement elementAt = SelectionConverter.getInputAsCompilationUnit(this.fEditor).getElementAt(selection.getOffset());
        if (elementAt instanceof IFunction) {
            return (IFunction)elementAt;
        }
        return null;
    }
}

