/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.format;

import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.json.core.document.IJSONDocument;
import org.eclipse.wst.json.core.document.IJSONModel;
import org.eclipse.wst.json.core.document.IJSONPair;
import org.eclipse.wst.json.core.internal.format.IJSONSourceFormatter;
import org.eclipse.wst.json.core.internal.format.JSONFormatUtil;
import org.eclipse.wst.json.core.internal.format.JSONSourceFormatterFactory;
import org.eclipse.wst.sse.core.internal.format.AbstractStructuredFormatProcessor;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatPreferences;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatter;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.w3c.dom.Node;

public class FormatProcessorJSON
extends AbstractStructuredFormatProcessor {
    private final int MAX_SMALL_FORMAT_SIZE = 1000;

    @Override
    protected String getFileExtension() {
        return "json";
    }

    @Override
    public void formatModel(IStructuredModel structuredModel, int start, int length) {
        JSONFormatUtil formatUtil = JSONFormatUtil.getInstance();
        if (structuredModel instanceof IJSONModel) {
            IDocumentExtension4 docExt4 = null;
            if (structuredModel.getStructuredDocument() instanceof IDocumentExtension4) {
                docExt4 = (IDocumentExtension4)structuredModel.getStructuredDocument();
            }
            DocumentRewriteSession rewriteSession = null;
            try {
                DocumentRewriteSessionType rewriteType = length > 1000 ? DocumentRewriteSessionType.UNRESTRICTED : DocumentRewriteSessionType.UNRESTRICTED_SMALL;
                rewriteSession = docExt4 == null || docExt4.getActiveRewriteSession() != null ? null : docExt4.startRewriteSession(rewriteType);
                IJSONDocument doc = ((IJSONModel)structuredModel).getDocument();
                IndexedRegion startRegion = ((IJSONModel)structuredModel).getIndexedRegion(start);
                IndexedRegion endRegion = ((IJSONModel)structuredModel).getIndexedRegion(start + length);
                if (startRegion != null && endRegion != null) {
                    int offset;
                    start = startRegion.getStartOffset();
                    if (endRegion instanceof IJSONPair) {
                        offset = endRegion.getEndOffset();
                        IStructuredDocumentRegion nextRegion = structuredModel.getStructuredDocument().getRegionAtCharacterOffset(offset + 1);
                        if (nextRegion.getType() == "JSON_COMMA") {
                            offset = nextRegion.getEndOffset();
                        }
                    } else {
                        offset = endRegion.getEndOffset();
                    }
                    int end = offset - start;
                    IJSONSourceFormatter formatter = JSONSourceFormatterFactory.getInstance().getSourceFormatter(doc);
                    StringBuilder buf = formatter.format(doc, (IRegion)new Region(start, end));
                    if (buf != null) {
                        formatUtil.replaceSource(doc.getModel(), start, end, buf.toString());
                    }
                }
            }
            catch (Throwable throwable) {
                if (docExt4 != null && rewriteSession != null) {
                    docExt4.stopRewriteSession(rewriteSession);
                }
                throw throwable;
            }
            if (docExt4 != null && rewriteSession != null) {
                docExt4.stopRewriteSession(rewriteSession);
            }
        }
    }

    public IStructuredFormatPreferences getFormatPreferences() {
        return null;
    }

    @Override
    protected IStructuredFormatter getFormatter(Node node) {
        return null;
    }

    @Override
    protected void refreshFormatPreferences() {
    }
}

