/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.parser;

import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredTextReParser;
import org.eclipse.wst.sse.core.internal.text.StructuredDocumentReParser;

public class XMLStructuredDocumentReParser
extends StructuredDocumentReParser {
    @Override
    protected IStructuredDocumentRegion findDirtyEnd(int end) {
        IStructuredDocumentRegion result = this.fStructuredDocument.getRegionAtCharacterOffset(end);
        if (result != null && !result.isEnded() && result.getNext() != null) {
            result = result.getNext();
        }
        if (result != null && end == result.getEnd() && result.getNext() != null) {
            result = result.getNext();
        }
        if (this.isLoneOpenFollowedByContent(result) && result.getNext() != null) {
            result = result.getNext();
        }
        if (result != null) {
            this.fStructuredDocument.setCachedDocumentRegion(result);
        }
        this.dirtyEnd = result;
        return this.dirtyEnd;
    }

    @Override
    protected void findDirtyStart(int start) {
        IStructuredDocumentRegion result = this.fStructuredDocument.getRegionAtCharacterOffset(start);
        if (result != null) {
            IStructuredDocumentRegion previous = result.getPrevious();
            if (!(previous == null || previous.isEnded() && start != result.getStart())) {
                result = previous;
            }
            IStructuredDocumentRegion potential = result;
            while (this.isPartOfBlockRegion(potential)) {
                potential = potential.getPrevious();
            }
            if (potential != null) {
                result = potential;
                this.fStructuredDocument.setCachedDocumentRegion(result);
            }
        }
        this.dirtyStart = result;
    }

    protected boolean isLoneOpenFollowedByContent(IStructuredDocumentRegion flatNode) {
        boolean result = false;
        String type = flatNode.getType();
        if (type == "XML_CONTENT") {
            IStructuredDocumentRegion previous = flatNode.getPrevious();
            String previousType = null;
            if (previous != null) {
                previousType = previous.getType();
            }
            if (previousType != null) {
                result = previousType == "XML_TAG_OPEN";
            }
        }
        return result;
    }

    protected boolean isPartOfBlockRegion(IStructuredDocumentRegion flatNode) {
        boolean result = false;
        String type = flatNode.getType();
        result = type == "BLOCK_TEXT";
        return result;
    }

    @Override
    public IStructuredTextReParser newInstance() {
        return new XMLStructuredDocumentReParser();
    }
}

