/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.api.dynamic.sort.internal;

import com.easy.query.core.api.dynamic.sort.ObjectSortBuilder;
import com.easy.query.core.api.dynamic.sort.internal.ObjectSortEntry;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ObjectSortBuilderImpl
implements ObjectSortBuilder {
    private final Map<String, ObjectSortEntry> orderPropertyMap = new LinkedHashMap<String, ObjectSortEntry>();
    private final Set<String> allowedProperties = new HashSet<String>();
    private final Set<String> notAllowedProperties = new HashSet<String>();

    @Override
    public ObjectSortBuilder orderBy(String propertyName, boolean asc, int tableIndex) {
        this.orderPropertyMap.put(propertyName, new ObjectSortEntry(asc, tableIndex));
        return this;
    }

    @Override
    public ObjectSortBuilder allowed(String propertyName) {
        this.allowedProperties.add(propertyName);
        return this;
    }

    @Override
    public ObjectSortBuilder notAllowed(String propertyName) {
        this.notAllowedProperties.add(propertyName);
        return this;
    }

    @Override
    public Map<String, ObjectSortEntry> build() {
        LinkedHashMap<String, ObjectSortEntry> result = new LinkedHashMap<String, ObjectSortEntry>();
        boolean allowedLimit = !this.allowedProperties.isEmpty();
        for (Map.Entry<String, ObjectSortEntry> orderProperty : this.orderPropertyMap.entrySet()) {
            if (this.notAllowedProperties.contains(orderProperty.getKey())) continue;
            if (allowedLimit) {
                if (!this.allowedProperties.contains(orderProperty.getKey())) continue;
                result.put(orderProperty.getKey(), orderProperty.getValue());
                continue;
            }
            result.put(orderProperty.getKey(), orderProperty.getValue());
        }
        return result;
    }

    public void clear() {
        this.orderPropertyMap.clear();
        this.allowedProperties.clear();
        this.notAllowedProperties.clear();
    }
}

