/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.api.internal;

import com.easy.query.core.basic.api.internal.Interceptable;
import com.easy.query.core.basic.api.internal.LogicDeletable;
import com.easy.query.core.basic.api.internal.SQLExecuteExpectRows;
import com.easy.query.core.basic.jdbc.conn.ConnectionManager;
import com.easy.query.core.basic.jdbc.tx.Transaction;
import com.easy.query.core.enums.EasyBehaviorEnum;
import com.easy.query.core.exception.EasyQueryConcurrentException;
import com.easy.query.core.expression.sql.builder.EntityExpressionBuilder;

public abstract class AbstractSQLExecuteRows<TChain>
implements SQLExecuteExpectRows,
Interceptable<TChain>,
LogicDeletable<TChain> {
    private final EntityExpressionBuilder entityExpressionBuilder;

    public AbstractSQLExecuteRows(EntityExpressionBuilder entityExpressionBuilder) {
        this.entityExpressionBuilder = entityExpressionBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeRows(long expectRows, String msg, String code) {
        ConnectionManager connectionManager = this.entityExpressionBuilder.getRuntimeContext().getConnectionManager();
        try (Transaction transaction = null;){
            boolean inTransaction = connectionManager.currentThreadInTransaction();
            if (!inTransaction) {
                transaction = connectionManager.beginTransaction();
            }
            this.doExecuteRows(expectRows, msg, code);
            if (!inTransaction) {
                transaction.commit();
            }
        }
    }

    private void doExecuteRows(long expectRows, String msg, String code) {
        long rows = this.executeRows();
        if (rows != expectRows) {
            throw new EasyQueryConcurrentException(msg, code);
        }
    }

    @Override
    public TChain noInterceptor() {
        this.entityExpressionBuilder.getExpressionContext().noInterceptor();
        return (TChain)this;
    }

    @Override
    public TChain useInterceptor(String name) {
        this.entityExpressionBuilder.getExpressionContext().useInterceptor(name);
        return (TChain)this;
    }

    @Override
    public TChain noInterceptor(String name) {
        this.entityExpressionBuilder.getExpressionContext().noInterceptor(name);
        return (TChain)this;
    }

    @Override
    public TChain useInterceptor() {
        this.entityExpressionBuilder.getExpressionContext().useInterceptor();
        return (TChain)this;
    }

    @Override
    public TChain useLogicDelete(boolean enable) {
        if (enable) {
            this.entityExpressionBuilder.getExpressionContext().getBehavior().addBehavior(EasyBehaviorEnum.LOGIC_DELETE);
        } else {
            this.entityExpressionBuilder.getExpressionContext().getBehavior().removeBehavior(EasyBehaviorEnum.LOGIC_DELETE);
        }
        return (TChain)this;
    }

    public TChain batch(boolean use) {
        if (use) {
            this.entityExpressionBuilder.getExpressionContext().getBehavior().removeBehavior(EasyBehaviorEnum.EXECUTE_NO_BATCH);
            this.entityExpressionBuilder.getExpressionContext().getBehavior().addBehavior(EasyBehaviorEnum.EXECUTE_BATCH);
        } else {
            this.entityExpressionBuilder.getExpressionContext().getBehavior().removeBehavior(EasyBehaviorEnum.EXECUTE_BATCH);
            this.entityExpressionBuilder.getExpressionContext().getBehavior().addBehavior(EasyBehaviorEnum.EXECUTE_NO_BATCH);
        }
        return (TChain)this;
    }
}

