/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.api.select;

import com.easy.query.core.annotation.NotNull;
import com.easy.query.core.annotation.Nullable;
import com.easy.query.core.basic.api.select.QueryAvailable;
import com.easy.query.core.basic.api.select.executor.Fillable;
import com.easy.query.core.basic.api.select.executor.MapAble;
import com.easy.query.core.basic.api.select.executor.QueryExecutable;
import com.easy.query.core.basic.jdbc.executor.internal.enumerable.JdbcStreamResult;
import com.easy.query.core.basic.jdbc.parameter.DefaultToSQLContext;
import com.easy.query.core.basic.jdbc.parameter.ToSQLContext;
import com.easy.query.core.common.ToSQLResult;
import com.easy.query.core.enums.sharding.ConnectionModeEnum;
import com.easy.query.core.expression.lambda.SQLConsumer;
import com.easy.query.core.expression.lambda.SQLFuncExpression;
import com.easy.query.core.expression.lambda.SQLFuncExpression1;
import com.easy.query.core.expression.sql.TableContext;
import com.easy.query.core.expression.sql.builder.EntityQueryExpressionBuilder;
import com.easy.query.core.expression.sql.fill.FillExpression;
import com.easy.query.core.expression.sql.fill.FillParams;
import com.easy.query.core.util.EasyObjectUtil;
import com.easy.query.core.util.EasySQLExpressionUtil;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;

public interface Query<T>
extends QueryAvailable<T>,
QueryExecutable<T>,
MapAble<T>,
Fillable<T> {
    public Query<T> cloneQueryable();

    public EntityQueryExpressionBuilder getSQLEntityExpressionBuilder();

    public Query<T> select(String var1);

    default public String toSQL() {
        return this.toSQL(this.queryClass());
    }

    default public String toSQL(ToSQLContext toSQLContext) {
        return this.toSQL(this.queryClass(), toSQLContext);
    }

    default public ToSQLResult toSQLResult() {
        ToSQLContext toSQLContext = DefaultToSQLContext.defaultToSQLContext(this.getSQLEntityExpressionBuilder().getExpressionContext().getTableContext());
        String sql = this.toSQL(this.queryClass(), toSQLContext);
        return new ToSQLResult(sql, toSQLContext);
    }

    default public <TR> String toSQL(Class<TR> resultClass) {
        TableContext tableContext = this.getSQLEntityExpressionBuilder().getExpressionContext().getTableContext();
        return this.toSQL(resultClass, DefaultToSQLContext.defaultToSQLContext(tableContext));
    }

    public <TR> String toSQL(Class<TR> var1, ToSQLContext var2);

    public long count();

    default public int intCount() {
        return (int)this.count();
    }

    public boolean any();

    default public void required() {
        this.required(null, null);
    }

    default public void required(String msg) {
        this.required(() -> this.getSQLEntityExpressionBuilder().getRuntimeContext().getAssertExceptionFactory().createRequiredException(this, msg, null));
    }

    default public void required(String msg, String code) {
        this.required(() -> this.getSQLEntityExpressionBuilder().getRuntimeContext().getAssertExceptionFactory().createRequiredException(this, msg, code));
    }

    default public void required(Supplier<RuntimeException> throwFunc) {
        boolean any = this.any();
        if (!any) {
            throw throwFunc.get();
        }
    }

    @Override
    @Nullable
    default public T firstOrNull() {
        return this.firstOrNull(this.queryClass());
    }

    @Override
    @NotNull
    default public T firstNotNull(String msg, String code) {
        return this.firstNotNull(this.queryClass(), msg, code);
    }

    @Override
    @NotNull
    default public <TR> TR firstNotNull(Class<TR> resultClass, String msg, String code) {
        return this.firstNotNull(resultClass, () -> this.getSQLEntityExpressionBuilder().getRuntimeContext().getAssertExceptionFactory().createFirstNotNullException(this, msg, code));
    }

    @Override
    @NotNull
    default public T firstNotNull(Supplier<RuntimeException> throwFunc) {
        return this.firstNotNull(this.queryClass(), throwFunc);
    }

    @Override
    @Nullable
    default public T singleOrNull() {
        return this.singleOrNull(this.queryClass());
    }

    default public Optional<T> singleOptional() {
        return Optional.ofNullable(this.singleOrNull(this.queryClass()));
    }

    default public T singleOrDefault(T defaultValue) {
        Object singleOrNull = this.singleOrNull(this.queryClass());
        return singleOrNull == null ? defaultValue : singleOrNull;
    }

    default public T singleOrDefault(T defaultValue, @Nullable @Nullable Predicate<@Nullable T> usingDefault) {
        Object singleOrNullValue = this.singleOrNull(this.queryClass());
        return usingDefault != null && usingDefault.test(singleOrNullValue) ? defaultValue : singleOrNullValue;
    }

    @Override
    @NotNull
    default public T singleNotNull(String msg, String code) {
        return this.singleNotNull(this.queryClass(), msg, code);
    }

    @Override
    @NotNull
    default public <TR> TR singleNotNull(Class<TR> resultClass, String msg, String code) {
        return this.singleNotNull(resultClass, () -> this.getSQLEntityExpressionBuilder().getRuntimeContext().getAssertExceptionFactory().createSingleNotNullException(this, msg, code));
    }

    @Override
    @NotNull
    default public T singleNotNull(Supplier<RuntimeException> throwFunc) {
        return this.singleNotNull(this.queryClass(), throwFunc);
    }

    @Override
    @NotNull
    default public T findNotNull(Object id, String msg, String code) {
        return this.findNotNull(id, () -> this.getSQLEntityExpressionBuilder().getRuntimeContext().getAssertExceptionFactory().createFindNotNullException(this, msg, code));
    }

    @Override
    @NotNull
    default public List<T> toList() {
        return this.toList(this.queryClass(), this.queryEntityMetadata());
    }

    @Override
    @NotNull
    default public JdbcStreamResult<T> toStreamResult(SQLConsumer<Statement> configurer) {
        return this.toStreamResult(this.queryClass(), configurer);
    }

    @NotNull
    default public Query<T> distinct() {
        return this.distinct(true);
    }

    @NotNull
    public Query<T> distinct(boolean var1);

    default public Query<T> limit(long rows) {
        return this.limit(true, rows);
    }

    default public Query<T> limit(boolean condition, long rows) {
        return this.limit(condition, 0L, rows);
    }

    default public Query<T> limit(long offset, long rows) {
        return this.limit(true, offset, rows);
    }

    public Query<T> limit(boolean var1, long var2, long var4);

    public Query<T> asTracking();

    public Query<T> asNoTracking();

    public Query<T> useShardingConfigure(int var1, ConnectionModeEnum var2);

    public Query<T> useMaxShardingQueryLimit(int var1);

    public Query<T> useConnectionMode(ConnectionModeEnum var1);

    @Override
    default public <TREntity> Query<T> fillMany(SQLFuncExpression<Query<TREntity>> fillSetterExpression, String targetProperty, String selfProperty, BiConsumer<T, Collection<TREntity>> produce, boolean consumeNull) {
        SQLFuncExpression1<FillParams, Query<?>> fillQueryableExpression = EasySQLExpressionUtil.getFillSQLExpression(fillSetterExpression, targetProperty, consumeNull);
        FillExpression fillExpression = new FillExpression(this.queryClass(), true, targetProperty, selfProperty, fillQueryableExpression);
        fillExpression.setProduceMany((BiConsumer)EasyObjectUtil.typeCastNullable(produce));
        this.getSQLEntityExpressionBuilder().getExpressionContext().getFills().add(fillExpression);
        return this;
    }

    @Override
    default public <TREntity> Query<T> fillOne(SQLFuncExpression<Query<TREntity>> fillSetterExpression, String targetProperty, String selfProperty, BiConsumer<T, TREntity> produce, boolean consumeNull) {
        SQLFuncExpression1<FillParams, Query<?>> fillQueryableExpression = EasySQLExpressionUtil.getFillSQLExpression(fillSetterExpression, targetProperty, consumeNull);
        FillExpression fillExpression = new FillExpression(this.queryClass(), false, targetProperty, selfProperty, fillQueryableExpression);
        fillExpression.setProduceOne((BiConsumer)EasyObjectUtil.typeCastNullable(produce));
        this.getSQLEntityExpressionBuilder().getExpressionContext().getFills().add(fillExpression);
        return this;
    }
}

