/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.extension.conversion;

import com.easy.query.core.basic.extension.conversion.ColumnValueSQLConverter;
import com.easy.query.core.basic.extension.conversion.ExpArg;
import com.easy.query.core.basic.extension.conversion.ExpArgTypeEnum;
import com.easy.query.core.basic.extension.conversion.SQLPropertyConverter;
import com.easy.query.core.basic.jdbc.parameter.SQLParameter;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.parser.core.base.SimpleSQLTableOwner;
import com.easy.query.core.expression.parser.core.base.scec.SQLNativePropertyExpressionContext;
import com.easy.query.core.metadata.ColumnMetadata;
import java.util.List;

public class EasyColumnValueSQLConverter
implements ColumnValueSQLConverter {
    private final String sql;
    private final boolean realColumn;
    private final List<ExpArg> expArgs;

    public EasyColumnValueSQLConverter(String sql, boolean realColumn, List<ExpArg> expArgs) {
        this.sql = sql;
        this.realColumn = realColumn;
        this.expArgs = expArgs;
    }

    @Override
    public boolean isRealColumn() {
        return this.realColumn;
    }

    private void accept(TableAvailable table, SQLNativePropertyExpressionContext context) {
        context.keepStyle();
        for (ExpArg expArg : this.expArgs) {
            if (expArg.argType == ExpArgTypeEnum.PROPERTY) {
                context.expression(new SimpleSQLTableOwner(table), expArg.prop);
                continue;
            }
            if (expArg.argType != ExpArgTypeEnum.VALUE) continue;
            context.value(expArg.value);
        }
    }

    @Override
    public void selectColumnConvert(TableAvailable table, ColumnMetadata columnMetadata, SQLPropertyConverter sqlPropertyConverter, QueryRuntimeContext runtimeContext) {
        sqlPropertyConverter.sqlNativeSegment(this.sql, context -> {
            this.accept(table, (SQLNativePropertyExpressionContext)context);
            context.setAlias(columnMetadata.getName());
        });
    }

    @Override
    public void propertyColumnConvert(TableAvailable table, ColumnMetadata columnMetadata, SQLPropertyConverter sqlPropertyConverter, QueryRuntimeContext runtimeContext) {
        if (this.isRealColumn()) {
            sqlPropertyConverter.sqlNativeSegment("{0}", c -> {
                SQLNativePropertyExpressionContext cfr_ignored_0 = (SQLNativePropertyExpressionContext)c.expression(new SimpleSQLTableOwner(table), columnMetadata.getPropertyName());
            });
        } else {
            sqlPropertyConverter.sqlNativeSegment(this.sql, context -> this.accept(table, (SQLNativePropertyExpressionContext)context));
        }
    }

    @Override
    public void valueConvert(TableAvailable table, ColumnMetadata columnMetadata, SQLParameter sqlParameter, SQLPropertyConverter sqlPropertyConverter, QueryRuntimeContext runtimeContext, boolean isCompareValue) {
        sqlPropertyConverter.sqlNativeSegment("{0}", context -> context.value(sqlParameter));
    }
}

