/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.extension.encryption;

import com.easy.query.core.basic.extension.encryption.EncryptionStrategy;
import com.easy.query.core.logging.Log;
import com.easy.query.core.logging.LogFactory;
import com.easy.query.core.util.EasyAesUtil;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasyStringUtil;
import java.nio.charset.StandardCharsets;
import java.util.List;

public abstract class AbstractUnSupportEmojiAesBase64EncryptionStrategy
implements EncryptionStrategy {
    private static final Log log = LogFactory.getLog(AbstractUnSupportEmojiAesBase64EncryptionStrategy.class);

    public abstract String getIv();

    public abstract String getKey();

    public int encryptWordMinLength() {
        return 4;
    }

    public int chineseCharOccupancyLength() {
        return 2;
    }

    public int otherCharOccupancyLength() {
        return 1;
    }

    public boolean throwIfDecryptFail() {
        return true;
    }

    @Override
    public Object encrypt(Class<?> entityClass, String propertyName, Object plaintext) {
        if (plaintext == null) {
            return null;
        }
        try {
            return this.doEncrypt(plaintext);
        }
        catch (Exception exception) {
            log.error(EasyClassUtil.getInstanceSimpleName(this) + " " + EasyClassUtil.getSimpleName(entityClass) + ".." + propertyName + " decrypt error:" + plaintext, exception);
            throw exception;
        }
    }

    protected Object doEncrypt(Object plaintext) {
        String plaintextString = plaintext.toString();
        List<String> stringCharSegments = EasyStringUtil.getStringCharSegments(plaintextString, this.encryptWordMinLength(), this.otherCharOccupancyLength(), this.chineseCharOccupancyLength());
        if (EasyCollectionUtil.isEmpty(stringCharSegments)) {
            stringCharSegments.add(plaintextString);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String stringCharSegment : stringCharSegments) {
            String str = EasyAesUtil.encrypt(stringCharSegment, this.getKey(), this.getIv(), StandardCharsets.UTF_8);
            stringBuilder.append(str);
        }
        return stringBuilder.toString();
    }

    @Override
    public Object decrypt(Class<?> entityClass, String propertyName, Object ciphertext) {
        try {
            return this.doDecrypt(entityClass, propertyName, ciphertext);
        }
        catch (Exception exception) {
            log.error(EasyClassUtil.getInstanceSimpleName(this) + " " + EasyClassUtil.getSimpleName(entityClass) + ".." + propertyName + " decrypt error:" + ciphertext, exception);
            if (this.throwIfDecryptFail()) {
                throw exception;
            }
            return ciphertext;
        }
    }

    private Object doDecrypt(Class<?> entityClass, String propertyName, Object ciphertext) {
        if (ciphertext == null) {
            return null;
        }
        String ciphertextString = ciphertext.toString();
        if (ciphertextString.length() % 24 != 0) {
            if (this.throwIfDecryptFail()) {
                throw new IllegalArgumentException(EasyClassUtil.getSimpleName(entityClass) + "." + propertyName + " decrypt cant decode base64:" + ciphertext);
            }
            return ciphertext;
        }
        List<String> segments = EasyStringUtil.splitBase64ByGroupSize(ciphertextString, 24);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < segments.size(); ++i) {
            boolean last;
            String str = EasyAesUtil.decrypt(segments.get(i), this.getKey(), this.getIv(), StandardCharsets.UTF_8);
            boolean bl = last = i == segments.size() - 1;
            if (last) {
                stringBuilder.append(str);
                continue;
            }
            stringBuilder.append(str.charAt(0));
        }
        return stringBuilder.toString();
    }
}

