/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.extension.track;

import com.easy.query.core.basic.extension.track.DefaultTrackContext;
import com.easy.query.core.basic.extension.track.TrackContext;
import com.easy.query.core.basic.extension.track.TrackManager;
import com.easy.query.core.exception.EasyQueryException;
import com.easy.query.core.metadata.EntityMetadataManager;

public class DefaultTrackManager
implements TrackManager {
    private final ThreadLocal<TrackContext> threadTC = ThreadLocal.withInitial(() -> null);
    private final EntityMetadataManager entityMetadataManager;

    public DefaultTrackManager(EntityMetadataManager entityMetadataManager) {
        this.entityMetadataManager = entityMetadataManager;
    }

    @Override
    public void begin() {
        TrackContext trackContext = this.threadTC.get();
        if (trackContext == null) {
            trackContext = new DefaultTrackContext(this.entityMetadataManager);
            this.threadTC.set(trackContext);
        }
        trackContext.begin();
    }

    @Override
    public TrackContext getCurrentTrackContext() {
        return this.threadTC.get();
    }

    @Override
    public void release() {
        TrackContext trackContext = this.getCurrentTrackContext();
        if (trackContext == null) {
            throw new EasyQueryException("current thread not begin track");
        }
        if (trackContext.release()) {
            this.threadTC.remove();
        }
    }
}

