/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.jdbc.conn.impl;

import com.easy.query.core.basic.jdbc.conn.ConnectionManager;
import com.easy.query.core.basic.jdbc.conn.EasyConnection;
import com.easy.query.core.basic.jdbc.conn.EasyConnectionFactory;
import com.easy.query.core.basic.jdbc.conn.EasyDataSourceConnection;
import com.easy.query.core.basic.jdbc.conn.EasyDataSourceConnectionFactory;
import com.easy.query.core.basic.jdbc.tx.DefaultTransaction;
import com.easy.query.core.basic.jdbc.tx.Transaction;
import com.easy.query.core.enums.conn.ConnectionStrategyEnum;
import com.easy.query.core.exception.EasyQueryException;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.exception.EasyQuerySQLCommandException;
import com.easy.query.core.sharding.EasyQueryDataSource;
import java.util.Collections;
import java.util.List;

public class DefaultConnectionManager
implements ConnectionManager {
    protected final ThreadLocal<Transaction> threadTx = ThreadLocal.withInitial(() -> null);
    protected final ThreadLocal<EasyDataSourceConnection> threadDataSourceConnection = ThreadLocal.withInitial(() -> null);
    protected final EasyQueryDataSource easyDataSource;
    protected final EasyConnectionFactory easyConnectionFactory;
    protected final EasyDataSourceConnectionFactory easyDataSourceConnectionFactory;

    public DefaultConnectionManager(EasyQueryDataSource easyDataSource, EasyConnectionFactory easyConnectionFactory, EasyDataSourceConnectionFactory easyDataSourceConnectionFactory) {
        this.easyDataSource = easyDataSource;
        this.easyConnectionFactory = easyConnectionFactory;
        this.easyDataSourceConnectionFactory = easyDataSourceConnectionFactory;
    }

    @Override
    public Transaction beginTransaction(Integer isolationLevel) {
        if (this.currentThreadInTransaction()) {
            throw new EasyQuerySQLCommandException("repeat begin transaction");
        }
        DefaultTransaction defaultTransaction = new DefaultTransaction(isolationLevel, this);
        this.threadTx.set(defaultTransaction);
        return defaultTransaction;
    }

    @Override
    public List<EasyConnection> getEasyConnections(int count, String dataSourceName, ConnectionStrategyEnum connectionStrategy) {
        if (ConnectionStrategyEnum.ShareConnection.equals((Object)connectionStrategy)) {
            if (count != 1) {
                throw new EasyQueryInvalidOperationException("ConnectionStrategyEnum.ShareConnection get connections should 1");
            }
            Transaction transaction = this.threadTx.get();
            if (transaction != null) {
                EasyConnection easyConnection;
                EasyDataSourceConnection easyDataSourceConnection = this.threadDataSourceConnection.get();
                if (easyDataSourceConnection == null) {
                    easyDataSourceConnection = this.easyDataSourceConnectionFactory.create();
                    this.threadDataSourceConnection.set(easyDataSourceConnection);
                }
                if ((easyConnection = easyDataSourceConnection.getEasyConnectionOrNull(dataSourceName)) == null) {
                    easyConnection = this.easyConnectionFactory.createEasyConnection(dataSourceName, transaction.getIsolationLevel(), connectionStrategy);
                    easyConnection.setAutoCommit(false);
                    easyDataSourceConnection.putIfAbsent(dataSourceName, easyConnection);
                }
                return Collections.singletonList(easyConnection);
            }
        }
        return this.easyConnectionFactory.createEasyConnections(count, dataSourceName, null, connectionStrategy);
    }

    @Override
    public Transaction getTransactionOrNull() {
        return this.threadTx.get();
    }

    @Override
    public boolean currentThreadInTransaction() {
        return this.isOpenTransaction();
    }

    @Override
    public void clear() {
        this.threadDataSourceConnection.remove();
        this.threadTx.remove();
    }

    @Override
    public void closeEasyConnection(EasyConnection easyConnection) {
        if (easyConnection == null) {
            return;
        }
        if (!this.isOpenTransaction()) {
            try {
                easyConnection.close();
            }
            catch (Exception e) {
                throw new EasyQueryException(e);
            }
        }
    }

    @Override
    public void commit() {
        EasyDataSourceConnection easyDataSourceConnection = this.threadDataSourceConnection.get();
        if (easyDataSourceConnection == null) {
            this.clear();
            return;
        }
        try {
            try {
                easyDataSourceConnection.commit();
            }
            finally {
                easyDataSourceConnection.close();
            }
        }
        finally {
            this.clear();
        }
    }

    @Override
    public void rollback() {
        EasyDataSourceConnection easyDataSourceConnection = this.threadDataSourceConnection.get();
        if (easyDataSourceConnection == null) {
            this.clear();
            return;
        }
        try {
            try {
                easyDataSourceConnection.rollback();
            }
            finally {
                easyDataSourceConnection.close();
            }
        }
        finally {
            this.clear();
        }
    }
}

